---
title: "XML attributes cannot be selected from type &#39;type&#39; | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "bc36808"
  - "vbc36808"
helpviewer_keywords: 
  - "BC36808"
ms.assetid: 76b2605c-3d9b-4e56-ba3f-99c60c668290
caps.latest.revision: 6
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# XML attributes cannot be selected from type &#39;type&#39;
An XML attribute has been referenced for an object that is not of type <xref:System.Xml.Linq.XElement> or `IEnumerable(Of XElement)`. For more information, see [XML Attribute Axis Property](../../visual-basic/language-reference/xml-axis/xml-attribute-axis-property.md).  
  
```vb  
' Generates an error.  
Dim var = "sample text".@attr  
```  
  
 **Error ID:** BC36808  
  
## To correct this error  
  
-   Ensure that the object of which you are referencing an attribute is strongly typed as <xref:System.Xml.Linq.XElement> or `IEnumerable(Of XElement)`. Following is an example:  
  
```vb  
Dim elem As XElement = <root attr="value"/>  
Dim var = elem.@attr  
```  
  
## See Also  
 [XML Attribute Axis Property](../../visual-basic/language-reference/xml-axis/xml-attribute-axis-property.md)   
 [XML Axis Properties](../../visual-basic/language-reference/xml-axis/xml-axis-properties.md)   
 [XML](../../visual-basic/programming-guide/language-features/xml/index.md)