---
title: "Extension method &#39;&lt;methodname&gt;&#39; defined in &#39;&lt;modulename&gt;&#39; is not generic (or has no free type parameters) and so cannot have type arguments | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "bc36907"
  - "vbc36907"
helpviewer_keywords: 
  - "BC36907"
ms.assetid: 45191e93-89d1-48ec-99a5-ff9661a2a6ee
caps.latest.revision: 7
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Extension method &#39;&lt;methodname&gt;&#39; defined in &#39;&lt;modulename&gt;&#39; is not generic (or has no free type parameters) and so cannot have type arguments
A type argument has been specified in a call to an extension method that either has no generic parameters or has no generic parameters for which a type is not already specified. For example, the following code causes this error.  
  
```vb  
' The extension method is not generic.  
<Extension()> _  
Sub Example(ByVal str As String)  
    ' Body of the Sub.  
End Sub  
```  
  
```vb  
Dim str = "hi"  
'' The call to Example specifies a type argument.  
'' Not valid.  
'str.Example(Of String)()  
```  
  
 **Error ID:** BC36907  
  
## To correct this error  
  
-   Add a type parameter to the extension method definition.  
  
-   Remove the extra type argument from the procedure call.  
  
## See Also  
 [Extension Methods](../../visual-basic/programming-guide/language-features/procedures/extension-methods.md)   
 [Generic Procedures in Visual Basic](../../visual-basic/programming-guide/language-features/data-types/generic-procedures.md)