---
title: "&lt;type1&gt; &#39;&lt;propertyname&gt;&#39; conflicts with a member implicitly declared for event &#39;&lt;eventname&gt;&#39; in the base &lt;type2&gt; &#39;&lt;classname&gt;&#39; | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "vbc40014"
  - "bc40014"
helpviewer_keywords: 
  - "BC40014"
ms.assetid: 100534b9-d533-4e94-a2a7-0ed26426965b
caps.latest.revision: 10
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# &lt;type1&gt; &#39;&lt;propertyname&gt;&#39; conflicts with a member implicitly declared for event &#39;&lt;eventname&gt;&#39; in the base &lt;type2&gt; &#39;&lt;classname&gt;&#39;
A property is declared with the same name as an implicit member formed from an event in the base class. For example, if the base class defines an event named `Event1`, the compiler generates the implicit procedures `add_Event1` and `remove_Event1`. If the property in this class has one of these names, it should shadow the base class member.  
  
 This message is a warning. `Shadows` is assumed by default. For more information on hiding warnings or treating warnings as errors, see [Configuring Warnings in Visual Basic](https://docs.microsoft.com/visualstudio/ide/configuring-warnings-in-visual-basic).  
  
 **Error ID:** BC40014  
  
## To correct this error  
  
1.  To hide the base class member, add the `Shadows` keyword to the property declaration.  
  
2.  If you do not intend to hide the base class member, change the property name.  
  
## See Also  
 [Property Statement](../../visual-basic/language-reference/statements/property-statement.md)   
 [Event Statement](../../visual-basic/language-reference/statements/event-statement.md)   
 [Shadows](../../visual-basic/language-reference/modifiers/shadows.md)   
 [Shadowing in Visual Basic](../../visual-basic/programming-guide/language-features/declared-elements/shadowing.md)