---
title: "Non-CLS-compliant &#39;MustOverride&#39; member is not allowed in a CLS-compliant &lt;classname&gt; | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "bc40034"
  - "vbc40034"
helpviewer_keywords: 
  - "BC40034"
ms.assetid: 4eb36b3a-1bbe-4e99-9ecb-a12b8729b128
caps.latest.revision: 9
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Non-CLS-compliant &#39;MustOverride&#39; member is not allowed in a CLS-compliant &lt;classname&gt;
A class is marked as `<CLSCompliant(True)>`, but it contains a `MustOverride` property or procedure that is marked as `<CLSCompliant(False)>` or is not marked.  
  
 When a class is compliant with the [Language Independence and Language-Independent Components](https://msdn.microsoft.com/library/12a7a7h3) (CLS), an application that uses that class accesses only the members that are also marked as `<CLSCompliant(True)>` and ignores the members that are not. However, the application cannot ignore a `MustOverride` property or procedure, because it must access that property or procedure to override it.  
  
 When you apply the <xref:System.CLSCompliantAttribute> to a programming element, you set the attribute's `isCompliant` parameter to either `True` or `False` to indicate compliance or noncompliance. There is no default for this parameter, and you must supply a value.  
  
 If you do not apply the <xref:System.CLSCompliantAttribute> to an element, it is considered to be noncompliant.  
  
 By default, this message is a warning. For information on hiding warnings or treating warnings as errors, see [Configuring Warnings in Visual Basic](https://docs.microsoft.com/visualstudio/ide/configuring-warnings-in-visual-basic).  
  
 **Error ID:** BC40034  
  
## To correct this error  
  
-   If you require CLS compliance and have control over the class source code, mark the member as `<CLSCompliant(True)>`.  
  
-   If you require CLS compliance and do not have control over the class source code, or if it does not qualify to be compliant, define this member within a different class.  
  
-   If you require that this member remain noncompliant, remove the `MustOverride` keyword from its definition, remove the <xref:System.CLSCompliantAttribute> from the class definition, or mark the class as `<CLSCompliant(False)>`.  
  
## See Also  
 [MustOverride](../../visual-basic/language-reference/modifiers/mustoverride.md)   
 [\<PAVE OVER> Writing CLS-Compliant Code](http://msdn.microsoft.com/en-us/4c705105-69a2-4e5e-b24e-0633bc32c7f3)