---
title: "Variable &#39;&lt;variablename&gt;&#39; is passed by reference before it has been assigned a value (Structure Variable) | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "bc42108"
  - "vbc42108"
helpviewer_keywords: 
  - "BC42108"
ms.assetid: 8f858dd7-db04-408e-ae67-e4ff2f0e5e30
caps.latest.revision: 8
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Variable &#39;&lt;variablename&gt;&#39; is passed by reference before it has been assigned a value (Structure Variable)
Variable '\<variablename>' is passed by reference before it has been assigned a value. A null reference exception could result at runtime. Make sure the structure or all the reference members are initialized before use  
  
 A procedure call passes a structure variable as an argument to a `ByRef` parameter before any value is assigned to the variable.  
  
 If a structure variable has never been assigned a value, each structure member holds the default value for its data type. For a reference data type, that default value is [Nothing](../../visual-basic/language-reference/nothing.md). Reading a reference member that has a value of `Nothing` can cause a <xref:System.NullReferenceException> in some circumstances.  
  
 Passing an argument to a procedure `ByRef` exposes the variable underlying the argument to possible modification by the procedure.  
  
 By default, this message is a warning. For more information about hiding warnings or treating warnings as errors, please see [Configuring Warnings in Visual Basic](https://docs.microsoft.com/visualstudio/ide/configuring-warnings-in-visual-basic).  
  
 **Error ID:** BC42108  
  
## To correct this error  
  
-   If you intend the procedure to assign values to structure members through the `ByRef` argument, and if it does not matter whether the members already hold values, then no action is necessary.  
  
-   If the logic in the procedure reads a structure member before assigning any value to it, and if the member is of a value type, then make sure that the procedure logic does not depend on whether the member holds its default value or not.  
  
-   If the logic in the procedure reads a structure member before assigning any value to it, and if the member is of a reference type, then make sure that the procedure logic can handle a value of `Nothing`. For example, it could use a [Try...Catch...Finally Statement](../../visual-basic/language-reference/statements/try-catch-finally-statement.md) to catch a <xref:System.NullReferenceException>.  
  
## See Also  
 [Dim Statement](../../visual-basic/language-reference/statements/dim-statement.md)   
 [Value Types and Reference Types](../../visual-basic/programming-guide/language-features/data-types/value-types-and-reference-types.md)   
 [Passing Arguments by Value and by Reference](../../visual-basic/programming-guide/language-features/procedures/passing-arguments-by-value-and-by-reference.md)   
 [ByRef](../../visual-basic/language-reference/modifiers/byref.md)   
 [Variable Declaration](../../visual-basic/programming-guide/language-features/variables/variable-declaration.md)   
 [Structures](../../visual-basic/programming-guide/language-features/data-types/structures.md)   
 [Structure Statement](../../visual-basic/language-reference/statements/structure-statement.md)   
 [Troubleshooting Variables](../../visual-basic/programming-guide/language-features/variables/troubleshooting-variables.md)