---
title: "Programming Concepts (Visual Basic) | Microsoft Docs"
ms.custom: ""
ms.date: "2015-07-20"
ms.prod: .net
ms.reviewer: ""
ms.suite: ""
ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
dev_langs: 
  - "VB"
ms.assetid: cc9cac84-61f6-476e-b8c7-9bae7749bd90
caps.latest.revision: 4
author: "stevehoag"
ms.author: "shoag"

translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Programming Concepts (Visual Basic)
This section explains programming concepts in the Visual Basic language.  
  
## In This Section  
  
|Title|Description|  
|-----------|-----------------|  
|[Assemblies and the Global Assembly Cache (Visual Basic)](../../../visual-basic/programming-guide/concepts/assemblies-gac/index.md)|Describes how to create and use assemblies.|  
|[Asynchronous Programming with Async and Await (Visual Basic)](../../../visual-basic/programming-guide/concepts/async/index.md)|Describes how to write asynchronous solutions by using [Async](../../../visual-basic/language-reference/modifiers/async.md) and [Await](../../../visual-basic/language-reference/operators/await-operator.md) keywords. Includes a walkthrough.|  
|[Attributes overview (Visual Basic)](../../../visual-basic/programming-guide/concepts/attributes/index.md)|Discusses how to provide additional information about programming elements such as types, fields, methods, and properties by using attributes.|  
|[Caller Information (Visual Basic)](../../../visual-basic/programming-guide/concepts/caller-information.md)|Describes how to obtain information about the caller of a method. This information includes the file path and the line number of the source code and the member name of the caller.|  
|[Collections (Visual Basic)](../../../visual-basic/programming-guide/concepts/collections.md)|Describes some of the types of collections provided by the .NET Framework. Demonstrates how to use simple collections and collections of key/value pairs.|  
|[Covariance and Contravariance (Visual Basic)](../../../visual-basic/programming-guide/concepts/covariance-contravariance/covariance-and-contravariance.md)|Shows how to enable implicit conversion of generic type parameters in interfaces and delegates.|  
|[Expression Trees (Visual Basic)](../../../visual-basic/programming-guide/concepts/expression-trees/index.md)|Explains how you can use expression trees to enable dynamic modification of executable code.|  
|[Iterators (Visual Basic)](../../../visual-basic/programming-guide/concepts/iterators.md)|Describes iterators, which are used to step through collections and return elements one at a time.|  
|[Language-Integrated Query (LINQ) (Visual Basic)](../../../visual-basic/programming-guide/concepts/linq/index.md)|Discusses the powerful query capabilities in the language syntax of Visual Basic, and themodel for querying relational databases, XML documents, datasets, and in-memory collections.|  
|[Object-Oriented Programming (Visual Basic)](../../../visual-basic/programming-guide/concepts/object-oriented-programming.md)|Describes common object-oriented concepts, including encapsulation, inheritance, and polymorphism.|  
|[Reflection (Visual Basic)](../../../visual-basic/programming-guide/concepts/reflection.md)|Explains how to use reflection to dynamically create an instance of a type, bind the type to an existing object, or get the type from an existing object and invoke its methods or access its fields and properties.|  
|[Serialization (Visual Basic)](../../../visual-basic/programming-guide/concepts/serialization/index.md)|Describes key concepts in binary, XML, and SOAP serialization.|  
|[Threading (Visual Basic)](../../../visual-basic/programming-guide/concepts/threading/index.md)|Provides an overview of the .NET threading model and shows how to write code that performs multiple tasks at the same time to improve the performance and responsiveness of your applications.|  
  
## Related Sections  
  
|||  
|---|---|  
|[Performance Tips](https://msdn.microsoft.com/library/ms173196(VS.110).aspx) | Discusses several basic rules that may help you increase the performance of your application.|