---
title: "Visual Basic Language Features | Microsoft Docs"
ms.custom: ""
ms.date: "2015-07-20"
ms.prod: .net
ms.reviewer: ""
ms.suite: ""
ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
dev_langs: 
  - "VB"
helpviewer_keywords: 
  - "Visual Basic code, elements of"
  - "Visual Basic code"
ms.assetid: b0b21730-298c-47e6-9a2f-cc81f628067b
caps.latest.revision: 18
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Visual Basic Language Features
The following topics introduce and discuss the essential components of [!INCLUDE[vbprvb](../../../csharp/programming-guide/concepts/linq/includes/vbprvb_md.md)], an object-oriented programming language. After creating the user interface for your application using forms and controls, you need to write the code that defines the application's behavior. As with any modern programming language, [!INCLUDE[vbprvb](../../../csharp/programming-guide/concepts/linq/includes/vbprvb_md.md)] supports a number of common programming constructs and language elements.  
  
 If you have programmed in other languages, much of the material covered in this section might seem familiar. While most of the constructs are similar to those in other languages, the event-driven nature of [!INCLUDE[vbprvb](../../../csharp/programming-guide/concepts/linq/includes/vbprvb_md.md)] introduces some subtle differences.  
  
 If you are new to programming, the material in this section serves as an introduction to the basic building blocks for writing code. Once you understand the basics, you can create powerful applications using [!INCLUDE[vbprvb](../../../csharp/programming-guide/concepts/linq/includes/vbprvb_md.md)].  
  
## In This Section  
 [Arrays](../../../visual-basic/programming-guide/language-features/arrays/index.md)  
 Discusses making your code more compact and powerful by declaring and using arrays, which hold multiple related values.  
  
 [Collection Initializers](../../../visual-basic/programming-guide/language-features/collection-initializers/index.md)  
 Describes collection initializers, which enable you to create a collection and populate it with an initial set of values.  
  
 [Constants and Enumerations](../../../visual-basic/programming-guide/language-features/constants-enums/index.md)  
 Discusses storing unchanging values for repeated use, including sets of related constant values.  
  
 [Control Flow](../../../visual-basic/programming-guide/language-features/control-flow/index.md)  
 Shows how to regulate the flow of your program's execution.  
  
 [Data Types](../../../visual-basic/programming-guide/language-features/data-types/index.md)  
 Describes what kinds of data a programming element can hold and how that data is stored.  
  
 [Declared Elements](../../../visual-basic/programming-guide/language-features/declared-elements/index.md)  
 Covers programming elements you can declare, their names and characteristics, and how the compiler resolves references to them.  
  
 [Delegates](../../../visual-basic/programming-guide/language-features/delegates/index.md)  
 Provides an introduction to delegates and how they are used in Visual Basic.  
  
 [Early and Late Binding](../../../visual-basic/programming-guide/language-features/early-late-binding/index.md)  
 Describes binding, which is performed by the compiler when an object is assigned to an object variable, and the differences between early-bound and late-bound objects.  
  
 [Error Types](../../../visual-basic/programming-guide/language-features/error-types.md)  
 Provides an overview of syntax errors, run-time errors, and logic errors.  
  
 [Events](../../../visual-basic/programming-guide/language-features/events/index.md)  
 Shows how to declare and use events.  
  
 [Interfaces](../../../visual-basic/programming-guide/language-features/interfaces/index.md)  
 Describes what interfaces are and how you can use them in your applications.  
  
 [LINQ](../../../visual-basic/programming-guide/language-features/linq/index.md)  
 Provides links to topics that introduce [!INCLUDE[vbteclinqext](../../../csharp/getting-started/includes/vbteclinqext_md.md)] features and programming.  
  
 [Objects and Classes](../../../visual-basic/programming-guide/language-features/objects-and-classes/index.md)  
 Provides an overview of objects and classes, how they are used, their relationships to each other, and the properties, methods, and events they expose.  
  
 [Operators and Expressions](../../../visual-basic/programming-guide/language-features/operators-and-expressions/index.md)  
 Describes the code elements that manipulate value-holding elements, how to use them efficiently, and how to combine them to yield new values.  
  
 [Procedures](../../../visual-basic/programming-guide/language-features/procedures/index.md)  
 Describes `Sub`, `Function`, `Property`, and `Operator` procedures, as well as advanced topics such as recursive and overloaded procedures.  
  
 [Statements](../../../visual-basic/programming-guide/language-features/statements.md)  
 Describes declaration and executable statements.  
  
 [Strings](../../../visual-basic/programming-guide/language-features/strings/index.md)  
 Provides links to topics that describe the basic concepts about using strings in Visual Basic.  
  
 [Variables](../../../visual-basic/programming-guide/language-features/variables/index.md)  
 Introduces variables and describes how to use them in Visual Basic.  
  
 [XML](../../../visual-basic/programming-guide/language-features/xml/index.md)  
 Provides links to topics that describe how to use XML in Visual Basic.  
  
## Related Sections  
 [Collections](http://msdn.microsoft.com/library/e76533a9-5033-4a0b-b003-9c2be60d185b)  
 Describes some of the types of collections that are provided by the .NET Framework. Demonstrates how to use simple collections and collections of key/value pairs.  
  
 [Visual Basic Language Reference](../../../visual-basic/language-reference/index.md)  
 Provides reference information on various aspects of [!INCLUDE[vbprvb](../../../csharp/programming-guide/concepts/linq/includes/vbprvb_md.md)] programming.