---
title: "Visual Basic Language Walkthroughs | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
dev_langs: 
  - "VB"
helpviewer_keywords: 
  - "Visual Basic, walkthroughs"
  - "examples [Visual Basic]"
  - "Visual Basic code, walkthroughs"
  - "walkthroughs [Visual Basic]"
ms.assetid: e4e1f849-e1ce-4cf7-8483-d9b4c4887a8e
caps.latest.revision: 18
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Visual Basic Language Walkthroughs
Walkthroughs give step-by-step instructions for common scenarios, which makes them a good place to start learning about the product or a particular feature area.  
  
 [Writing an Async Program](./programming-guide/concepts/async/walkthrough-accessing-the-web-by-using-async-and-await.md)  
 Shows how to create an asynchronous solution by using [Async](../visual-basic/language-reference/modifiers/async.md) and [Await](../visual-basic/language-reference/operators/await-operator.md), which are introduced in [!INCLUDE[vs_dev11_long](../csharp/includes/vs_dev11_long_md.md)].  
  
 [Declaring and Raising Events](../visual-basic/programming-guide/language-features/events/walkthrough-declaring-and-raising-events.md)  
 Illustrates how events are declared and raised in [!INCLUDE[vbprvb](../csharp/programming-guide/concepts/linq/includes/vbprvb_md.md)].  
  
 [Handling Events](../visual-basic/programming-guide/language-features/events/walkthrough-handling-events.md)  
 Shows how to handle events using either the standard `WithEvents` keyword or the new `AddHandler`/`RemoveHandler` keywords.  
  
 [Creating and Implementing Interfaces](../visual-basic/programming-guide/language-features/interfaces/walkthrough-creating-and-implementing-interfaces.md)  
 Shows how interfaces are declared and implemented in [!INCLUDE[vbprvb](../csharp/programming-guide/concepts/linq/includes/vbprvb_md.md)].  
  
 [Defining Classes](../visual-basic/programming-guide/language-features/objects-and-classes/walkthrough-defining-classes.md)  
 Describes how to declare a class and its fields, properties, methods, and events.  
  
 [Writing Queries in Visual Basic](../visual-basic/programming-guide/concepts/linq/walkthrough-writing-queries.md)  
 Demonstrates how you can use Visual Basic language features to write [!INCLUDE[vbteclinqext](../csharp/getting-started/includes/vbteclinqext_md.md)] query expressions.  
  
 [Implementing IEnumerable(Of T) in Visual Basic](../visual-basic/programming-guide/language-features/control-flow/walkthrough-implementing-ienumerable-of-t.md)  
 Demonstrates how to create a class that implements the `IEnumerable(Of String)` interface and a class that implements the `IEnumerator(Of String)` interface to read a text file one line at a time.  
  
 [Calling Windows APIs](../visual-basic/programming-guide/com-interop/walkthrough-calling-windows-apis.md)  
 Explains how to use `Declare` statements and call Windows APIs. Includes information about using attributes to control marshaling for the API call and how to expose an API call as a method of a class.  
  
 [Creating COM Objects with Visual Basic](../visual-basic/programming-guide/com-interop/walkthrough-creating-com-objects.md)  
 Demonstrates how to create COM objects in [!INCLUDE[vbprvb](../csharp/programming-guide/concepts/linq/includes/vbprvb_md.md)], both with and without the COM class template.  
  
 [Implementing Inheritance with COM Objects](../visual-basic/programming-guide/com-interop/walkthrough-implementing-inheritance-with-com-objects.md)  
 Demonstrates how to use [!INCLUDE[vbprvb](../csharp/programming-guide/concepts/linq/includes/vbprvb_md.md)] 6.0 to create a COM object containing a class, and then use it as a base class in [!INCLUDE[vbprvb](../csharp/programming-guide/concepts/linq/includes/vbprvb_md.md)].  
  
 [Multithreading](http://msdn.microsoft.com/library/2cbf5116-8499-4af9-818c-6f7c1c2ad2c9)  
 Shows how to create a multithreaded application that searches a text file for occurrences of a word.  
  
 [Determining Where My.Application.Log Writes Information](../visual-basic/developing-apps/programming/log-info/walkthrough-determining-where-my-application-log-writes-information.md)  
 Describes the default `My.Application.Log` settings and how to determine the settings for your application.  
  
 [Changing Where My.Application.Log Writes Information](../visual-basic/developing-apps/programming/log-info/walkthrough-changing-where-my-application-log-writes-information.md)  
 Shows how to override the default `My.Application.Log` and `My.Log` settings for logging event information and cause the `Log` object to write to other log listeners.  
  
 [Filtering My.Application.Log Output](../visual-basic/developing-apps/programming/log-info/walkthrough-filtering-my-application-log-output.md)  
 Demonstrates how to change the default log filtering for the `My.Application.Log` object.  
  
 [Creating Custom Log Listeners](../visual-basic/developing-apps/programming/log-info/walkthrough-creating-custom-log-listeners.md)  
 Demonstrates how to create a custom log listener and configure it to listen to the output of the `My.Application.Log` object.  
  
 [Embedding Types from Managed Assemblies](http://msdn.microsoft.com/library/b28ec92c-1867-4847-95c0-61adfe095e21)  
 Describes how to create an assembly and a client program that embeds types from it.  
  
 [Validating That Passwords Are Complex (Visual Basic)](../visual-basic/programming-guide/language-features/strings/walkthrough-validating-that-passwords-are-complex.md)  
 Demonstrates how to check for strong-password characteristics and update a string parameter with information about which checks a password fails.  
  
 [Encrypting and Decrypting Strings in Visual Basic](../visual-basic/programming-guide/language-features/strings/walkthrough-encrypting-and-decrypting-strings.md)  
 Shows how to use the <xref:System.Security.Cryptography.DESCryptoServiceProvider> class to encrypt and decrypt strings.  
  
 [Manipulating Files and Folders in Visual Basic](../visual-basic/developing-apps/programming/drives-directories-files/walkthrough-manipulating-files-and-directories.md)  
 Demonstrates how to use [!INCLUDE[vbprvb](../csharp/programming-guide/concepts/linq/includes/vbprvb_md.md)] functions to determine information about a file, search for a string in a file, and write to a file.  
  
 [Manipulating Files Using .NET Framework Methods](../visual-basic/developing-apps/programming/drives-directories-files/walkthrough-manipulating-files-by-using-net-framework-methods.md)  
 Demonstrates how to use [!INCLUDE[dnprdnshort](../csharp/getting-started/includes/dnprdnshort_md.md)] methods to determine information about a file, search for a string in a file, and write to a file.  
  
 [Persisting an Object in Visual Basic](http://msdn.microsoft.com/library/cb0a0917-08d5-4578-ad2b-3764ccf6167f)  
 Demonstrates how to create a simple object and persist its data to a file.  
  
 [Test-First Support with the Generate from Usage Feature](http://msdn.microsoft.com/library/764c17a4-cd95-4c23-bf63-d92d9c5adfb2)  
 Demonstrates how to do test-first development, in which you first write unit tests and then write the source code to make the tests succeed.