---
layout: HubPage
hide_bc: true
title: .NET Documentation
---
<div id="main" class="v2">
    <div class="container">
        <ul class="cardsY panelContent featuredContent">
            <li>
                <a href="https://www.microsoft.com/net/tutorials/csharp/getting-started">
                    <div class="cardSize">
                        <div class="cardPadding">
                            <div class="card">
                                <div class="cardImageOuter">
                                    <div class="cardImage">
                                        <img data-hoverimage="/dotnet/articles/images/hub/featured-1.svg" src="/dotnet/articles/images/hub/featured-1.png" alt="" />
                                    </div>
                                </div>
                                <div class="cardText">
                                    <h3>Get Started with C#</h3>
                                </div>
                            </div>
                        </div>
                    </div>
                </a>
            </li>
            <li>
                <a href="/dotnet/core/api/">
                    <div class="cardSize">
                        <div class="cardPadding">
                            <div class="card">
                                <div class="cardImageOuter">
                                    <div class="cardImage">
                                        <img data-hoverimage="/dotnet/articles/images/hub/featured-2.svg" src="/dotnet/articles/images/hub/featured-2.png" alt="" />
                                    </div>
                                </div>
                                <div class="cardText">
                                    <h3>.NET Core API Reference</h3>
                                </div>
                            </div>
                        </div>
                    </div>
                </a>
            </li>
            <li>
                <a href="https://msdn.microsoft.com/library/mt472912(v=vs.110).aspx">
                    <div class="cardSize">
                        <div class="cardPadding">
                            <div class="card">
                                <div class="cardImageOuter">
                                    <div class="cardImage">
                                        <img data-hoverimage="/dotnet/articles/images/hub/featured-3.svg" src="/dotnet/articles/images/hub/featured-3.png" alt="" />
                                    </div>
                                </div>
                                <div class="cardText">
                                    <h3>.NET Framework API Reference</h3>
                                </div>
                            </div>
                        </div>
                    </div>
                </a>
            </li>
        </ul>
    </div>
    <div class="container">
        <h1>.NET Documentation</h1>
        <ul class="pivots">
            <li>
                <a data-default="true" href="#docs">Docs</a>
                <ul id="docs">
                    <li>
                        <a href="#getstarted">Get Started</a>
                        <ul id="getstarted" class="cardsF">
                            <li>
                                <div class="cardSize">
                                    <div class="cardPadding">
                                        <div class="card">
                                            <div class="cardImageOuter">
                                                <div class="cardImage">
                                                    <img src="/dotnet/articles/images/hub/net.svg" alt="" />
                                                </div>
                                            </div>
                                            <div class="cardText">
                                                <h3><a href="/dotnet/articles/welcome">What is .NET?</a></h3>
                                                <p><a href="/dotnet/articles/standard/getting-started">Get Started</a></p>
                                                <p><a href="/dotnet/articles/standard/tour">Tour of .NET</a></p>
                                                <p><a href="/dotnet/articles/standard/components">.NET Architectural Concepts</a></p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </li>
                            <li>
                                <div class="cardSize">
                                    <div class="cardPadding">
                                        <div class="card">
                                            <div class="cardImageOuter">
                                                <div class="cardImage">
                                                    <img src="/dotnet/articles/images/hub/netcore.svg" alt="" />
                                                </div>
                                            </div>
                                            <div class="cardText">
                                                <h3><a href="/dotnet/articles/core">.NET Core Guide</a></h3>
                                                <p><a href="/dotnet/articles/core/getting-started">Get Started</a></p>
                                                <p><a href="/dotnet/articles/core/tutorials">Tutorials</a></p>
                                                <p><a href="/dotnet/articles/core/porting">Porting from .NET Framework</a></p>
                                                <p><a href="/aspnet/core/getting-started">ASP.NET Core</a></p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </li>
                            <li>
                                <div class="cardSize">
                                    <div class="cardPadding">
                                        <div class="card">
                                            <div class="cardImageOuter">
                                                <div class="cardImage">
                                                    <img src="/dotnet/articles/images/hub/netframework.svg" alt="" />
                                                </div>
                                            </div>
                                            <div class="cardText">
                                                <h3><a href="https://msdn.microsoft.com/library/w0x726c2(v=vs.110).aspx">.NET Framework Guide</a></h3>
                                                <p><a href="https://msdn.microsoft.com/library/hh425099(v=vs.110).aspx">Get Started</a></p>
                                                <p><a href="https://msdn.microsoft.com/library/hh156542(v=vs.110).aspx">Tutorials</a></p>
                                                <p><a href="https://msdn.microsoft.com/library/54xbah2z(v=vs.110).aspx">Client Development</a></p>
                                                <p><a href="https://msdn.microsoft.com/library/bb400852(v=vs.110).aspx">ASP.NET</a></p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </li>
                            <li>
                                <div class="cardSize">
                                    <div class="cardPadding">
                                        <div class="card">
                                            <div class="cardImageOuter">
                                                <div class="cardImage">
                                                    <img src="/dotnet/articles/images/hub/xamarin.svg" alt="" />
                                                </div>
                                            </div>
                                            <div class="cardText">
                                                <h3><a href="https://developer.xamarin.com/guides/cross-platform/getting_started">Xamarin</a></h3>
                                                <p><a href="https://developer.xamarin.com/guides/cross-platform/getting_started">Get Started</a></p>
                                                <p><a href="https://developer.xamarin.com/guides/ios">Xamarin.iOS Guide</a></p>
                                                <p><a href="https://developer.xamarin.com/guides/android/getting_started">Xamarin.Android Guide</a></p>
                                                <p><a href="https://developer.xamarin.com/guides/xamarin-forms">Xamarin.Forms Guide</a></p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </li>
                            <li>
                                <div class="cardSize">
                                    <div class="cardPadding">
                                        <div class="card">
                                            <div class="cardImageOuter">
                                                <div class="cardImage">
                                                    <img src="/dotnet/articles/images/hub/csharp.svg" alt="" />
                                                </div>
                                            </div>
                                            <div class="cardText">
                                                <h3><a href="/dotnet/articles/csharp">C# Guide</a></h3>
                                                <p><a href="/dotnet/articles/csharp/getting-started">Get Started</a></p>
                                                <p><a href="/dotnet/articles/csharp/tour-of-csharp">Tour of C#</a></p>
                                                <p><a href="/dotnet/articles/csharp/language-reference">C# Language Reference</a></p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </li>
                            <li>
                                <div class="cardSize">
                                    <div class="cardPadding">
                                        <div class="card">
                                            <div class="cardImageOuter">
                                                <div class="cardImage">
                                                    <img src="/dotnet/articles/images/hub/fsharp.svg" alt="" />
                                                </div>
                                            </div>
                                            <div class="cardText">
                                                <h3><a href="/dotnet/articles/fsharp">F# Guide</a></h3>
                                                <p><a href="/dotnet/articles/fsharp/tutorials/getting-started">Get Started</a></p>
                                                <p><a href="/dotnet/articles/fsharp/tour">Tour of F#</a></p>
                                                <p><a href="/dotnet/articles/fsharp/language-reference">F# Language Reference</a></p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </li>
                            <li>
                                <div class="cardSize">
                                    <div class="cardPadding">
                                        <div class="card">
                                            <div class="cardImageOuter">
                                                <div class="cardImage">
                                                    <img src="/dotnet/articles/images/hub/vb.svg" alt="" />
                                                </div>
                                            </div>
                                            <div class="cardText">
                                                <h3><a href="/dotnet/articles/visual-basic">Visual Basic Guide</a></h3>
                                                <p><a href="/dotnet/articles/visual-basic/getting-started">Get Started</a></p>
                                                <p><a href="/dotnet/articles/visual-basic/walkthroughs">Tour of Visual Basic</a></p>
                                                <p><a href="/dotnet/articles/visual-basic/language-reference">Visual Basic Language Reference</a></p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </li>
                        </ul>
                    </li>
                    <li>
                        <a href="#web">Web</a>
                        <ul id="web" class="cardsG">
                            <li>
                                <div class="cardSize">
                                    <div class="cardPadding">
                                        <div class="card">
                                            <div class="cardImageOuter">
                                                <div class="cardImage">
                                                    <img src="/dotnet/articles/images/hub/net-docs-web-1.svg" alt="" />
                                                </div>
                                            </div>
                                            <div class="cardText">
                                                <a href="https://www.asp.net/get-started">
                                                    <h3>Build Your First Web App</h3>
                                                    <p>Learn how to build your first ASP.NET Core web app.</p>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </li>
                            <li>
                                <div class="cardSize">
                                    <div class="cardPadding">
                                        <div class="card">
                                            <div class="cardImageOuter">
                                                <div class="cardImage">
                                                    <img src="/dotnet/articles/images/hub/net-docs-web-2.svg" alt="" />
                                                </div>
                                            </div>
                                            <div class="cardText">
                                                <a href="/aspnet/core/">
                                                    <h3>Using ASP.NET Core</h3>
                                                    <p>Learn how to build modern web apps with ASP.NET Core.</p>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </li>
                            <li>
                                <div class="cardSize">
                                    <div class="cardPadding">
                                        <div class="card">
                                            <div class="cardImageOuter">
                                                <div class="cardImage">
                                                    <img src="/dotnet/articles/images/hub/net-docs-web-3.svg" alt="" />
                                                </div>
                                            </div>
                                            <div class="cardText">
                                                <a href="https://www.asp.net/learn">
                                                    <h3>What is ASP.NET?</h3>
                                                    <p>Learn about the ASP.NET web platform.</p>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </li>
                            <li>
                                <div class="cardSize">
                                    <div class="cardPadding">
                                        <div class="card">
                                            <div class="cardImageOuter">
                                                <div class="cardImage">
                                                    <img src="/dotnet/articles/images/hub/net-docs-web-4.svg" alt="" />
                                                </div>
                                            </div>
                                            <div class="cardText">
                                                <a href="/aspnet/core/tutorials/first-mvc-app/start-mvc">
                                                    <h3>ASP.NET Core in Visual Studio</h3>
                                                    <p>Learn the basics of building an ASP.NET Core MVC web app using Visual
                                                        Studio 2015.</p>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </li>
                            <li>
                                <div class="cardSize">
                                    <div class="cardPadding">
                                        <div class="card">
                                            <div class="cardImageOuter">
                                                <div class="cardImage">
                                                    <img src="/dotnet/articles/images/hub/net-docs-web-5.svg" alt="" />
                                                </div>
                                            </div>
                                            <div class="cardText">
                                                <a href="/dotnet/articles/framework/docker/aspnetmvc">
                                                    <h3>ASP.NET Apps in Containers</h3>
                                                    <p>Learn how to deploy ASP.NET apps with Docker.</p>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </li>
                            <li>
                                <div class="cardSize">
                                    <div class="cardPadding">
                                        <div class="card">
                                            <div class="cardImageOuter">
                                                <div class="cardImage">
                                                    <img src="/dotnet/articles/images/hub/net-docs-web-6.svg" alt="" />
                                                </div>
                                            </div>
                                            <div class="cardText">
                                                <a href="/aspnet/core/tutorials/your-first-mac-aspnet">
                                                    <h3>ASP.NET on macOS and VS Code</h3>
                                                    <p>Learn how to set up, build, and deploy ASP.NET Core apps on macOS with
                                                        Visual Studio Code.</p>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </li>
                        </ul>
                    </li>
                    <li>
                        <a href="#cloud">Cloud</a>
                        <ul id="cloud" class="cardsG">
                            <li>
                                <div class="cardSize">
                                    <div class="cardPadding">
                                        <div class="card">
                                            <div class="cardImageOuter">
                                                <div class="cardImage">
                                                    <img src="/dotnet/articles/images/hub/net-docs-cloud-1.svg" alt="" />
                                                </div>
                                            </div>
                                            <div class="cardText">
                                                <a href="https://azure.microsoft.com/develop/net">
                                                    <h3>.NET Azure Documentation</h3>
                                                    <p>Learn about Azure services such as Web Apps, WebJobs, Cloud Services,
                                                        and VMs.</p>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </li>
                            <li>
                                <div class="cardSize">
                                    <div class="cardPadding">
                                        <div class="card">
                                            <div class="cardImageOuter">
                                                <div class="cardImage">
                                                    <img src="/dotnet/articles/images/hub/net-docs-cloud-2.svg" alt="" />
                                                </div>
                                            </div>
                                            <div class="cardText">
                                                <a href="https://azure.microsoft.com/documentation/articles/cloud-services-dotnet-get-started">
                                                    <h3>Azure Cloud Services and ASP.NET</h3>
                                                    <p>Learn to configure, monitor, and scale your cloud services in Azure.</p>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </li>
                            <li>
                                <div class="cardSize">
                                    <div class="cardPadding">
                                        <div class="card">
                                            <div class="cardImageOuter">
                                                <div class="cardImage">
                                                    <img src="/dotnet/articles/images/hub/net-docs-cloud-3.svg" alt="" />
                                                </div>
                                            </div>
                                            <div class="cardText">
                                                <a href="/dotnet/articles/fsharp/using-fsharp-on-azure">
                                                    <h3>Using F# on Azure</h3>
                                                    <p>Learn how to use various Azure services in F# such as Azure Storage,
                                                        Cloud Services, and Azure Functions.</p>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </li>
                            <li>
                                <div class="cardSize">
                                    <div class="cardPadding">
                                        <div class="card">
                                            <div class="cardImageOuter">
                                                <div class="cardImage">
                                                    <img src="/dotnet/articles/images/hub/net-docs-cloud-4.svg" alt="" />
                                                </div>
                                            </div>
                                            <div class="cardText">
                                                <a href="https://azure.microsoft.com/documentation/services/storage/">
                                                    <h3>Azure Storage</h3>
                                                    <p>Learn about Azure Storage, and how to create applications using Azure
                                                        blobs, tables, queues, and files.</p>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </li>
                        </ul>
                    </li>
                    <li>
                        <a href="#mobile">Mobile</a>
                        <ul id="mobile" class="cardsG">
                            <li>
                                <div class="cardSize">
                                    <div class="cardPadding">
                                        <div class="card">
                                            <div class="cardImageOuter">
                                                <div class="cardImage">
                                                    <img src="/dotnet/articles/images/hub/net-docs-mobile-1.svg" alt="" />
                                                </div>
                                            </div>
                                            <div class="cardText">
                                                <a href="https://developer.xamarin.com/guides/ios/getting_started/">
                                                    <h3>Xamarin.iOS</h3>
                                                    <p>Create native iOS apps using C# and F# with Xamarin.iOS.</p>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </li>
                            <li>
                                <div class="cardSize">
                                    <div class="cardPadding">
                                        <div class="card">
                                            <div class="cardImageOuter">
                                                <div class="cardImage">
                                                    <img src="/dotnet/articles/images/hub/net-docs-mobile-2.svg" alt="" />
                                                </div>
                                            </div>
                                            <div class="cardText">
                                                <a href="https://developer.xamarin.com/guides/android/getting_started">
                                                    <h3>Xamarin.Android</h3>
                                                    <p>Create native Android apps using C# and F# with Xamarin.Android.</p>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </li>
                            <li>
                                <div class="cardSize">
                                    <div class="cardPadding">
                                        <div class="card">
                                            <div class="cardImageOuter">
                                                <div class="cardImage">
                                                    <img src="/dotnet/articles/images/hub/net-docs-mobile-3.svg" alt="" />
                                                </div>
                                            </div>
                                            <div class="cardText">
                                                <a href="https://developer.xamarin.com/guides/xamarin-forms">
                                                    <h3>Xamarin.Forms</h3>
                                                    <p>Create cross-platform mobile Uis using C# and F# with Xamarin.Forms.</p>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </li>
                        </ul>
                    </li>
                    <li>
                        <a href="#desktop">Desktop</a>
                        <ul id="desktop" class="cardsG">
                            <li>
                                <div class="cardSize">
                                    <div class="cardPadding">
                                        <div class="card">
                                            <div class="cardImageOuter">
                                                <div class="cardImage">
                                                    <img src="/dotnet/articles/images/hub/net-docs-desktop-1.svg" alt="" />
                                                </div>
                                            </div>
                                            <div class="cardText">
                                                <a href="https://msdn.microsoft.com/library/windows/apps/dn609832.aspx">
                                                    <h3>Universal Windows Apps</h3>
                                                    <p>Learn how you create Universal Windows apps that run on all Windows 10
                                                        devices.
                                                    </p>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </li>
                            <li>
                                <div class="cardSize">
                                    <div class="cardPadding">
                                        <div class="card">
                                            <div class="cardImageOuter">
                                                <div class="cardImage">
                                                    <img src="/dotnet/articles/images/hub/net-docs-desktop-2.svg" alt="" />
                                                </div>
                                            </div>
                                            <div class="cardText">
                                                <a href="https://msdn.microsoft.com/library/ms754130.aspx">
                                                    <h3>Windows Presentation Foundation (WPF)</h3>
                                                    <p>WPF provides developers with a XAML-based model for building desktop
                                                        applications on Windows.</p>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </li>
                            <li>
                                <div class="cardSize">
                                    <div class="cardPadding">
                                        <div class="card">
                                            <div class="cardImageOuter">
                                                <div class="cardImage">
                                                    <img src="/dotnet/articles/images/hub/net-docs-desktop-3.svg" alt="" />
                                                </div>
                                            </div>
                                            <div class="cardText">
                                                <a href="https://msdn.microsoft.com/library/dd30h2yb.aspx">
                                                    <h3>Windows Forms</h3>
                                                    <p>Rapidly develop Line of Business apps for the Windows desktop.</p>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </li>
                            <li>
                                <div class="cardSize">
                                    <div class="cardPadding">
                                        <div class="card">
                                            <div class="cardImageOuter">
                                                <div class="cardImage">
                                                    <img src="/dotnet/articles/images/hub/net-docs-desktop-4.svg" alt="" />
                                                </div>
                                            </div>
                                            <div class="cardText">
                                                <a href="https://developer.xamarin.com/guides/mac/getting_started">
                                                    <h3>Xamarin for macOS</h3>
                                                    <p>Create apps for macOS using C# and F# with Xamarin.</p>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </li>
                        </ul>
                    </li>
                    <li>
                        <a href="#gaming">Gaming</a>
                        <ul id="gaming" class="cardsG">
                            <li>
                                <div class="cardSize">
                                    <div class="cardPadding">
                                        <div class="card">
                                            <div class="cardImageOuter">
                                                <div class="cardImage">
                                                    <img src="/dotnet/articles/images/hub/net-docs-gaming-1.svg" alt="" />
                                                </div>
                                            </div>
                                            <div class="cardText">
                                                <a href="https://www.visualstudio.com/vs/game-development">
                                                    <h3>Game Development with Visual Studio</h3>
                                                    <p>Write and debug your games using your game engine of choice with Visual
                                                        Studio.
                                                    </p>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </li>
                            <li>
                                <div class="cardSize">
                                    <div class="cardPadding">
                                        <div class="card">
                                            <div class="cardImageOuter">
                                                <div class="cardImage">
                                                    <img src="/dotnet/articles/images/hub/net-docs-gaming-2.svg" alt="" />
                                                </div>
                                            </div>
                                            <div class="cardText">
                                                <a href="http://docs.cryengine.com/display/CEPROG/CE%23+Programming">
                                                <h3>CRYENGINE</h3>
                                                <p>Learn how to use CRYENGINE to build games with C#.</p>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </li>
                            <li>
                                <div class="cardSize">
                                    <div class="cardPadding">
                                        <div class="card">
                                            <div class="cardImageOuter">
                                                <div class="cardImage">
                                                    <img src="/dotnet/articles/images/hub/net-docs-gaming-3.svg" alt="" />
                                                </div>
                                            </div>
                                            <div class="cardText">
                                                <a href="http://www.monogame.net/documentation/?page=main">
                                                    <h3>MonoGame</h3>
                                                    <p>Build games with C# through tutorials and setup instructions at the MonoGame
                                                        library documenation hub.</p>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </li>
                            <li>
                                <div class="cardSize">
                                    <div class="cardPadding">
                                        <div class="card">
                                            <div class="cardImageOuter">
                                                <div class="cardImage">
                                                    <img src="/dotnet/articles/images/hub/net-docs-gaming-4.svg" alt="" />
                                                </div>
                                            </div>
                                            <div class="cardText">
                                                <a href="https://docs.unity3d.com/Manual/index.html">
                                                    <h3>Unity</h3>
                                                    <p>Learn how to use Unity to build 2D and 3D games with C# with the Unity
                                                        Manual.
                                                    </p>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </li>
                        </ul>
                    </li>
                </ul>
            </li>
        </ul>
    </div>
</div>
