/*
Copyright 2016 The Rook Authors. All rights reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

	http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Some of the code below came from https://github.com/coreos/etcd-operator
which also has the apache 2.0 license.
*/

// Package k8sutil for Kubernetes helpers.
package k8sutil

import "github.com/coreos/pkg/capnslog"

var logger = capnslog.NewPackageLogger("github.com/rook/rook", "op-k8sutil")

const (
	// V1Alpha1 version for kubernetes resources
	V1Alpha1 = "v1alpha1"

	// V1Beta1 version for kubernetes resources
	V1Beta1 = "v1beta1"

	// V1 version for kubernetes resources
	V1 = "v1"
)

const (
	// Namespace for rook
	Namespace = "rook"
	// CustomResourceGroup for rook CRD
	CustomResourceGroup = "rook.io"
	// DefaultNamespace for the cluster
	DefaultNamespace = "default"
	// DataDirVolume data dir volume
	DataDirVolume = "rook-data"
	// DataDir folder
	DataDir = "/var/lib/rook"
	// RookType for the CRD
	RookType = "kubernetes.io/rook"
	// RbdType for the RBD mounts
	RbdType = "kubernetes.io/rbd"
)
