---
title: Tectonic Bare Metal
weight: 16
indent: true
---

# Tectonic Bare Metal
Here is a running guide on how to implement Rook on Tectonic. A complete guide on how to install Tectonic is out of the scope of the Rook project. More info can be found on the [Tectonic website](https://coreos.com/tectonic/docs/latest/)

## Prequisites
- An installed tectonic-installer. These steps are described on [the Tectonic website](https://coreos.com/tectonic/docs/latest/install/bare-metal/#4-tectonic-installer)
- A running matchbox node which will do the provisioning (Matchbox is only required if you are running Tectonic on Bare metal)
- You can run through all steps of the GUI installer, but in the last step, choose `Boot manually`. This way we can make the necessary changes first.

## Edit the kubelet.service file
We need to make a few adaptions to the Kubelet systemd service file generated by the Tectonic-installer.

First change to the directory in which you untarred the tectonic installer and find your newly generated cluster configuration files.

```bash
cd ~/tectonic/tectonic-installer/LINUX-OR-DARWIN/clusters
```


Open the file `modules/ignition/resources/services/kubelet.service` in your favorite editor and after the last line containing `ExecStartPre=...`, paste the following extra lines:

```bash
ExecStartPre=/bin/mkdir -p /var/lib/kubelet/volumeplugins
ExecStartPre=/bin/mkdir -p /var/lib/rook
```

And after the `ExecStart=/usr/lib/coreos/kubelet-wrapper \` line, insert the following flag for the kubelet-wrapper to point to a path reachable outside of the Kubelet rkt container:

```bash
--volume-plugin-dir=/var/lib/kubelet/volumeplugins \
```

Save and close the file.

### Boot your Tectonic cluster
All the preparations are ready for Tectonic to boot now. We will use `terraform` to start the cluster.
Visit the official [Tectonic manual boot](https://coreos.com/tectonic/docs/latest/install/aws/manual-boot.html#deploy-the-cluster) page for the commands to use.

**Remark:** The Tectonic installer contains the correct terraform binary out of the box. This terraform binary can be found in following directory `~/tectonic/tectonic-installer/linux`.

## Start Rook
After the Tectonic Installer ran and the Kubernetes cluster is started and ready, you can follow the [Rook installation guide](ceph-quickstart.md).
If you want to specify which disks Rook uses, follow the instructions in [creating Rook clusters](ceph-cluster-crd.md)
