---
title: "Compiler Error CS0134 | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "error-reference"
f1_keywords: 
  - "CS0134"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0134"
ms.assetid: c7b57de2-42ad-473e-8e45-8ac7a0caea9a
caps.latest.revision: 7
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Compiler Error CS0134
'variable' is of type 'type'. A const field of a reference type other than string can only be initialized with null.  
  
 A constant-expression is an expression that can be fully evaluated at compile-time. Because the only way to create a non-null value of a reference-type is to apply the new operator, and because the new operator is not permitted in a constant-expression, the only possible value for constants of reference-types other than string is null.  
  
 If you encounter this error by trying to create a [const](../../../csharp/language-reference/keywords/const.md) string array, the solution is to make the array [readonly](../../../csharp/language-reference/keywords/readonly.md), and initialize it in the constructor.  
  
## Example  
 The following example generates CS0134.  
  
```  
// CS0134.cs  
// compile with: /target:library  
class MyTest {}   
  
class MyClass  
{  
   const MyTest test = new MyTest();   // CS0134  
  
   //OK  
   const MyTest test2 = null;  
   const System.String test3 = "test";  
}  
```