---
title: "null (C# Reference) | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "article"
f1_keywords: 
  - "null"
  - "null_CSharpKeyword"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "null keyword [C#]"
ms.assetid: fecb1c60-6232-4efe-87f7-9a86ba2e9119
caps.latest.revision: 17
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# null (C# Reference)
The `null` keyword is a literal that represents a null reference, one that does not refer to any object. `null` is the default value of reference-type variables. Ordinary value types cannot be null. However, C# 2.0 introduced nullable value types. See [Nullable Types](../../../csharp/programming-guide/nullable-types/index.md).  
  
 The following example demonstrates some behaviors of the null keyword:  
  
 [!code-cs[csrefKeywordsLiteral#1](../../../csharp/language-reference/keywords/codesnippet/CSharp/null_1.cs)]  
  
## C# Language Specification  
 [!INCLUDE[CSharplangspec](../../../csharp/language-reference/keywords/includes/csharplangspec_md.md)]  
  
## See Also  
 [C# Reference](../../../csharp/language-reference/index.md)   
 [C# Programming Guide](../../../csharp/programming-guide/index.md)   
 [C# Keywords](../../../csharp/language-reference/keywords/index.md)   
 [Literal Keywords](../../../csharp/language-reference/keywords/literal-keywords.md)   
 [Default Values Table](../../../csharp/language-reference/keywords/default-values-table.md)   
 [Nothing](../../../visual-basic/language-reference/nothing.md)