---
title: "Compiler Error CS1012 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS1012"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS1012"
ms.assetid: 4acc5fe0-da47-4882-b7d8-557767d7cf03
caps.latest.revision: 8
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS1012
Too many characters in character literal  
  
 An attempt was made to initialize a [char](../../csharp/language-reference/keywords/char.md) constant with more than one character.  
  
 CS1012 can also occur when doing data binding. For example the following line will give an error:  
  
 `<%# DataBinder.Eval(Container.DataItem, 'doctitle') %>`  
  
 Try the following line instead:  
  
 `<%# DataBinder.Eval(Container.DataItem, "doctitle") %>`  
  
 The following sample generates CS1012:  
  
```  
// CS1012.cs  
class Sample  
{  
   static void Main()  
   {  
      char a = 'xx';   // CS1012  
      char a2 = 'x';   // OK  
      System.Console.WriteLine(a2);  
   }  
}  
```