---
title: "File System and the Registry (C# Programming Guide) | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "file system [C#]"
  - "registry [C#]"
  - "files [C#]"
ms.assetid: 0f2511cf-2b02-4b41-b001-b1754677c38f
caps.latest.revision: 20
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# File System and the Registry (C# Programming Guide)
The following topics show how to use C# and the .NET Framework to perform various basic operations on files, folders, and the Registry.  
  
## In This Section  
  
|**Title**|**Description**|  
|---------------|---------------------|  
|[How to: Iterate Through a Directory Tree](../../../csharp/programming-guide/file-system/how-to-iterate-through-a-directory-tree.md)|Shows how to manually iterate through a directory tree.|  
|[How to: Get Information About Files, Folders, and Drives](../../../csharp/programming-guide/file-system/how-to-get-information-about-files-folders-and-drives.md)|Shows how to retrieve information such as creation times and size, about files, folders and drives.|  
|[How to: Create a File or Folder](../../../csharp/programming-guide/file-system/how-to-create-a-file-or-folder.md)|Shows how to create a new file or folder.|  
|[How to: Copy, Delete, and Move Files and Folders (C# Programming Guide)](../../../csharp/programming-guide/file-system/how-to-copy-delete-and-move-files-and-folders.md)|Shows how to copy, delete and move files and folders.|  
|[How to: Provide a Progress Dialog Box for File Operations](../../../csharp/programming-guide/file-system/how-to-provide-a-progress-dialog-box-for-file-operations.md)|Shows how to display a standard Windows progress dialog for certain file operations.|  
|[How to: Write to a Text File](../../../csharp/programming-guide/file-system/how-to-write-to-a-text-file.md)|Shows how to write to a text file.|  
|[How to: Read From a Text File](../../../csharp/programming-guide/file-system/how-to-read-from-a-text-file.md)|Shows how to read from a text file.|  
|[How to: Read a Text File One Line at a Time](../../../csharp/programming-guide/file-system/how-to-read-a-text-file-one-line-at-a-time.md)|Shows how to retrieve text from a file one line at a time.|  
|[How to: Create a Key In the Registry](../../../csharp/programming-guide/file-system/how-to-create-a-key-in-the-registry.md)|Shows how to write a key to the system registry.|  
  
## Related Sections  
 [File and Stream I/O](https://msdn.microsoft.com/library/k3352a4t)  
  
 [How to: Copy, Delete, and Move Files and Folders (C# Programming Guide)](../../../csharp/programming-guide/file-system/how-to-copy-delete-and-move-files-and-folders.md)  
  
 [C# Programming Guide](../../../csharp/programming-guide/index.md)  
  
 [Files, Folders and Drives](../../../csharp/programming-guide/file-system/index.md)  
  
 <xref:System.IO?displayProperty=fullName>