---
title: Manipulating strings
description: Manipulating strings
keywords: .NET, .NET Core
author: stevehoag
ms.author: shoag
ms.date: 07/22/2016
ms.topic: article
ms.prod: .net
ms.technology: dotnet-standard
ms.devlang: dotnet
ms.assetid: da3c277e-b06e-48bd-ae1f-1e7e4240b93e
---

# Manipulating strings

.NET provides an extensive set of routines that enable you to efficiently create, compare, and modify strings as well as rapidly parse large amounts of text and data to search for, remove, and replace text patterns.

## In this section

[Best practices for using strings](best-practices-strings.md)  - Examines string-sorting, comparison, and casing methods in .NET, and provides recommendations for selecting a string-handling method . 

[Regular expressions](regular-expressions.md) - Provides detailed information about .NET regular expressions, including language elements, regular expression behavior, and examples.

[Basic string operations](basic-string-operations.md) - Describes string operations provided by the @System.String and @System.Text.StringBuilder classes, including creating new strings from arrays of bytes, comparing string values, and modifying existing strings.

[Character encoding in .NET](character-encoding.md) - Describes how to encode and decode character formats such as Unicode.

[Type conversion](type-conversion.md) - Describes how to convert from one type to another.

[Formatting types](formatting-types.md) - Describes how to format strings using the string format specifiers.

[Parsing strings](parsing-strings.md) - Describes how to convert strings into types.

