---
title: "How to: Compile and Run a Project in Visual Basic | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net

ms.suite: ""
ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
dev_langs: 
  - "VB"
helpviewer_keywords: 
  - "compilation, Visual Basic projects"
  - "compilation"
  - "Visual Basic projects, compiling"
ms.assetid: 967f5606-5656-489b-bd14-018cf08408c4
caps.latest.revision: 10
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# How to: Compile and Run a Project in Visual Basic
The [!INCLUDE[vsprvs](../../../csharp/includes/vsprvs_md.md)] Integrated Development Environment (IDE) makes it easy to compile a project and run the resulting application.  
  
 You can use the debugger built into the IDE to debug your project as it runs. For more information about debugging, see [Debugging Your Visual Basic Application](../../../visual-basic/developing-apps/debugging.md) and [Edit and Continue (Visual Basic)](https://docs.microsoft.com/visualstudio/debugger/edit-and-continue-visual-basic).  

[!INCLUDE[note_settings_general](../../../csharp/language-reference/compiler-messages/includes/note_settings_general_md.md)]  
  
### To compile and run the current project  
  
-   Press F5 while you are in the [!INCLUDE[vsprvs](../../../csharp/includes/vsprvs_md.md)] Integrated Development Environment (IDE).  
  
     The IDE compiles the project and runs the application within the [!INCLUDE[vsprvs](../../../csharp/includes/vsprvs_md.md)] debugger.  
  
### To compile and run the current project from the menu  
  
-   From the **Debug** menu of the [!INCLUDE[vsprvs](../../../csharp/includes/vsprvs_md.md)] IDE, choose **Start Debugging**.  
  
     The IDE compiles the project and runs the application within the [!INCLUDE[vsprvs](../../../csharp/includes/vsprvs_md.md)] debugger.  
  
### To compile and run the current project without debugging  
  
-   Press CTRL+F5 in the [!INCLUDE[vsprvs](../../../csharp/includes/vsprvs_md.md)] IDE.  
  
     The IDE compiles the project and runs the application.  
  
 For information about compiling and running [!INCLUDE[vbprvb](../../../csharp/programming-guide/concepts/linq/includes/vbprvb_md.md)] code using the command-line compiler, see [Building from the Command Line](../../../visual-basic/reference/command-line-compiler/building-from-the-command-line.md).  
  
## See Also  
 [Debugging Your Visual Basic Application](../../../visual-basic/developing-apps/debugging.md)   
 [Building from the Command Line](../../../visual-basic/reference/command-line-compiler/building-from-the-command-line.md)   
 [Edit and Continue (Visual Basic)](https://docs.microsoft.com/visualstudio/debugger/edit-and-continue-visual-basic)
