---
title: "XML to Schema Wizard (Visual Basic) | Microsoft Docs"
ms.custom: ""
ms.date: "2015-07-20"
ms.prod: .net
ms.reviewer: ""
ms.suite: ""
ms.technology: 
  - "devlang-visual-basic"
ms.tgt_pltfrm: ""
ms.topic: "article"
f1_keywords: 
  - "vb.XmlToSchemaWizard"
dev_langs: 
  - "VB"
helpviewer_keywords: 
  - "XML IntelliSense [Visual Basic]"
  - "XML [Visual Basic], IntelliSense"
  - "IntelliSense [Visual Basic], XML"
  - "XML schemas, creating"
ms.assetid: 98c495ba-8f37-4517-a0db-aa738611ab76
caps.latest.revision: 16
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# XML to Schema Wizard (Visual Basic)
Use the XML to Schema Wizard to create an XML schema set that is inferred from one or more XML documents and include it your project. You can use any combination of XML documents in the form of text files, XML from HTTP Internet addresses, or XML that is typed or pasted into the XML to Schema Wizard.  
  
 XML schemas are used to provide IntelliSense for XML properties in Visual Basic. For more information, see [XML](../../../../visual-basic/programming-guide/language-features/xml/index.md) and [XML IntelliSense in Visual Basic](../../../../visual-basic/programming-guide/language-features/xml/xml-intellisense.md).  
  
> [!NOTE]
>  Before you run the XML to Schema Wizard, it is recommended that you remove any existing XSD files from the project that were previously generated by the wizard. If you infer an XML schema set that matches an existing schema set, a conflict can occur and [!INCLUDE[vbprvb](../../../../csharp/programming-guide/concepts/linq/includes/vbprvb_md.md)] will not be able to provide IntelliSense for XML properties.  
  
 The XML to Schema Wizard uses the <xref:System.Xml.Schema.XmlSchemaInference> class to create the schema for the supplied XML. As a result, multiple schema files may be created for the schema set. For each XML namespace in the supplied XML, an Extensible Schema Definition (XSD) file is created. For more information, see the <xref:System.Xml.Schema.XmlSchemaInference.InferSchema%2A> method.  
  
 To access the XML to Schema Wizard, click **Add New Item** on the **Project** menu and add an **XML to Schema** template from either the **Data** or **Common Items** template group. After you have included all the XML document sources to infer the XML schema set from, click **OK** to create the inferred schema set.  
  
 **Source Type**  
 This column displays the type of the XML document source: **File**, **URL**, or **XML**.  
  
 **XML Document Location**  
 This column displays the path of the XML document. For typed or pasted XML documents, displays the contents of the XML document.  
  
 **Add from File**  
 Click this button to add XML document files by using File Explorer.  
  
 **Add from Web**  
 Click this button to supply the HTTP address of an XML document.  
  
 **Type or paste XML**  
 Click this button to type or paste an XML document into the dialog box.  
  
## See Also  
 <xref:System.Xml.Schema.XmlSchemaInference>   
 [XML IntelliSense in Visual Basic](../../../../visual-basic/programming-guide/language-features/xml/xml-intellisense.md)