# System.IO

``` diff
+namespace System.IO {
+    public class BinaryReader : IDisposable {
+        public BinaryReader(Stream input);
+        public BinaryReader(Stream input, Encoding encoding);
+        public BinaryReader(Stream input, Encoding encoding, bool leaveOpen);
+        public virtual Stream BaseStream { get; }
+        public virtual void Close();
+        public void Dispose();
+        protected virtual void Dispose(bool disposing);
+        protected virtual void FillBuffer(int numBytes);
+        public virtual int PeekChar();
+        public virtual int Read();
+        public virtual int Read(byte[] buffer, int index, int count);
+        public virtual int Read(char[] buffer, int index, int count);
+        protected internal int Read7BitEncodedInt();
+        public virtual bool ReadBoolean();
+        public virtual byte ReadByte();
+        public virtual byte[] ReadBytes(int count);
+        public virtual char ReadChar();
+        public virtual char[] ReadChars(int count);
+        public virtual decimal ReadDecimal();
+        public virtual double ReadDouble();
+        public virtual short ReadInt16();
+        public virtual int ReadInt32();
+        public virtual long ReadInt64();
+        public virtual sbyte ReadSByte();
+        public virtual float ReadSingle();
+        public virtual string ReadString();
+        public virtual ushort ReadUInt16();
+        public virtual uint ReadUInt32();
+        public virtual ulong ReadUInt64();
+    }
+    public class BinaryWriter : IDisposable {
+        public static readonly BinaryWriter Null;
+        protected Stream OutStream;
+        protected BinaryWriter();
+        public BinaryWriter(Stream output);
+        public BinaryWriter(Stream output, Encoding encoding);
+        public BinaryWriter(Stream output, Encoding encoding, bool leaveOpen);
+        public virtual Stream BaseStream { get; }
+        public virtual void Close();
+        public void Dispose();
+        protected virtual void Dispose(bool disposing);
+        public virtual void Flush();
+        public virtual long Seek(int offset, SeekOrigin origin);
+        public virtual void Write(bool value);
+        public virtual void Write(byte value);
+        public virtual void Write(byte[] buffer);
+        public virtual void Write(byte[] buffer, int index, int count);
+        public virtual void Write(char ch);
+        public virtual void Write(char[] chars);
+        public virtual void Write(char[] chars, int index, int count);
+        public virtual void Write(decimal value);
+        public virtual void Write(double value);
+        public virtual void Write(short value);
+        public virtual void Write(int value);
+        public virtual void Write(long value);
+        public virtual void Write(sbyte value);
+        public virtual void Write(float value);
+        public virtual void Write(string value);
+        public virtual void Write(ushort value);
+        public virtual void Write(uint value);
+        public virtual void Write(ulong value);
+        protected void Write7BitEncodedInt(int value);
+    }
+    public sealed class BufferedStream : Stream {
+        public BufferedStream(Stream stream);
+        public BufferedStream(Stream stream, int bufferSize);
+        public override bool CanRead { get; }
+        public override bool CanSeek { get; }
+        public override bool CanWrite { get; }
+        public override long Length { get; }
+        public override long Position { get; set; }
+        protected override void Dispose(bool disposing);
+        public override void Flush();
+        public override Task FlushAsync(CancellationToken cancellationToken);
+        public override int Read(byte[] array, int offset, int count);
+        public override Task<int> ReadAsync(byte[] buffer, int offset, int count, CancellationToken cancellationToken);
+        public override int ReadByte();
+        public override long Seek(long offset, SeekOrigin origin);
+        public override void SetLength(long value);
+        public override void Write(byte[] array, int offset, int count);
+        public override Task WriteAsync(byte[] buffer, int offset, int count, CancellationToken cancellationToken);
+        public override void WriteByte(byte value);
+    }
+    public static class Directory {
+        public static DirectoryInfo CreateDirectory(string path);
+        public static void Delete(string path);
+        public static void Delete(string path, bool recursive);
+        public static IEnumerable<string> EnumerateDirectories(string path);
+        public static IEnumerable<string> EnumerateDirectories(string path, string searchPattern);
+        public static IEnumerable<string> EnumerateDirectories(string path, string searchPattern, SearchOption searchOption);
+        public static IEnumerable<string> EnumerateFiles(string path);
+        public static IEnumerable<string> EnumerateFiles(string path, string searchPattern);
+        public static IEnumerable<string> EnumerateFiles(string path, string searchPattern, SearchOption searchOption);
+        public static IEnumerable<string> EnumerateFileSystemEntries(string path);
+        public static IEnumerable<string> EnumerateFileSystemEntries(string path, string searchPattern);
+        public static IEnumerable<string> EnumerateFileSystemEntries(string path, string searchPattern, SearchOption searchOption);
+        public static bool Exists(string path);
+        public static DateTime GetCreationTime(string path);
+        public static DateTime GetCreationTimeUtc(string path);
+        public static string GetCurrentDirectory();
+        public static string[] GetDirectories(string path);
+        public static string[] GetDirectories(string path, string searchPattern);
+        public static string[] GetDirectories(string path, string searchPattern, SearchOption searchOption);
+        public static string GetDirectoryRoot(string path);
+        public static string[] GetFiles(string path);
+        public static string[] GetFiles(string path, string searchPattern);
+        public static string[] GetFiles(string path, string searchPattern, SearchOption searchOption);
+        public static string[] GetFileSystemEntries(string path);
+        public static string[] GetFileSystemEntries(string path, string searchPattern);
+        public static string[] GetFileSystemEntries(string path, string searchPattern, SearchOption searchOption);
+        public static DateTime GetLastAccessTime(string path);
+        public static DateTime GetLastAccessTimeUtc(string path);
+        public static DateTime GetLastWriteTime(string path);
+        public static DateTime GetLastWriteTimeUtc(string path);
+        public static DirectoryInfo GetParent(string path);
+        public static void Move(string sourceDirName, string destDirName);
+        public static void SetCreationTime(string path, DateTime creationTime);
+        public static void SetCreationTimeUtc(string path, DateTime creationTimeUtc);
+        public static void SetCurrentDirectory(string path);
+        public static void SetLastAccessTime(string path, DateTime lastAccessTime);
+        public static void SetLastAccessTimeUtc(string path, DateTime lastAccessTimeUtc);
+        public static void SetLastWriteTime(string path, DateTime lastWriteTime);
+        public static void SetLastWriteTimeUtc(string path, DateTime lastWriteTimeUtc);
+    }
+    public sealed class DirectoryInfo : FileSystemInfo {
+        public DirectoryInfo(string path);
+        public override bool Exists { get; }
+        public override string Name { get; }
+        public DirectoryInfo Parent { get; }
+        public DirectoryInfo Root { get; }
+        public void Create();
+        public DirectoryInfo CreateSubdirectory(string path);
+        public override void Delete();
+        public void Delete(bool recursive);
+        public IEnumerable<DirectoryInfo> EnumerateDirectories();
+        public IEnumerable<DirectoryInfo> EnumerateDirectories(string searchPattern);
+        public IEnumerable<DirectoryInfo> EnumerateDirectories(string searchPattern, SearchOption searchOption);
+        public IEnumerable<FileInfo> EnumerateFiles();
+        public IEnumerable<FileInfo> EnumerateFiles(string searchPattern);
+        public IEnumerable<FileInfo> EnumerateFiles(string searchPattern, SearchOption searchOption);
+        public IEnumerable<FileSystemInfo> EnumerateFileSystemInfos();
+        public IEnumerable<FileSystemInfo> EnumerateFileSystemInfos(string searchPattern);
+        public IEnumerable<FileSystemInfo> EnumerateFileSystemInfos(string searchPattern, SearchOption searchOption);
+        public DirectoryInfo[] GetDirectories();
+        public DirectoryInfo[] GetDirectories(string searchPattern);
+        public DirectoryInfo[] GetDirectories(string searchPattern, SearchOption searchOption);
+        public FileInfo[] GetFiles();
+        public FileInfo[] GetFiles(string searchPattern);
+        public FileInfo[] GetFiles(string searchPattern, SearchOption searchOption);
+        public FileSystemInfo[] GetFileSystemInfos();
+        public FileSystemInfo[] GetFileSystemInfos(string searchPattern);
+        public FileSystemInfo[] GetFileSystemInfos(string searchPattern, SearchOption searchOption);
+        public void MoveTo(string destDirName);
+        public override string ToString();
+    }
+    public class DirectoryNotFoundException : IOException {
+        public DirectoryNotFoundException();
+        public DirectoryNotFoundException(string message);
+        public DirectoryNotFoundException(string message, Exception innerException);
+    }
+    public sealed class DriveInfo {
+        public DriveInfo(string driveName);
+        public long AvailableFreeSpace { get; }
+        public string DriveFormat { get; }
+        public DriveType DriveType { get; }
+        public bool IsReady { get; }
+        public string Name { get; }
+        public DirectoryInfo RootDirectory { get; }
+        public long TotalFreeSpace { get; }
+        public long TotalSize { get; }
+        public string VolumeLabel { get; set; }
+        public static DriveInfo[] GetDrives();
+        public override string ToString();
+    }
+    public class DriveNotFoundException : IOException {
+        public DriveNotFoundException();
+        public DriveNotFoundException(string message);
+        public DriveNotFoundException(string message, Exception innerException);
+    }
+    public enum DriveType {
+        CDRom = 5,
+        Fixed = 3,
+        Network = 4,
+        NoRootDirectory = 1,
+        Ram = 6,
+        Removable = 2,
+        Unknown = 0,
+    }
+    public class EndOfStreamException : IOException {
+        public EndOfStreamException();
+        public EndOfStreamException(string message);
+        public EndOfStreamException(string message, Exception innerException);
+    }
+    public class ErrorEventArgs : EventArgs {
+        public ErrorEventArgs(Exception exception);
+        public virtual Exception GetException();
+    }
+    public delegate void ErrorEventHandler(object sender, ErrorEventArgs e);
+    public static class File {
+        public static void AppendAllLines(string path, IEnumerable<string> contents);
+        public static void AppendAllLines(string path, IEnumerable<string> contents, Encoding encoding);
+        public static void AppendAllText(string path, string contents);
+        public static void AppendAllText(string path, string contents, Encoding encoding);
+        public static StreamWriter AppendText(string path);
+        public static void Copy(string sourceFileName, string destFileName);
+        public static void Copy(string sourceFileName, string destFileName, bool overwrite);
+        public static FileStream Create(string path);
+        public static FileStream Create(string path, int bufferSize);
+        public static FileStream Create(string path, int bufferSize, FileOptions options);
+        public static StreamWriter CreateText(string path);
+        public static void Delete(string path);
+        public static bool Exists(string path);
+        public static FileAttributes GetAttributes(string path);
+        public static DateTime GetCreationTime(string path);
+        public static DateTime GetCreationTimeUtc(string path);
+        public static DateTime GetLastAccessTime(string path);
+        public static DateTime GetLastAccessTimeUtc(string path);
+        public static DateTime GetLastWriteTime(string path);
+        public static DateTime GetLastWriteTimeUtc(string path);
+        public static void Move(string sourceFileName, string destFileName);
+        public static FileStream Open(string path, FileMode mode);
+        public static FileStream Open(string path, FileMode mode, FileAccess access);
+        public static FileStream Open(string path, FileMode mode, FileAccess access, FileShare share);
+        public static FileStream OpenRead(string path);
+        public static StreamReader OpenText(string path);
+        public static FileStream OpenWrite(string path);
+        public static byte[] ReadAllBytes(string path);
+        public static string[] ReadAllLines(string path);
+        public static string[] ReadAllLines(string path, Encoding encoding);
+        public static string ReadAllText(string path);
+        public static string ReadAllText(string path, Encoding encoding);
+        public static IEnumerable<string> ReadLines(string path);
+        public static IEnumerable<string> ReadLines(string path, Encoding encoding);
+        public static void SetAttributes(string path, FileAttributes fileAttributes);
+        public static void SetCreationTime(string path, DateTime creationTime);
+        public static void SetCreationTimeUtc(string path, DateTime creationTimeUtc);
+        public static void SetLastAccessTime(string path, DateTime lastAccessTime);
+        public static void SetLastAccessTimeUtc(string path, DateTime lastAccessTimeUtc);
+        public static void SetLastWriteTime(string path, DateTime lastWriteTime);
+        public static void SetLastWriteTimeUtc(string path, DateTime lastWriteTimeUtc);
+        public static void WriteAllBytes(string path, byte[] bytes);
+        public static void WriteAllLines(string path, IEnumerable<string> contents);
+        public static void WriteAllLines(string path, IEnumerable<string> contents, Encoding encoding);
+        public static void WriteAllText(string path, string contents);
+        public static void WriteAllText(string path, string contents, Encoding encoding);
+    }
+    public enum FileAccess {
+        Read = 1,
+        ReadWrite = 3,
+        Write = 2,
+    }
+    public enum FileAttributes {
+        Archive = 32,
+        Compressed = 2048,
+        Device = 64,
+        Directory = 16,
+        Encrypted = 16384,
+        Hidden = 2,
+        IntegrityStream = 32768,
+        Normal = 128,
+        NoScrubData = 131072,
+        NotContentIndexed = 8192,
+        Offline = 4096,
+        ReadOnly = 1,
+        ReparsePoint = 1024,
+        SparseFile = 512,
+        System = 4,
+        Temporary = 256,
+    }
+    public class FileFormatException : FormatException {
+        public FileFormatException();
+        public FileFormatException(string message);
+        public FileFormatException(string message, Exception innerException);
+        public FileFormatException(Uri sourceUri);
+        public FileFormatException(Uri sourceUri, Exception innerException);
+        public FileFormatException(Uri sourceUri, string message);
+        public FileFormatException(Uri sourceUri, string message, Exception innerException);
+        public Uri SourceUri { get; }
+    }
+    public sealed class FileInfo : FileSystemInfo {
+        public FileInfo(string fileName);
+        public DirectoryInfo Directory { get; }
+        public string DirectoryName { get; }
+        public override bool Exists { get; }
+        public bool IsReadOnly { get; set; }
+        public long Length { get; }
+        public override string Name { get; }
+        public StreamWriter AppendText();
+        public FileInfo CopyTo(string destFileName);
+        public FileInfo CopyTo(string destFileName, bool overwrite);
+        public FileStream Create();
+        public StreamWriter CreateText();
+        public override void Delete();
+        public void MoveTo(string destFileName);
+        public FileStream Open(FileMode mode);
+        public FileStream Open(FileMode mode, FileAccess access);
+        public FileStream Open(FileMode mode, FileAccess access, FileShare share);
+        public FileStream OpenRead();
+        public StreamReader OpenText();
+        public FileStream OpenWrite();
+        public override string ToString();
+    }
+    public class FileLoadException : IOException {
+        public FileLoadException();
+        public FileLoadException(string message);
+        public FileLoadException(string message, Exception inner);
+        public FileLoadException(string message, string fileName);
+        public FileLoadException(string message, string fileName, Exception inner);
+        public string FileName { get; }
+        public override string Message { get; }
+        public override string ToString();
+    }
+    public enum FileMode {
+        Append = 6,
+        Create = 2,
+        CreateNew = 1,
+        Open = 3,
+        OpenOrCreate = 4,
+        Truncate = 5,
+    }
+    public class FileNotFoundException : IOException {
+        public FileNotFoundException();
+        public FileNotFoundException(string message);
+        public FileNotFoundException(string message, Exception innerException);
+        public FileNotFoundException(string message, string fileName);
+        public FileNotFoundException(string message, string fileName, Exception innerException);
+        public string FileName { get; }
+        public override string Message { get; }
+        public override string ToString();
+    }
+    public enum FileOptions {
+        Asynchronous = 1073741824,
+        DeleteOnClose = 67108864,
+        Encrypted = 16384,
+        None = 0,
+        RandomAccess = 268435456,
+        SequentialScan = 134217728,
+        WriteThrough = -2147483648,
+    }
+    public enum FileShare {
+        Delete = 4,
+        Inheritable = 16,
+        None = 0,
+        Read = 1,
+        ReadWrite = 3,
+        Write = 2,
+    }
+    public class FileStream : Stream {
+        public FileStream(SafeFileHandle handle, FileAccess access);
+        public FileStream(SafeFileHandle handle, FileAccess access, int bufferSize);
+        public FileStream(SafeFileHandle handle, FileAccess access, int bufferSize, bool isAsync);
+        public FileStream(string path, FileMode mode);
+        public FileStream(string path, FileMode mode, FileAccess access);
+        public FileStream(string path, FileMode mode, FileAccess access, FileShare share);
+        public FileStream(string path, FileMode mode, FileAccess access, FileShare share, int bufferSize);
+        public FileStream(string path, FileMode mode, FileAccess access, FileShare share, int bufferSize, bool useAsync);
+        public FileStream(string path, FileMode mode, FileAccess access, FileShare share, int bufferSize, FileOptions options);
+        public override bool CanRead { get; }
+        public override bool CanSeek { get; }
+        public override bool CanWrite { get; }
+        public virtual bool IsAsync { get; }
+        public override long Length { get; }
+        public string Name { get; }
+        public override long Position { get; set; }
+        public virtual SafeFileHandle SafeFileHandle { get; }
+        protected override void Dispose(bool disposing);
+        ~FileStream();
+        public override void Flush();
+        public virtual void Flush(bool flushToDisk);
+        public override Task FlushAsync(CancellationToken cancellationToken);
+        public override int Read(byte[] array, int offset, int count);
+        public override Task<int> ReadAsync(byte[] buffer, int offset, int count, CancellationToken cancellationToken);
+        public override int ReadByte();
+        public override long Seek(long offset, SeekOrigin origin);
+        public override void SetLength(long value);
+        public override void Write(byte[] array, int offset, int count);
+        public override Task WriteAsync(byte[] buffer, int offset, int count, CancellationToken cancellationToken);
+        public override void WriteByte(byte value);
+    }
+    public static class FileSystemAclExtensions {
+        public static DirectorySecurity GetAccessControl(this DirectoryInfo directoryInfo);
+        public static DirectorySecurity GetAccessControl(this DirectoryInfo directoryInfo, AccessControlSections includeSections);
+        public static FileSecurity GetAccessControl(this FileInfo fileInfo);
+        public static FileSecurity GetAccessControl(this FileInfo fileInfo, AccessControlSections includeSections);
+        public static FileSecurity GetAccessControl(this FileStream fileStream);
+        public static void SetAccessControl(this DirectoryInfo directoryInfo, DirectorySecurity directorySecurity);
+        public static void SetAccessControl(this FileInfo fileInfo, FileSecurity fileSecurity);
+        public static void SetAccessControl(this FileStream fileStream, FileSecurity fileSecurity);
+    }
+    public class FileSystemEventArgs : EventArgs {
+        public FileSystemEventArgs(WatcherChangeTypes changeType, string directory, string name);
+        public WatcherChangeTypes ChangeType { get; }
+        public string FullPath { get; }
+        public string Name { get; }
+    }
+    public delegate void FileSystemEventHandler(object sender, FileSystemEventArgs e);
+    public abstract class FileSystemInfo {
+        protected string FullPath;
+        protected string OriginalPath;
+        protected FileSystemInfo();
+        public FileAttributes Attributes { get; set; }
+        public DateTime CreationTime { get; set; }
+        public DateTime CreationTimeUtc { get; set; }
+        public abstract bool Exists { get; }
+        public string Extension { get; }
+        public virtual string FullName { get; }
+        public DateTime LastAccessTime { get; set; }
+        public DateTime LastAccessTimeUtc { get; set; }
+        public DateTime LastWriteTime { get; set; }
+        public DateTime LastWriteTimeUtc { get; set; }
+        public abstract string Name { get; }
+        public abstract void Delete();
+        public void Refresh();
+    }
+    public class FileSystemWatcher : IDisposable {
+        public FileSystemWatcher();
+        public FileSystemWatcher(string path);
+        public FileSystemWatcher(string path, string filter);
+        public bool EnableRaisingEvents { get; set; }
+        public string Filter { get; set; }
+        public bool IncludeSubdirectories { get; set; }
+        public int InternalBufferSize { get; set; }
+        public NotifyFilters NotifyFilter { get; set; }
+        public string Path { get; set; }
+        public event FileSystemEventHandler Changed;
+        public event FileSystemEventHandler Created;
+        public event FileSystemEventHandler Deleted;
+        public event ErrorEventHandler Error;
+        public event RenamedEventHandler Renamed;
+        public void Dispose();
+        protected virtual void Dispose(bool disposing);
+        protected void OnChanged(FileSystemEventArgs e);
+        protected void OnCreated(FileSystemEventArgs e);
+        protected void OnDeleted(FileSystemEventArgs e);
+        protected void OnError(ErrorEventArgs e);
+        protected void OnRenamed(RenamedEventArgs e);
+        public WaitForChangedResult WaitForChanged(WatcherChangeTypes changeType);
+        public WaitForChangedResult WaitForChanged(WatcherChangeTypes changeType, int timeout);
+    }
+    public enum HandleInheritability {
+        Inheritable = 1,
+        None = 0,
+    }
+    public sealed class InvalidDataException : Exception {
+        public InvalidDataException();
+        public InvalidDataException(string message);
+        public InvalidDataException(string message, Exception innerException);
+    }
+    public class IOException : Exception {
+        public IOException();
+        public IOException(string message);
+        public IOException(string message, Exception innerException);
+        public IOException(string message, int hresult);
+    }
+    public class MemoryStream : Stream {
+        public MemoryStream();
+        public MemoryStream(byte[] buffer);
+        public MemoryStream(byte[] buffer, bool writable);
+        public MemoryStream(byte[] buffer, int index, int count);
+        public MemoryStream(byte[] buffer, int index, int count, bool writable);
+        public MemoryStream(byte[] buffer, int index, int count, bool writable, bool publiclyVisible);
+        public MemoryStream(int capacity);
+        public override bool CanRead { get; }
+        public override bool CanSeek { get; }
+        public override bool CanWrite { get; }
+        public virtual int Capacity { get; set; }
+        public override long Length { get; }
+        public override long Position { get; set; }
+        public override Task CopyToAsync(Stream destination, int bufferSize, CancellationToken cancellationToken);
+        protected override void Dispose(bool disposing);
+        public override void Flush();
+        public override Task FlushAsync(CancellationToken cancellationToken);
+        public virtual byte[] GetBuffer();
+        public override int Read(byte[] buffer, int offset, int count);
+        public override Task<int> ReadAsync(byte[] buffer, int offset, int count, CancellationToken cancellationToken);
+        public override int ReadByte();
+        public override long Seek(long offset, SeekOrigin loc);
+        public override void SetLength(long value);
+        public virtual byte[] ToArray();
+        public virtual bool TryGetBuffer(out ArraySegment<byte> buffer);
+        public override void Write(byte[] buffer, int offset, int count);
+        public override Task WriteAsync(byte[] buffer, int offset, int count, CancellationToken cancellationToken);
+        public override void WriteByte(byte value);
+        public virtual void WriteTo(Stream stream);
+    }
+    public enum NotifyFilters {
+        Attributes = 4,
+        CreationTime = 64,
+        DirectoryName = 2,
+        FileName = 1,
+        LastAccess = 32,
+        LastWrite = 16,
+        Security = 256,
+        Size = 8,
+    }
+    public static class Path {
+        public static readonly char AltDirectorySeparatorChar;
+        public static readonly char DirectorySeparatorChar;
+        public static readonly char PathSeparator;
+        public static readonly char VolumeSeparatorChar;
+        public static string ChangeExtension(string path, string extension);
+        public static string Combine(string path1, string path2);
+        public static string Combine(string path1, string path2, string path3);
+        public static string Combine(params string[] paths);
+        public static string GetDirectoryName(string path);
+        public static string GetExtension(string path);
+        public static string GetFileName(string path);
+        public static string GetFileNameWithoutExtension(string path);
+        public static string GetFullPath(string path);
+        public static char[] GetInvalidFileNameChars();
+        public static char[] GetInvalidPathChars();
+        public static string GetPathRoot(string path);
+        public static string GetRandomFileName();
+        public static string GetTempFileName();
+        public static string GetTempPath();
+        public static bool HasExtension(string path);
+        public static bool IsPathRooted(string path);
+    }
+    public class PathTooLongException : IOException {
+        public PathTooLongException();
+        public PathTooLongException(string message);
+        public PathTooLongException(string message, Exception innerException);
+    }
+    public class RenamedEventArgs : FileSystemEventArgs {
+        public RenamedEventArgs(WatcherChangeTypes changeType, string directory, string name, string oldName);
+        public string OldFullPath { get; }
+        public string OldName { get; }
+    }
+    public delegate void RenamedEventHandler(object sender, RenamedEventArgs e);
+    public enum SearchOption {
+        AllDirectories = 1,
+        TopDirectoryOnly = 0,
+    }
+    public enum SeekOrigin {
+        Begin = 0,
+        Current = 1,
+        End = 2,
+    }
+    public abstract class Stream : IDisposable {
+        public static readonly Stream Null;
+        protected Stream();
+        public abstract bool CanRead { get; }
+        public abstract bool CanSeek { get; }
+        public virtual bool CanTimeout { get; }
+        public abstract bool CanWrite { get; }
+        public abstract long Length { get; }
+        public abstract long Position { get; set; }
+        public virtual int ReadTimeout { get; set; }
+        public virtual int WriteTimeout { get; set; }
+        public virtual IAsyncResult BeginRead(byte[] buffer, int offset, int count, AsyncCallback callback, object state);
+        public virtual IAsyncResult BeginWrite(byte[] buffer, int offset, int count, AsyncCallback callback, object state);
+        public virtual void Close();
+        public void CopyTo(Stream destination);
+        public void CopyTo(Stream destination, int bufferSize);
+        public Task CopyToAsync(Stream destination);
+        public Task CopyToAsync(Stream destination, int bufferSize);
+        public virtual Task CopyToAsync(Stream destination, int bufferSize, CancellationToken cancellationToken);
+        public void Dispose();
+        protected virtual void Dispose(bool disposing);
+        public virtual int EndRead(IAsyncResult asyncResult);
+        public virtual void EndWrite(IAsyncResult asyncResult);
+        public abstract void Flush();
+        public Task FlushAsync();
+        public virtual Task FlushAsync(CancellationToken cancellationToken);
+        public abstract int Read(byte[] buffer, int offset, int count);
+        public Task<int> ReadAsync(byte[] buffer, int offset, int count);
+        public virtual Task<int> ReadAsync(byte[] buffer, int offset, int count, CancellationToken cancellationToken);
+        public virtual int ReadByte();
+        public abstract long Seek(long offset, SeekOrigin origin);
+        public abstract void SetLength(long value);
+        public abstract void Write(byte[] buffer, int offset, int count);
+        public Task WriteAsync(byte[] buffer, int offset, int count);
+        public virtual Task WriteAsync(byte[] buffer, int offset, int count, CancellationToken cancellationToken);
+        public virtual void WriteByte(byte value);
+    }
+    public class StreamReader : TextReader {
+        public static readonly new StreamReader Null;
+        public StreamReader(Stream stream);
+        public StreamReader(Stream stream, bool detectEncodingFromByteOrderMarks);
+        public StreamReader(Stream stream, Encoding encoding);
+        public StreamReader(Stream stream, Encoding encoding, bool detectEncodingFromByteOrderMarks);
+        public StreamReader(Stream stream, Encoding encoding, bool detectEncodingFromByteOrderMarks, int bufferSize);
+        public StreamReader(Stream stream, Encoding encoding, bool detectEncodingFromByteOrderMarks, int bufferSize, bool leaveOpen);
+        public StreamReader(string path);
+        public StreamReader(string path, bool detectEncodingFromByteOrderMarks);
+        public StreamReader(string path, Encoding encoding);
+        public StreamReader(string path, Encoding encoding, bool detectEncodingFromByteOrderMarks);
+        public StreamReader(string path, Encoding encoding, bool detectEncodingFromByteOrderMarks, int bufferSize);
+        public virtual Stream BaseStream { get; }
+        public virtual Encoding CurrentEncoding { get; }
+        public bool EndOfStream { get; }
+        public override void Close();
+        public void DiscardBufferedData();
+        protected override void Dispose(bool disposing);
+        public override int Peek();
+        public override int Read();
+        public override int Read(char[] buffer, int index, int count);
+        public override Task<int> ReadAsync(char[] buffer, int index, int count);
+        public override int ReadBlock(char[] buffer, int index, int count);
+        public override Task<int> ReadBlockAsync(char[] buffer, int index, int count);
+        public override string ReadLine();
+        public override Task<string> ReadLineAsync();
+        public override string ReadToEnd();
+        public override Task<string> ReadToEndAsync();
+    }
+    public class StreamWriter : TextWriter {
+        public static readonly new StreamWriter Null;
+        public StreamWriter(Stream stream);
+        public StreamWriter(Stream stream, Encoding encoding);
+        public StreamWriter(Stream stream, Encoding encoding, int bufferSize);
+        public StreamWriter(Stream stream, Encoding encoding, int bufferSize, bool leaveOpen);
+        public StreamWriter(string path);
+        public StreamWriter(string path, bool append);
+        public StreamWriter(string path, bool append, Encoding encoding);
+        public StreamWriter(string path, bool append, Encoding encoding, int bufferSize);
+        public virtual bool AutoFlush { get; set; }
+        public virtual Stream BaseStream { get; }
+        public override Encoding Encoding { get; }
+        public override void Close();
+        protected override void Dispose(bool disposing);
+        public override void Flush();
+        public override Task FlushAsync();
+        public override void Write(char value);
+        public override void Write(char[] buffer);
+        public override void Write(char[] buffer, int index, int count);
+        public override void Write(string value);
+        public override Task WriteAsync(char value);
+        public override Task WriteAsync(char[] buffer, int index, int count);
+        public override Task WriteAsync(string value);
+        public override Task WriteLineAsync();
+        public override Task WriteLineAsync(char value);
+        public override Task WriteLineAsync(char[] buffer, int index, int count);
+        public override Task WriteLineAsync(string value);
+    }
+    public class StringReader : TextReader {
+        public StringReader(string s);
+        public override void Close();
+        protected override void Dispose(bool disposing);
+        public override int Peek();
+        public override int Read();
+        public override int Read(char[] buffer, int index, int count);
+        public override Task<int> ReadAsync(char[] buffer, int index, int count);
+        public override Task<int> ReadBlockAsync(char[] buffer, int index, int count);
+        public override string ReadLine();
+        public override Task<string> ReadLineAsync();
+        public override string ReadToEnd();
+        public override Task<string> ReadToEndAsync();
+    }
+    public class StringWriter : TextWriter {
+        public StringWriter();
+        public StringWriter(IFormatProvider formatProvider);
+        public StringWriter(StringBuilder sb);
+        public StringWriter(StringBuilder sb, IFormatProvider formatProvider);
+        public override Encoding Encoding { get; }
+        public override void Close();
+        protected override void Dispose(bool disposing);
+        public override Task FlushAsync();
+        public virtual StringBuilder GetStringBuilder();
+        public override string ToString();
+        public override void Write(char value);
+        public override void Write(char[] buffer, int index, int count);
+        public override void Write(string value);
+        public override Task WriteAsync(char value);
+        public override Task WriteAsync(char[] buffer, int index, int count);
+        public override Task WriteAsync(string value);
+        public override Task WriteLineAsync(char value);
+        public override Task WriteLineAsync(char[] buffer, int index, int count);
+        public override Task WriteLineAsync(string value);
+    }
+    public abstract class TextReader : IDisposable {
+        public static readonly TextReader Null;
+        protected TextReader();
+        public virtual void Close();
+        public void Dispose();
+        protected virtual void Dispose(bool disposing);
+        public virtual int Peek();
+        public virtual int Read();
+        public virtual int Read(char[] buffer, int index, int count);
+        public virtual Task<int> ReadAsync(char[] buffer, int index, int count);
+        public virtual int ReadBlock(char[] buffer, int index, int count);
+        public virtual Task<int> ReadBlockAsync(char[] buffer, int index, int count);
+        public virtual string ReadLine();
+        public virtual Task<string> ReadLineAsync();
+        public virtual string ReadToEnd();
+        public virtual Task<string> ReadToEndAsync();
+    }
+    public abstract class TextWriter : IDisposable {
+        protected char[] CoreNewLine;
+        public static readonly TextWriter Null;
+        protected TextWriter();
+        protected TextWriter(IFormatProvider formatProvider);
+        public abstract Encoding Encoding { get; }
+        public virtual IFormatProvider FormatProvider { get; }
+        public virtual string NewLine { get; set; }
+        public virtual void Close();
+        public void Dispose();
+        protected virtual void Dispose(bool disposing);
+        public virtual void Flush();
+        public virtual Task FlushAsync();
+        public virtual void Write(bool value);
+        public virtual void Write(char value);
+        public virtual void Write(char[] buffer);
+        public virtual void Write(char[] buffer, int index, int count);
+        public virtual void Write(decimal value);
+        public virtual void Write(double value);
+        public virtual void Write(int value);
+        public virtual void Write(long value);
+        public virtual void Write(object value);
+        public virtual void Write(float value);
+        public virtual void Write(string value);
+        public virtual void Write(string format, object arg0);
+        public virtual void Write(string format, object arg0, object arg1);
+        public virtual void Write(string format, object arg0, object arg1, object arg2);
+        public virtual void Write(string format, params object[] arg);
+        public virtual void Write(uint value);
+        public virtual void Write(ulong value);
+        public virtual Task WriteAsync(char value);
+        public Task WriteAsync(char[] buffer);
+        public virtual Task WriteAsync(char[] buffer, int index, int count);
+        public virtual Task WriteAsync(string value);
+        public virtual void WriteLine();
+        public virtual void WriteLine(bool value);
+        public virtual void WriteLine(char value);
+        public virtual void WriteLine(char[] buffer);
+        public virtual void WriteLine(char[] buffer, int index, int count);
+        public virtual void WriteLine(decimal value);
+        public virtual void WriteLine(double value);
+        public virtual void WriteLine(int value);
+        public virtual void WriteLine(long value);
+        public virtual void WriteLine(object value);
+        public virtual void WriteLine(float value);
+        public virtual void WriteLine(string value);
+        public virtual void WriteLine(string format, object arg0);
+        public virtual void WriteLine(string format, object arg0, object arg1);
+        public virtual void WriteLine(string format, object arg0, object arg1, object arg2);
+        public virtual void WriteLine(string format, params object[] arg);
+        public virtual void WriteLine(uint value);
+        public virtual void WriteLine(ulong value);
+        public virtual Task WriteLineAsync();
+        public virtual Task WriteLineAsync(char value);
+        public Task WriteLineAsync(char[] buffer);
+        public virtual Task WriteLineAsync(char[] buffer, int index, int count);
+        public virtual Task WriteLineAsync(string value);
+    }
+    public class UnmanagedMemoryAccessor : IDisposable {
+        protected UnmanagedMemoryAccessor();
+        public UnmanagedMemoryAccessor(SafeBuffer buffer, long offset, long capacity);
+        public UnmanagedMemoryAccessor(SafeBuffer buffer, long offset, long capacity, FileAccess access);
+        public bool CanRead { get; }
+        public bool CanWrite { get; }
+        public long Capacity { get; }
+        protected bool IsOpen { get; }
+        public void Dispose();
+        protected virtual void Dispose(bool disposing);
+        protected void Initialize(SafeBuffer buffer, long offset, long capacity, FileAccess access);
+        public bool ReadBoolean(long position);
+        public byte ReadByte(long position);
+        public char ReadChar(long position);
+        public decimal ReadDecimal(long position);
+        public double ReadDouble(long position);
+        public short ReadInt16(long position);
+        public int ReadInt32(long position);
+        public long ReadInt64(long position);
+        public sbyte ReadSByte(long position);
+        public float ReadSingle(long position);
+        public ushort ReadUInt16(long position);
+        public uint ReadUInt32(long position);
+        public ulong ReadUInt64(long position);
+        public void Write(long position, bool value);
+        public void Write(long position, byte value);
+        public void Write(long position, char value);
+        public void Write(long position, decimal value);
+        public void Write(long position, double value);
+        public void Write(long position, short value);
+        public void Write(long position, int value);
+        public void Write(long position, long value);
+        public void Write(long position, sbyte value);
+        public void Write(long position, float value);
+        public void Write(long position, ushort value);
+        public void Write(long position, uint value);
+        public void Write(long position, ulong value);
+    }
+    public class UnmanagedMemoryStream : Stream {
+        protected UnmanagedMemoryStream();
+        public unsafe UnmanagedMemoryStream(byte* pointer, long length);
+        public unsafe UnmanagedMemoryStream(byte* pointer, long length, long capacity, FileAccess access);
+        public UnmanagedMemoryStream(SafeBuffer buffer, long offset, long length);
+        public UnmanagedMemoryStream(SafeBuffer buffer, long offset, long length, FileAccess access);
+        public override bool CanRead { get; }
+        public override bool CanSeek { get; }
+        public override bool CanWrite { get; }
+        public long Capacity { get; }
+        public override long Length { get; }
+        public override long Position { get; set; }
+        public unsafe byte* PositionPointer { get; set; }
+        protected override void Dispose(bool disposing);
+        public override void Flush();
+        public override Task FlushAsync(CancellationToken cancellationToken);
+        protected unsafe void Initialize(byte* pointer, long length, long capacity, FileAccess access);
+        protected void Initialize(SafeBuffer buffer, long offset, long length, FileAccess access);
+        public override int Read(byte[] buffer, int offset, int count);
+        public override Task<int> ReadAsync(byte[] buffer, int offset, int count, CancellationToken cancellationToken);
+        public override int ReadByte();
+        public override long Seek(long offset, SeekOrigin loc);
+        public override void SetLength(long value);
+        public override void Write(byte[] buffer, int offset, int count);
+        public override Task WriteAsync(byte[] buffer, int offset, int count, CancellationToken cancellationToken);
+        public override void WriteByte(byte value);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential, Size=1)]
+    public struct WaitForChangedResult {
+        public WatcherChangeTypes ChangeType { get; set; }
+        public string Name { get; set; }
+        public string OldName { get; set; }
+        public bool TimedOut { get; set; }
+    }
+    public enum WatcherChangeTypes {
+        All = 15,
+        Changed = 4,
+        Created = 1,
+        Deleted = 2,
+        Renamed = 8,
+    }
+}
```

