# .NET Core March Update - March 12, 2019

.NET Core 1.1.12 is available for [download](1.1.12-download.md) and usage in your environment.

* [.NET Core Blog][dotnet-blog]
* [Changes in this release](#changes-in-1112)
* [.NET Core Lifecycle News](#net-core-lifecycle-news)

The .NET Core SDK 1.1.13 includes .NET Core 1.1.12 Runtime so downloading the runtime packages separately is not needed when installing the SDK. After installing the .NET Core SDK 1.1.13, running `dotnet --version` will show that you're running version `1.1.13` of the .NET Core tools.

Your feedback is important and appreciated. We've created an issue at [dotnet/core #2432](https://github.com/dotnet/core/issues/2432) for your questions and comments.

## Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Look for the updated images for .NET Core 1.1.12 and .NET Core SDK 1.1.13 and read ["Staying up-to-date with .NET Container Images"](https://blogs.msdn.microsoft.com/dotnet/2018/06/18/staying-up-to-date-with-net-container-images/) for details and insights into using the .NET Core images.

## Azure AppServices

* Deployment of .NET Core 1.1.12 to Azure App Services has begun. It will be available in limited regions today and expected worldwide by the end of the week.

## .NET Core Lifecycle News

There are no changes this month in OS version support status.

.NET Core 1.0 and 1.1, which entered "Maintenance" support status when 2.1 was declared LTS, will be end-of-life June 27, 2019. Updates for the 1.0 and 1.1 channels will no longer be offered after that date. See [.NET Core Support Policy](https://dotnet.microsoft.com/platform/support/policy/dotnet-core) to learn more about the .NET Core support lifecycle.

See [.NET Core Supported OS Lifecycle Policy](https://github.com/dotnet/core/blob/main/os-lifecycle-policy.md) to learn about Windows, macOS and Linux versions that are supported for each .NET Core release.

## Changes in 1.1.12

* [CVE-2019-0657: .NET Core NuGet Tampering Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2019-0757)

    A tampering vulnerability exists in NuGet software when executed in a Linux or Mac environment. An attacker who successfully exploited the vulnerability could run arbitrary code in the context of the current user. If the current user is logged on with administrative user rights, an attacker could take control of the affected system. An attacker could then install programs; view, change, or delete data; or create new accounts with full user rights. Users whose accounts are configured to have fewer user rights on the system could be less impacted than users who operate with administrative user rights. Exploitation of the vulnerability requires that an attacker can login as any other user on that machine. At that point, the attacker will be able to replace or add to files that were created by a NuGet restore operation in the current users account.

    The security update addresses the vulnerability by correcting how NuGet restore creates file permissions for all files extracted to the client machine.

    **Affected Package and Binary updates**

    Package name | Vulnerable versions | Secure versions
    ------------ | ------------------- | -------------------------
    Nuget.Packaging | 4.3.0 | 4.3.1

## Package and Binary updates

Package name | Version
:----------- | :----------------
Microsoft.NETCore.App | 1.1.12
Microsoft.NETCore.DotNetHost | 1.1.12
Microsoft.NETCore.DotNetHostPolicy | 1.1.12
Microsoft.NETCore.DotNetHostResolver | 1.1.12
Microsoft.NETCore.ILAsm | 1.1.12
Microsoft.NETCore.ILDAsm | 1.1.12
Microsoft.NETCore.Jit | 1.1.12
Microsoft.NETCore.Runtime.CoreCLR | 1.1.12
Microsoft.NETCore.TestHost | 1.1.12
runtime.debian.8-x64.Microsoft.NETCore.DotNetHost | 1.1.12
runtime.debian.8-x64.Microsoft.NETCore.DotNetHostPolicy | 1.1.12
runtime.debian.8-x64.Microsoft.NETCore.DotNetHostResolver | 1.1.12
runtime.debian.8-x64.Microsoft.NETCore.ILAsm | 1.1.12
runtime.debian.8-x64.Microsoft.NETCore.ILDAsm | 1.1.12
runtime.debian.8-x64.Microsoft.NETCore.Jit | 1.1.12
runtime.debian.8-x64.Microsoft.NETCore.Runtime.CoreCLR | 1.1.12
runtime.debian.8-x64.Microsoft.NETCore.TestHost | 1.1.12
runtime.debian.9-x64.Microsoft.NETCore.DotNetHost | 1.1.12
runtime.debian.9-x64.Microsoft.NETCore.DotNetHostPolicy | 1.1.12
runtime.debian.9-x64.Microsoft.NETCore.DotNetHostResolver | 1.1.12
runtime.debian.9-x64.Microsoft.NETCore.ILAsm | 1.1.12
runtime.debian.9-x64.Microsoft.NETCore.ILDAsm | 1.1.12
runtime.debian.9-x64.Microsoft.NETCore.Jit | 1.1.12
runtime.debian.9-x64.Microsoft.NETCore.Runtime.CoreCLR | 1.1.12
runtime.debian.9-x64.Microsoft.NETCore.TestHost | 1.1.12
runtime.fedora.24-x64.Microsoft.NETCore.DotNetHost | 1.1.12
runtime.fedora.24-x64.Microsoft.NETCore.DotNetHostPolicy | 1.1.12
runtime.fedora.24-x64.Microsoft.NETCore.DotNetHostResolver | 1.1.12
runtime.fedora.24-x64.Microsoft.NETCore.ILAsm | 1.1.12
runtime.fedora.24-x64.Microsoft.NETCore.ILDAsm | 1.1.12
runtime.fedora.24-x64.Microsoft.NETCore.Jit | 1.1.12
runtime.fedora.24-x64.Microsoft.NETCore.Runtime.CoreCLR | 1.1.12
runtime.fedora.24-x64.Microsoft.NETCore.TestHost | 1.1.12
runtime.fedora.27-x64.Microsoft.NETCore.DotNetHost | 1.1.12
runtime.fedora.27-x64.Microsoft.NETCore.DotNetHostPolicy | 1.1.12
runtime.fedora.27-x64.Microsoft.NETCore.DotNetHostResolver | 1.1.12
runtime.fedora.27-x64.Microsoft.NETCore.ILAsm | 1.1.12
runtime.fedora.27-x64.Microsoft.NETCore.ILDAsm | 1.1.12
runtime.fedora.27-x64.Microsoft.NETCore.Jit | 1.1.12
runtime.fedora.27-x64.Microsoft.NETCore.Runtime.CoreCLR | 1.1.12
runtime.fedora.27-x64.Microsoft.NETCore.TestHost | 1.1.12
runtime.fedora.28-x64.Microsoft.NETCore.DotNetHost | 1.1.12
runtime.fedora.28-x64.Microsoft.NETCore.DotNetHostPolicy | 1.1.12
runtime.fedora.28-x64.Microsoft.NETCore.DotNetHostResolver | 1.1.12
runtime.fedora.28-x64.Microsoft.NETCore.ILAsm | 1.1.12
runtime.fedora.28-x64.Microsoft.NETCore.ILDAsm | 1.1.12
runtime.fedora.28-x64.Microsoft.NETCore.Jit | 1.1.12
runtime.fedora.28-x64.Microsoft.NETCore.Runtime.CoreCLR | 1.1.12
runtime.fedora.28-x64.Microsoft.NETCore.TestHost | 1.1.12
runtime.opensuse.42.1-x64.Microsoft.NETCore.DotNetHost | 1.1.12
runtime.opensuse.42.1-x64.Microsoft.NETCore.DotNetHostPolicy | 1.1.12
runtime.opensuse.42.1-x64.Microsoft.NETCore.DotNetHostResolver | 1.1.12
runtime.opensuse.42.1-x64.Microsoft.NETCore.ILAsm | 1.1.12
runtime.opensuse.42.1-x64.Microsoft.NETCore.ILDAsm | 1.1.12
runtime.opensuse.42.1-x64.Microsoft.NETCore.Jit | 1.1.12
runtime.opensuse.42.1-x64.Microsoft.NETCore.Runtime.CoreCLR | 1.1.12
runtime.opensuse.42.1-x64.Microsoft.NETCore.TestHost | 1.1.12
runtime.opensuse.42.3-x64.Microsoft.NETCore.DotNetHost | 1.1.12
runtime.opensuse.42.3-x64.Microsoft.NETCore.DotNetHostPolicy | 1.1.12
runtime.opensuse.42.3-x64.Microsoft.NETCore.DotNetHostResolver | 1.1.12
runtime.opensuse.42.3-x64.Microsoft.NETCore.ILAsm | 1.1.12
runtime.opensuse.42.3-x64.Microsoft.NETCore.ILDAsm | 1.1.12
runtime.opensuse.42.3-x64.Microsoft.NETCore.Jit | 1.1.12
runtime.opensuse.42.3-x64.Microsoft.NETCore.Runtime.CoreCLR | 1.1.12
runtime.opensuse.42.3-x64.Microsoft.NETCore.TestHost | 1.1.12
runtime.osx.10.10-x64.Microsoft.NETCore.DotNetHost | 1.1.12
runtime.osx.10.10-x64.Microsoft.NETCore.DotNetHostPolicy | 1.1.12
runtime.osx.10.10-x64.Microsoft.NETCore.DotNetHostResolver | 1.1.12
runtime.osx.10.10-x64.Microsoft.NETCore.ILAsm | 1.1.12
runtime.osx.10.10-x64.Microsoft.NETCore.ILDAsm | 1.1.12
runtime.osx.10.10-x64.Microsoft.NETCore.Jit | 1.1.12
runtime.osx.10.10-x64.Microsoft.NETCore.Runtime.CoreCLR | 1.1.12
runtime.osx.10.10-x64.Microsoft.NETCore.TestHost | 1.1.12
runtime.rhel.7-x64.Microsoft.NETCore.DotNetHost | 1.1.12
runtime.rhel.7-x64.Microsoft.NETCore.DotNetHostPolicy | 1.1.12
runtime.rhel.7-x64.Microsoft.NETCore.DotNetHostResolver | 1.1.12
runtime.rhel.7-x64.Microsoft.NETCore.ILAsm | 1.1.12
runtime.rhel.7-x64.Microsoft.NETCore.ILDAsm | 1.1.12
runtime.rhel.7-x64.Microsoft.NETCore.Jit | 1.1.12
runtime.rhel.7-x64.Microsoft.NETCore.Runtime.CoreCLR | 1.1.12
runtime.rhel.7-x64.Microsoft.NETCore.TestHost | 1.1.12
runtime.ubuntu.14.04-x64.Microsoft.NETCore.DotNetHost | 1.1.12
runtime.ubuntu.14.04-x64.Microsoft.NETCore.DotNetHostPolicy | 1.1.12
runtime.ubuntu.14.04-x64.Microsoft.NETCore.DotNetHostResolver | 1.1.12
runtime.ubuntu.14.04-x64.Microsoft.NETCore.ILAsm | 1.1.12
runtime.ubuntu.14.04-x64.Microsoft.NETCore.ILDAsm | 1.1.12
runtime.ubuntu.14.04-x64.Microsoft.NETCore.Jit | 1.1.12
runtime.ubuntu.14.04-x64.Microsoft.NETCore.Runtime.CoreCLR | 1.1.12
runtime.ubuntu.14.04-x64.Microsoft.NETCore.TestHost | 1.1.12
runtime.ubuntu.16.04-x64.Microsoft.NETCore.DotNetHost | 1.1.12
runtime.ubuntu.16.04-x64.Microsoft.NETCore.DotNetHostPolicy | 1.1.12
runtime.ubuntu.16.04-x64.Microsoft.NETCore.DotNetHostResolver | 1.1.12
runtime.ubuntu.16.04-x64.Microsoft.NETCore.ILAsm | 1.1.12
runtime.ubuntu.16.04-x64.Microsoft.NETCore.ILDAsm | 1.1.12
runtime.ubuntu.16.04-x64.Microsoft.NETCore.Jit | 1.1.12
runtime.ubuntu.16.04-x64.Microsoft.NETCore.Runtime.CoreCLR | 1.1.12
runtime.ubuntu.16.04-x64.Microsoft.NETCore.TestHost | 1.1.12
runtime.ubuntu.18.04-x64.Microsoft.NETCore.DotNetHost | 1.1.12
runtime.ubuntu.18.04-x64.Microsoft.NETCore.DotNetHostPolicy | 1.1.12
runtime.ubuntu.18.04-x64.Microsoft.NETCore.DotNetHostResolver | 1.1.12
runtime.ubuntu.18.04-x64.Microsoft.NETCore.ILAsm | 1.1.12
runtime.ubuntu.18.04-x64.Microsoft.NETCore.ILDAsm | 1.1.12
runtime.ubuntu.18.04-x64.Microsoft.NETCore.Jit | 1.1.12
runtime.ubuntu.18.04-x64.Microsoft.NETCore.Runtime.CoreCLR | 1.1.12
runtime.ubuntu.18.04-x64.Microsoft.NETCore.TestHost | 1.1.12
runtime.win10-arm64.Microsoft.NETCore.DotNetHost | 1.1.12
runtime.win10-arm64.Microsoft.NETCore.DotNetHostPolicy | 1.1.12
runtime.win10-arm64.Microsoft.NETCore.DotNetHostResolver | 1.1.12
runtime.win10-arm64.Microsoft.NETCore.ILAsm | 1.1.12
runtime.win10-arm64.Microsoft.NETCore.ILDAsm | 1.1.12
runtime.win10-arm64.Microsoft.NETCore.Jit | 1.1.12
runtime.win10-arm64.Microsoft.NETCore.Runtime.CoreCLR | 1.1.12
runtime.win10-arm64.Microsoft.NETCore.TestHost | 1.1.12
runtime.win7-x64.Microsoft.NETCore.DotNetHost | 1.1.12
runtime.win7-x64.Microsoft.NETCore.DotNetHostPolicy | 1.1.12
runtime.win7-x64.Microsoft.NETCore.DotNetHostResolver | 1.1.12
runtime.win7-x64.Microsoft.NETCore.ILAsm | 1.1.12
runtime.win7-x64.Microsoft.NETCore.ILDAsm | 1.1.12
runtime.win7-x64.Microsoft.NETCore.Jit | 1.1.12
runtime.win7-x64.Microsoft.NETCore.Runtime.CoreCLR | 1.1.12
runtime.win7-x64.Microsoft.NETCore.TestHost | 1.1.12
runtime.win7-x86.Microsoft.NETCore.DotNetHost | 1.1.12
runtime.win7-x86.Microsoft.NETCore.DotNetHostPolicy | 1.1.12
runtime.win7-x86.Microsoft.NETCore.DotNetHostResolver | 1.1.12
runtime.win7-x86.Microsoft.NETCore.ILAsm | 1.1.12
runtime.win7-x86.Microsoft.NETCore.ILDAsm | 1.1.12
runtime.win7-x86.Microsoft.NETCore.Jit | 1.1.12
runtime.win7-x86.Microsoft.NETCore.Runtime.CoreCLR | 1.1.12
runtime.win7-x86.Microsoft.NETCore.TestHost | 1.1.12

[dotnet-blog]: https://devblogs.microsoft.com/dotnet/net-core-march-2019/