# Release Notes

## .NET Core May 2017 Update - 1.1.2 Released 5/8/2017

This release includes critical security and reliability updates to improve the quality of .NET Core. The latest releases can be found on the [.NET Core download pages](https://dotnet.microsoft.com/download/dotnet/current/runtime) or from the following.

* [.NET Core Runtime 1.0.5](https://github.com/dotnet/core/blob/main/release-notes/download-archives/1.0.5-download.md)
* [.NET Core Runtime 1.1.2](https://github.com/dotnet/core/blob/main/release-notes/download-archives/1.1.2-download.md)
* [.NET Core SDK 1.0.4](https://github.com/dotnet/core/blob/main/release-notes/download-archives/1.0.4-sdk-download.md)

The .NET Core SDK 1.0.4 includes .NET Core 1.0.5 and 1.1.2 runtimes so downloading the runtime packages separately is not needed when installing the SDK.

Details regarding the security issues addressed by this release can be seen in the [Security Advisory announcement](https://github.com/dotnet/announcements/issues/12).

### .NET Core 1.0.5 Symbol Packages

Symbol packages for .NET 1.0.5 are available for download from the following locations.

* [CoreCLR](https://go.microsoft.com/fwlink/?LinkID=848773)
* [CoreFX](https://go.microsoft.com/fwlink/?LinkID=848774)

### Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. See the new image names below.

#### SDK

* 1.0.5-sdk
* 1.0.5-sdk-nanoserver
* 1.1.2-sdk
* 1.1.2-sdk-nanoserver

#### Runtime

* 1.0.5-runtime
* 1.0.5-runtime-nanoserver
* 1.1.2-runtime
* 1.1.2-runtime-nanoserver

## Closed issues for this release

#### CoreCLR

* [`[640a13cae]`](https://github.com/dotnet/coreclr/commit/640a13cae) Fix debugging on OS X Sierra (#10078) (#10103)
* [`[dafae2f23]`](https://github.com/dotnet/coreclr/commit/dafae2f23) GetAllocatedBytesForCurrentThread unpredictably returns inaccurate values (#10277)
* [`[8123965bc]`](https://github.com/dotnet/coreclr/commit/8123965bc) Eliminate EncodingForwarder performance impact (#10805)

#### CoreFX

* [`[9933227ad9]`](https://github.com/dotnet/corefx/commit/9933227ad9) [HttpClient perf] Ensure CURLOPT_TCP_NODELAY is set by CurlHandler (#16895)
* [`[47d83388b3]`](https://github.com/dotnet/corefx/commit/47d83388b3) Add Xamarin support to System.ValueTuple package (#16447)
* [`[8d774a8244]`](https://github.com/dotnet/corefx/commit/8d774a8244) Update AspNetCoreHosting keyword (#16477) 
* [`[ed4a5c8b97]`](https://github.com/dotnet/corefx/commit/ed4a5c8b97) Adding updates to packages to update SqlClient in the 1.1.x release (#17635)
* [`[Microsoft Common Vulnerabilities and Exposures CVE-2017-0248]`](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2017-0248) Fix for a security feature bypass vulnerability  when .NET Core components do not completely validate certificates.
* [`[Microsoft Common Vulnerabilities and Exposures CVE-2017-0247]`](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2017-0247) .NET Core HTML Encode Unicode Multibyte Vulnerability (System.Text.Encodings.Web) - this is not part of Shared Framework.

### ASP.NET Core

* Please see the [ASP.NET Core release page](https://github.com/aspnet/home/releases/1.1.2) for details on fixes from ASP.NET Core, MVC, Entity Framework Core and others.
