# .NET Core January 2018 Update - January 9, 2018

Microsoft is releasing security advisories for .NET Core and ASP.NET Core. Issues addressed by this update are summarized in the [fixes](#fixes) section below. Details can be found in corresponding announcements in the [.NET Core](https://github.com/dotnet/announcements/issues?q=is%3Aopen+is%3Aissue+label%3ASecurity) and [ASP.NET Core](https://github.com/aspnet/announcements/issues?q=is%3Aopen+is%3Aissue+label%3ASecurity) repos.

.NET Core 2.0.5 and SDK 2.1.4 are available for download and usage in your environment.

* [Announcement](https://blogs.msdn.microsoft.com/dotnet/2018/01/09/net-core-january-2018-update/)
* [Getting Started](https://dotnet.microsoft.com/download)
* [Downloads](https://github.com/dotnet/core/blob/main/release-notes/download-archives/2.0.5-download.md)

The .NET Core SDK 2.1.4 includes .NET Core 2.0.5 Runtime so downloading the runtime packages separately is not needed when installing the SDK. After installing the .NET Core SDK 2.1.4, the following command will show that you're running version `2.1.4` of the tools.

`dotnet --version`

Your feedback is important and appreciated. We've created an issue at [dotnet/core #1199](https://github.com/dotnet/core/issues/1199) for your questions and comments.

## Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Look for the 2.0.5 images.

## Azure AppServices

Deployment of this update to Azure AppServices is in process. Because AppServices is a high availability service, the deployment is carfully staged across regions over a period of time. Deployment will begin in the West US 2 and North Central US regions with remaining regions following over a few days.

## Known Issues

### Using Linux package managers to update `dotnet-host.x86_64` breaks .NET Core

**Issue:** Running the package manager `update` command on Linux systems where .NET Core has been previously installed may offer an update for `dotnet-host.x86_64`. If the update is allowed to proceed, .NET Core could be in a broken state as only the dotnet host is updated.

**Resolution:** To install the update, either the Runtime or SDK must be explicitly installed. e.g. `sudo [apt-get, yum, dnf, zypper] install dotnet-runtime-2.0.5`, if you only need the runtime or `sudo [apt-get, yum, dnf, zypper] dotnet-sdk-2.1.4`, to install both the SDK and Runtime.

We are working to improve our Linux packages to enable correct package manager update behavior. This work is being tracked in the following issues:

* [dotnet/core-setup/issues/3556](https://github.com/dotnet/core-setup/issues/3556)
* [dotnet/cli/issues/8209](https://github.com/dotnet/cli/issues/8209)

## Package and Binary updates

The following packages and binaries are updated by the January 2018 update:

### System.Private.Corelib.dll

Microsoft.NETCore.App

### System.Private.ServiceModel

* System.ServiceModel.Primitives
* System.ServiceModel.Http
* System.ServiceModel.NetTcp
* System.ServiceModel.Security
* System.ServiceModel.Duplex

### System.Private.Xml.dll

* System.Xml.ReaderWriter
* System.Xml.XmlDocument
* System.Xml.XmlSerializer
* System.Xml.XPath
* System.Xml.XPath.XDocument

## Notable Fixes and Commits

### CVE-2018-0786 - Security Feature Bypass in X509 Certificate Validation

Microsoft is aware of a security vulnerability in the public versions of .NET Core where an attacker could present a certificate that is marked invalid for a specific use, but a component uses it for that purpose. This action disregards the Enhanced Key Usage tagging.

The security update addresses the vulnerability by ensuring that .NET Core components completely validate certificates.

[CVE-2018-0786](https://github.com/dotnet/announcements/issues/51)

### CVE-2018-0764 - Denial of Service when parsing XML documents

Microsoft is aware of a Denial of Service vulnerability in all public versions of .NET core due to improper processing of XML documents. An attacker who successfully exploited this vulnerability could cause a denial of service against a .NET application. A remote unauthenticated attacker could exploit this vulnerability by issuing specially crafted requests to a .NET Core application.

The update addresses the vulnerability by correcting how .NET core handles XML document processing.

[CVE-2018-0764](https://github.com/dotnet/announcements/issues/52)

### Commits

#### CoreFX

* [`[3f1155b]`](https://github.com/dotnet/corefx/commit/3f1155b) Merged PR 94589: Harden hashing in Xml NameTable

#### CoreCLR

* [`[8ce622d]`](https://github.com/dotnet/coreclr/commit/8ce622d) Merged PR 95709: Fix validating RegionInfo names with long string

#### CLI

* [`[1c5b49b]`](https://github.com/dotnet/cli/commit/1c5b49b) 2017-12-04 Nuget.config update to align with CLI:master - add comments in DependencyVersions.prop
* [`[11d9413]`](https://github.com/dotnet/cli/commit/11d9413) 2017-12-04 Updating the websdk version to 2.0.0-rel-20171110-671
* [`[902904c]`](https://github.com/dotnet/cli/commit/902904c) 2017-12-07 Updating the msbuild version for Microsoft.Build.Runtime.
* [`[ed91673]`](https://github.com/dotnet/cli/commit/ed91673) 2017-12-13 Updating the runtime to 2.0.5.
* [`[8c93b6d]`](https://github.com/dotnet/cli/commit/8c93b6d) 2017-12-20 Update to consume aspnetcore 2.0.5-155

#### WCF

* [`[c3182d4]`](https://github.com/dotnet/wcf/commit/c3182d46f45780e52a393aee30ff48e57dbc53ae) 2017-12-13 X509 Certificate Validation fix-up
