# .NET Core 2.1.12

.NET Core 2.1.12 comprises:

* .NET Core Runtime 2.1.12
* ASP.NET Core 2.1.12
* .NET Core SDK 2.1.508

See the [Release Notes](https://github.com/dotnet/core/blob/main/release-notes/2.1/2.1.12/2.1.12.md) for details about what is included in this update.

**NOTE:** If you are a Visual Studio user, there are MSBuild version requirements so use only the .NET Core SDK supported for each Visual Studio version. If you use other development environments, we recommend using the latest SDK release.

| VS Version | .NET Core SDK |
| :-- | :--: |
| Visual Studio 2017 (Windows) | [2.1.508](#downloads) |
| Visual Studio 2019 version 16.0 (Windows) | [2.1.605](2.1.605-sdk-download.md) |
| Visual Studio 2019 version 16.1 (Windows) | [2.1.701](2.1.701-sdk-download.md) |
| Visual Studio 2019 version 16.2 (Windows) | [2.1.801](2.1.801-sdk-download.md) |
| Visual Studio for Mac | https://docs.microsoft.com/visualstudio/mac/net-core-support |

## Downloads
|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [ARM][dotnet-runtime-win-arm.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| <br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup>
| Linux     | [See installations steps below][linux-install]   | [x64][dotnet-sdk-linux-x64.tar.gz] \| [ARM][dotnet-sdk-linux-arm.tar.gz] \| [ARM64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [ARM][dotnet-runtime-linux-arm.tar.gz] \| [ARM64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [ARM][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz]<sup>1</sup> |
| RHEL6     | -                                                | [x64][dotnet-sdk-rhel.6-x64.tar.gz]                    | -                                                        | [x64][dotnet-runtime-rhel.6-x64.tar.gz] | - |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - |
| Symbols   | [CLI][cli215xx-symbols.zip] \| [SDK][dotnet-sdk-symbols.zip]  | -                                        | [Runtime][coreclr-symbols.zip] \| [Shared Framework][corefx-symbols.zip] \| [Setup][core-setup-symbols.zip] | - | [ASP.NET Core][aspnet-symbols.zip] |

1. Includes the .NET Core and ASP.NET Core Runtimes
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.


## Docker

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://devblogs.microsoft.com/dotnet/staying-up-to-date-with-net-container-images/).

## Installing .NET Core on Linux

### Install using Snap

Snap is a system which installs applications in an isolated environment and provides for automatic updates. Many distributions which are not directly supported by .NET Core can use Snaps to install. See the [list of distributions supported Snap](https://docs.snapcraft.io/installing-snapd/6735) for details.

After configuring Snap on your system, run the following command to install the latest .NET Core SDK.

`sudo snap install dotnet-sdk --classic`

When .NET Core in installed using the Snap package, the default .NET Core command is `dotnet-sdk.dotnet`, as opposed to just `dotnet`. The benefit of the namespaced command is that it will not conflict with a globally installed .NET Core version you may have. This command can be aliased to `dotnet` with:

`sudo snap alias dotnet-sdk.dotnet dotnet`

**Note:** Some distros require an additional step to enable access to the SSL certificate. If you experience SSL errors when running `dotnet restore`, see [Linux Setup](https://github.com/dotnet/core/blob/main/Documentation/linux-setup.md) for a possible resolution.

### Install using a Package Manager

Before installing .NET, you will need to register the Microsoft key, register the product repository, and install required dependencies. This only needs to be done once per machine. Refer to [Setting up Linux for .NET Core][linux-setup] for the requirements.

The commands listed below do not specifically incude package managers to help with readability. Here are the package managers typically used by the Distros on which .NET Core is supported.

| Distro | Package Manager  |
| ---             | :----:  |
| CentOS, Oracle  | yum     |
| Debian, Ubuntu  | apt-get |
| Fedora          | dnf     |
| OpenSUSE, SLES  | zypper  |

### Develop applications
To develop applications using the .NET Core SDK, run the following command. The .NET Core runtime and ASP.NET Core runtime are included.

```bash
sudo [package manager] update or refresh
sudo [package manager] install dotnet-sdk-2.1
```

### Run applications
If you only need to run existing applications, run the following command. The .NET Core runtime and ASP.NET Core runtime are included.

```bash
sudo [package manager] update or refresh
sudo [package manager] install aspnetcore-runtime-2.1
```

### Installation from a binary archive

Installing from the packages detailed above is recommended or you can install from binary archive, if that better suits your needs. When using binary archives to install, the contents must be extracted to a user location such as `$HOME/dotnet`, a symbolic link created for `dotnet` and a few dependencies installed. Dependency requirements can be seen in the [Linux System Prerequisites](https://github.com/dotnet/core/blob/main/Documentation/linux-prereqs.md) document.

```bash
mkdir -p $HOME/dotnet && tar zxf dotnet.tar.gz -C $HOME/dotnet
export PATH=$PATH:$HOME/dotnet
```

## .NET Core Runtime-only installation

If only the .NET Core Runtime is needed, install `dotnet-runtime-2.1` using your package manager. If you also need ASP.NET Core functionality, installing `aspnetcore-runtime-2.1` will install both the ASP Runtime and .NET Core Runtime.

## Windows Server Hosting

If you are looking to host stand-alone apps on Servers, the following installer can be used on Windows systems.

### Windows

You can download the Windows Server Hosting installer and run the following command from an Administrator command prompt:

* [dotnet-hosting-2.1.12-win.exe][dotnet-hosting-win.exe]

This will install the ASP.NET Core Module for IIS.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/2.1/2.1.12/2.1.12.md

[//]: # ( Runtime 2.1.12)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f759670e-1f8d-4f1a-8eb7-58b95f94c68c/69eca04ca138dc6c3caa160bd1b891d1/dotnet-runtime-2.1.12-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b6ac0d5e-513c-416e-acf2-124a51551a1b/a34dea8d2abb62d29d4bf76a10b9dc30/dotnet-runtime-2.1.12-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/467a6d37-d1a9-4640-8517-93a638e574a8/32c24faccb0d5460089dafc9babe0251/dotnet-runtime-2.1.12-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2c78594a-dd2c-488e-b201-b7fd9b78ab00/5f2169b20fc704e069c336114ec653c5/dotnet-runtime-2.1.12-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/f25e0161-ec20-46a7-87a7-881dbb6a04a1/a1d22440ce211d4e2e13203561c7d770/dotnet-runtime-2.1.12-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/63ca131a-270d-427f-a85f-d328b160ef85/7ed226a80fedae75c6ef2a7f3090904b/dotnet-runtime-2.1.12-osx-x64.tar.gz
[dotnet-runtime-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8716e3ad-f2b4-4d87-9133-61ded394a42f/89820fd294fa07616e8423534eced0cc/dotnet-runtime-2.1.12-rhel.6-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/db199ce9-e39d-4115-8d24-a42e440c4930/b3a30d1d6855f8b4c42844c31b373333/dotnet-runtime-2.1.12-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/ddd9d981-872f-4b62-b942-cfbf9c7e0e60/cbfc51fb841d7398a5ad9acb50d4f8ee/dotnet-runtime-2.1.12-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/dcf8c839-2ffd-4677-9b29-4af9c44e170e/59de767034f66051fe6eab61fa757be1/dotnet-runtime-2.1.12-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/0fd34b03-08ed-44ec-9761-308717c7fd27/7556f134a19420dbe781b44a13c4d666/dotnet-runtime-2.1.12-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/3c85a8f2-2d5c-4a42-811b-2e89f04151a8/7583d56dcd286c7112781125c9fca215/dotnet-runtime-2.1.12-win-x86.zip

[//]: # ( ASP 2.1.12)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/66039441-8e90-47e9-ac2e-74ad0e8d2174/c26b37f6d82e2a96751c85ff48727d6f/aspnetcore-runtime-2.1.12-linux-arm.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/dc2bad3f-7ebc-4579-990a-52e16dff204b/260ce8c864f201717dfe75f4146c3b40/aspnetcore-runtime-2.1.12-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c1b620fe-7d8e-4685-b6ae-82b444dbc7a7/3d5610f0607da49ee014c61c6cd4e9af/aspnetcore-runtime-2.1.12-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/90ed1613-140d-4daf-9edd-7037bea2116c/cbc63e0e394727de0460ddddd3dcf58a/aspnetcore-runtime-2.1.12-osx-x64.tar.gz
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/de023b91-4177-4e0b-9941-40f2e44d5408/ea7705ae5993202807ad98dcf7b8ddf7/aspnetcore-runtime-2.1.12-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/3e6c7d2d-3ca9-49ff-8168-bd85c88e4138/eeca26ac5189c66f044c3a0a462e1409/aspnetcore-runtime-2.1.12-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/d8b36b96-890f-4207-9418-565fa6e7b64f/775b6912b82886fdb7be25b63a47bc57/aspnetcore-runtime-2.1.12-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/dbd566a6-3629-45bf-804f-79e86d6c6a93/ed8a595e8db40013264f8f304423ed6a/aspnetcore-runtime-2.1.12-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/eebd54bc-c3a2-4580-bb29-b35c1c5ffa92/22ffe5649861167d3d5728d3cb4b10a1/dotnet-hosting-2.1.12-win.exe

[//]: # ( SDK 2.1.508 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bf9e4894-8be5-4489-a7f8-a63b5b1b94e1/4c835afa300c2f88d9ce9b1930810a7f/dotnet-sdk-2.1.508-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4efacca7-6aa7-4d17-914a-8640a13d48ec/643d927e12256aad75296a98e727a9c9/dotnet-sdk-2.1.508-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/549be9ab-72d0-406f-9e0e-bb23ba747613/5fa6214ad1245e79d724fe36b5279f46/dotnet-sdk-2.1.508-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0349bef8-8dfe-431e-80ff-ca6e1b986bea/5d0831e58173722f28422efeea889e81/dotnet-sdk-2.1.508-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/37b50bfe-0525-45a9-9dd0-fe3f1e802df4/149dc3ed72873908e0675656bcb30b9c/dotnet-sdk-2.1.508-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fd1fcfe3-d67c-4533-8d1c-4ff5eaf781ae/6ac777895421e1ac8153cd94f2feb372/dotnet-sdk-2.1.508-osx-x64.tar.gz
[dotnet-sdk-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c4d92f34-8432-43ac-9954-a3e229359a9e/1c88d923d55dc19ce576269c254ba7ed/dotnet-sdk-2.1.508-rhel.6-x64.tar.gz
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/2f2d03ef-b000-46a2-abf5-8b863e438568/cddce0caa2526db658e0d21937f89b28/dotnet-sdk-2.1.508-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/bac2ecc8-9115-4414-987a-638d40153e03/df7bc8e7128208b814ea1c38d7241a34/dotnet-sdk-2.1.508-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/28487a49-8109-4434-8668-eeebf7ed60fc/5cb465e10451e3e34bd2c75c7333e69f/dotnet-sdk-2.1.508-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/c9f03bfe-e856-4f0b-b90e-207029944a19/9aabccba702eb23e9f3044f2391dfa6b/dotnet-sdk-2.1.508-win-x86.zip

[//]: # ( Symbols )
[aspnet-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/9b6a0892-903d-4b68-aaf0-8b9479c27ea3/a2431f48b4080c8110a266acbff1b875/aspnet-2.1.12-symbols.zip
[cli215xx-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/b2827643-f988-4be5-9fab-e138abfeb943/61396a618cf18e01c265f76b0163e4ef/cli215xx-2.1.12-symbols.zip
[cli216xx-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/6efc74cb-8901-4cf5-825e-67b7e90fc41f/c03c4bb19edc4dea072c5b8b0b6b1bd4/cli216xx-2.1.12-symbols.zip
[cli217xx-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/97244428-1e08-444e-930a-f9b6ccc08863/e80424a203118e63b5b4033df48396dd/cli217xx-2.1.12-symbols.zip
[core-setup-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/b992d510-45cc-4d55-8bd6-9cd67b5d5dde/b719f8b5e4a497b9a1448008cf9a2631/core-setup-2.1.12-symbols.zip
[coreclr-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/e5ab8e45-a8ee-4445-bb67-ef489bb5f67d/c3b1272e7d2e7048900e9b1b9d0bd8e9/coreclr-2.1.12-symbols.zip
[corefx-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/d288a4e6-535e-4166-b366-255432094f24/7305738b4ca3aa8de98e35357fa36636/corefx-2.1.12-symbols.zip
[dotnet-sdk-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/895223a7-e490-44ab-b7b0-46c510ccb51b/1438cae050d6fabcfdf08caf346500bf/dotnet-sdk-2.1.12-symbols.zip

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.12-runtime-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.701-sdk-sha.txt

[linux-install]: https://docs.microsoft.com/dotnet/core/install/linux
[linux-setup]: https://github.com/dotnet/core/blob/main/Documentation/linux-setup.md

[dotnet-blog]: https://devblogs.microsoft.com/dotnet/
