# .NET Core 2.1.18 Update - May 12, 2020

[.NET Core 2.1.18](https://dotnet.microsoft.com/download/dotnet/2.1) is available for download and usage in your environment. This release includes .NET Core 2.1.18, ASP.NET Core 2.1.18 and the .NET Core SDK.

* [Blog Post][dotnet-blog]
* [Downloads](#downloads)
* [Changes in this release](#changes-in-2118)
* [Known Issues](../2.1-known-issues.md)
* [Visual Studio Compatibility](#visual-studio-compatibility)

Your feedback is important and appreciated. We've created an issue at [dotnet/core #4675](https://github.com/dotnet/core/issues/4675) for your questions and comments.

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [ARM][dotnet-runtime-win-arm.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| <br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup>
| Linux     | [See installations steps below][linux-install]   | [x64][dotnet-sdk-linux-x64.tar.gz] \| [ARM][dotnet-sdk-linux-arm.tar.gz] \| [ARM64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [ARM][dotnet-runtime-linux-arm.tar.gz] \| [ARM64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [ARM][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz]<sup>1</sup> |
| RHEL6     | -                                                | [x64][dotnet-sdk-rhel.6-x64.tar.gz]                    | -                                                        | [x64][dotnet-runtime-rhel.6-x64.tar.gz] | - |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - |

1. Includes the .NET Core and ASP.NET Core Runtimes
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.


## Visual Studio Compatibility

This update for .NET Core 2.1 includes multiple SDK builds. If you are a Visual Studio 2019, Visual Studio 2017 or Visual Studio for Mac user, there are MSBuild version requirements that are satisfied by specific, matching .NET Core SDK versions. See the table below to select the correct download.

| OS | Development Environment | .NET Core SDK |
| :-- | :-- | :--: |
| Windows | Visual Studio 2019 version 16.0 | [2.1.611](2.1.611-download.md) |
| Windows | Visual Studio 2017 | [2.1.514](#downloads) |
| MacOS | Visual Studio for Mac | [Visual Studio for Mac .NET Core Support](https://docs.microsoft.com/visualstudio/mac/net-core-support) |

Note: This is not a security release hence this update will not be immediately available through Visual Studio. However, this is expected to show up in Visual Studio's March servicing release.

## Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://blogs.msdn.microsoft.com/dotnet/2018/06/18/staying-up-to-date-with-net-container-images/).

The following repos have been updated

* [dotnet/core/runtime](https://hub.docker.com/_/microsoft-dotnet-core-runtime/)
* [dotnet/core/sdk](https://hub.docker.com/_/microsoft-dotnet-core-sdk/)
* [dotnet/core/samples](https://hub.docker.com/_/microsoft-dotnet-core-samples)
* [dotnet/aspnetcore](https://hub.docker.com/_/microsoft-dotnet-core-aspnet)

The images are expected to be available later today.

## Azure AppServices

* .NET Core 2.1.18 is being deployed to Azure App Services and the deployment is expected to complete later in May 2020.

## .NET Core Lifecycle News

Ubuntu 20.04 has been added as [supported OS](../2.1-supported-os.md) with this update of .NET Core 2.1.

.NET Core 3.1 is now available natively in the Fedora 32 package archives. See the [Fedora documentation](https://docs.fedoraproject.org/en-US/fedora/f32/release-notes/developers/Development_Dotnet/) for details.

Alpine 3.8 has been out of support since [May 01, 2020](https://wiki.alpinelinux.org/wiki/Alpine_Linux:Releases) and .NET Core no longer provides support for it.

## Changes in 2.1.18

.NET Core 2.1.18 release carries both security and non-security fixes.


### [CVE-2020-1108: .NET Core Denial of Service Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2020-1108)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET Core. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

Microsoft is aware of a denial of service vulnerability which exists when .NET Core improperly handles web requests. An attacker who successfully exploited this vulnerability could cause a denial of service against a .NET Core web application. The vulnerability can be exploited remotely, without authentication.

A remote unauthenticated attacker could exploit this vulnerability by issuing specially crafted requests to the .NET Core application.

For further information visit [GitHub Announcement](https://github.com/dotnet/announcements/issues/156)

### Additional fixes in this release
* [CoreFX](https://github.com/dotnet/corefx/issues?utf8=%E2%9C%93&q=milestone%3A2.1.18+label%3Aservicing-approved)


## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.AspNetCore.All	|	2.1.18
Microsoft.AspNetCore.App	|	2.1.18
Microsoft.AspNetCore.Mvc.Formatters.Json	|	2.1.18
Microsoft.DotNet.Web.Client.ItemTemplates	|	2.1.18
Microsoft.DotNet.Web.ItemTemplates	|	2.1.18
Microsoft.DotNet.Web.ProjectTemplates.2.1	|	2.1.18
Microsoft.DotNet.Web.Spa.ProjectTemplates.2.1	|	2.1.18
Microsoft.NETCore.Platforms	|	2.1.10
Microsoft.NETCore.App	|	2.1.18
Microsoft.NETCore.DotNetAppHost	|	2.1.18
Microsoft.NETCore.DotNetHost	|	2.1.18
Microsoft.NETCore.DotNetHostPolicy	|	2.1.18
Microsoft.NETCore.DotNetHostResolver	|	2.1.18
runtime.linux-arm.Microsoft.NETCore.App	|	2.1.18
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost	|	2.1.18
runtime.linux-arm.Microsoft.NETCore.DotNetHost	|	2.1.18
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy	|	2.1.18
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver	|	2.1.18
runtime.linux-arm64.Microsoft.NETCore.App	|	2.1.18
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost	|	2.1.18
runtime.linux-arm64.Microsoft.NETCore.DotNetHost	|	2.1.18
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy	|	2.1.18
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver	|	2.1.18
runtime.linux-musl-x64.Microsoft.NETCore.App	|	2.1.18
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost	|	2.1.18
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost	|	2.1.18
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy	|	2.1.18
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver	|	2.1.18
runtime.linux-x64.Microsoft.NETCore.App	|	2.1.18
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost	|	2.1.18
runtime.linux-x64.Microsoft.NETCore.DotNetHost	|	2.1.18
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy	|	2.1.18
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver	|	2.1.18
runtime.osx-x64.Microsoft.NETCore.App	|	2.1.18
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost	|	2.1.18
runtime.osx-x64.Microsoft.NETCore.DotNetHost	|	2.1.18
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy	|	2.1.18
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver	|	2.1.18
runtime.rhel.6-x64.Microsoft.NETCore.App	|	2.1.18
runtime.rhel.6-x64.Microsoft.NETCore.DotNetAppHost	|	2.1.18
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHost	|	2.1.18
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHostPolicy	|	2.1.18
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHostResolver	|	2.1.18
runtime.win-arm.Microsoft.NETCore.App	|	2.1.18
runtime.win-arm.Microsoft.NETCore.DotNetAppHost	|	2.1.18
runtime.win-arm.Microsoft.NETCore.DotNetHost	|	2.1.18
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy	|	2.1.18
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver	|	2.1.18
runtime.win-arm64.Microsoft.NETCore.App	|	2.1.18
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost	|	2.1.18
runtime.win-arm64.Microsoft.NETCore.DotNetHost	|	2.1.18
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy	|	2.1.18
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver	|	2.1.18
runtime.win-x64.Microsoft.NETCore.App	|	2.1.18
runtime.win-x64.Microsoft.NETCore.DotNetAppHost	|	2.1.18
runtime.win-x64.Microsoft.NETCore.DotNetHost	|	2.1.18
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy	|	2.1.18
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver	|	2.1.18
runtime.win-x86.Microsoft.NETCore.App	|	2.1.18
runtime.win-x86.Microsoft.NETCore.DotNetAppHost	|	2.1.18
runtime.win-x86.Microsoft.NETCore.DotNetHost	|	2.1.18
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy	|	2.1.18
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver	|	2.1.18
VS.Redist.Common.NetCore.HostFXR.x64.2.1	|	2.1.18-servicing-28802-01
VS.Redist.Common.NetCore.HostFXR.x86.2.1	|	2.1.18-servicing-28802-01
VS.Redist.Common.NetCore.SharedFramework.x64.2.1	|	2.1.18-servicing-28802-01
VS.Redist.Common.NetCore.SharedFramework.x86.2.1	|	2.1.18-servicing-28802-01
VS.Redist.Common.NetCore.SharedHost.x64.2.1	|	2.1.18-servicing-28802-01
VS.Redist.Common.NetCore.SharedHost.x86.2.1	|	2.1.18-servicing-28802-01



[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/2.1/2.1.18/2.1.18.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.18-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.18-sha.txt

[linux-install]: https://docs.microsoft.com/dotnet/core/install/linux
[dotnet-blog]: https://devblogs.microsoft.com/dotnet/net-core-may-2020/




[//]: # ( Runtime 2.1.18)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/16bebe85-416e-4861-80d0-5f3aabbb1aca/8fc9f20392b4f0713c8cbb7f7d54d1ec/dotnet-runtime-2.1.18-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/625ecbe4-9ac2-4f69-aac6-1eddc3f300af/dd2a80ca6ec5f6c83fe3d4411cf9a88d/dotnet-runtime-2.1.18-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/de91bfa2-b50c-401f-8593-98c20b015417/41de11d720283ff617eb9ae2b958f53a/dotnet-runtime-2.1.18-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6e807a9b-e080-4daa-9224-9c12a8a3a673/fb96d3545590177aecf9feec1ff07876/dotnet-runtime-2.1.18-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/bc303f50-ec1d-43b4-b846-51d5fc3c1a2d/4f0abfa496fba6a387dc80b450eb65b8/dotnet-runtime-2.1.18-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/328acf26-3ea7-4cdf-8d0e-875dda44b970/04d431c1c76e0fc9fda09fe4b7502fca/dotnet-runtime-2.1.18-osx-x64.tar.gz
[dotnet-runtime-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bb651119-fcf6-40ce-88b2-faa5794a8546/45882f0af30dc500b88bd90c6c48410a/dotnet-runtime-2.1.18-rhel.6-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/2e0597bf-8928-4808-9db2-65f184d9678f/d7d1b21b7a0900eb2ead3e81adc101ac/dotnet-runtime-2.1.18-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/53d3ad06-172f-4848-abc1-c70003de009e/1f45c5c98848c284c90b888933298f94/dotnet-runtime-2.1.18-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/9777f165-0ed1-41a4-ad4b-60e176b6fff5/52fb6a870663cc58dba3f24d2ad363a5/dotnet-runtime-2.1.18-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/b90bbf7b-8739-4326-8e55-431a65dba1ba/8bfe25d90f428124ff42d63004fb0430/dotnet-runtime-2.1.18-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/713dc3a1-4330-47ca-8f93-2a802be16bef/3eeb677600143b119d2cace5c02f1fa5/dotnet-runtime-2.1.18-win-x86.zip

[//]: # ( WindowsDesktop )

[//]: # ( ASP 2.1.18)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3170bb79-e8b5-4f19-921e-618c16d5671a/085344b0aaea8c6a1cb15818af1b6328/aspnetcore-runtime-2.1.18-linux-arm.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/33730d62-65bd-4b8f-912e-9e21113ec747/118d50ff9c5b12240a4e758a5c2d2958/aspnetcore-runtime-2.1.18-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5e23ff62-5ddd-4fc5-9f72-e4250110cf58/956138123fcefedca324b0fea6c23d15/aspnetcore-runtime-2.1.18-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/992a6e2c-ded6-4923-a808-9f5164e23425/3084cd84de9e2a583fd514c4b8567935/aspnetcore-runtime-2.1.18-osx-x64.tar.gz
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/b7f473cd-1b78-4b97-8cb4-e600ef285129/f1bb08da9e2b48f3135b02bad34b3207/aspnetcore-runtime-2.1.18-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/915829f6-cba0-424b-820d-83f831704605/3f3314e7e652a65b0b4d3f40bb2d3f16/aspnetcore-runtime-2.1.18-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/c61a68eb-ef58-420e-a5e5-af403fb4e58c/0cd9cd4943be4da0e6e5b099824ff428/aspnetcore-runtime-2.1.18-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/6cf2053a-e52b-48bf-a208-d4b458a3bfe2/78e5eb00cf45378295d2115ebda45a9d/aspnetcore-runtime-2.1.18-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/95f36881-f24a-4e5a-bff9-74dba1c5ae60/04384e05d0ddf9098288c5c01f79ad01/dotnet-hosting-2.1.18-win.exe



[//]: # ( SDK 2.1.514 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cfcc3817-b524-42dc-9760-05b902ce8328/efcbd6fa92372cde33e66af40d206515/dotnet-sdk-2.1.514-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bf43ad9b-44a2-41ca-b917-05eaa279ede3/3d6d2b5345d3a015db6a64046252e8d2/dotnet-sdk-2.1.514-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1e538dcb-8bb4-407d-b0ae-6007f6095fe6/43074915bff09ca0af56ab46228a3710/dotnet-sdk-2.1.514-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/56155631-159c-475e-a057-6ce2ef861565/5f1d6620156afebce94d67af9f59594b/dotnet-sdk-2.1.514-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/1a79bb3d-7d99-4a50-88d3-31901564f05e/0f4a860125fa9e1ad447dcd603c5fc5b/dotnet-sdk-2.1.514-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/676bb253-31f8-43fa-9a4e-e217faaf0eac/1de0957735689d2108fac4505322e29a/dotnet-sdk-2.1.514-osx-x64.tar.gz
[dotnet-sdk-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/99f4b10d-1d20-40e2-a836-0a4cbb1e9abd/16ffc6bf624276512fc8692e9d495451/dotnet-sdk-2.1.514-rhel.6-x64.tar.gz
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/6331b459-77f3-487a-b313-3d5062efeebe/fa2e1cb20a6e2c9a18e8f28a6fdb781c/dotnet-sdk-2.1.514-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/563de998-0ba8-4879-b20d-d529525a7278/1b309cee08ab9bda220e415c84f91049/dotnet-sdk-2.1.514-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/e8357f27-944e-4481-8e3b-65ec2cdbaf05/098384bdee0436c7eee7565f4b98c674/dotnet-sdk-2.1.514-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/d1593de6-f7dc-490e-803c-a7912e87aeff/3a4e0a063920c6256db03c1e3d94327a/dotnet-sdk-2.1.514-win-x86.zip

[//]: # ( Symbols )
