# .NET Core 2.1.19 Update - June 9, 2020

[.NET Core 2.1.19](https://dotnet.microsoft.com/download/dotnet/2.1) is available for download and usage in your environment. This release includes .NET Core 2.1.19, ASP.NET Core 2.1.19 and the .NET Core SDK.

* [Blog Post][dotnet-blog]
* [Downloads](#downloads)
* [Changes in this release](#changes-in-2119)
* [Known Issues](../2.1-known-issues.md)
* [Visual Studio Compatibility](#visual-studio-compatibility)

Your feedback is important and appreciated. We've created an issue at [dotnet/core #4803](https://github.com/dotnet/core/issues/4803) for your questions and comments.

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [ARM][dotnet-runtime-win-arm.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| <br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup>
| Linux     | [See installations steps below][linux-install]   | [x64][dotnet-sdk-linux-x64.tar.gz] \| [ARM][dotnet-sdk-linux-arm.tar.gz] \| [ARM64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [ARM][dotnet-runtime-linux-arm.tar.gz] \| [ARM64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [ARM][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz]<sup>1</sup> |
| RHEL6     | -                                                | [x64][dotnet-sdk-rhel.6-x64.tar.gz]                    | -                                                        | [x64][dotnet-runtime-rhel.6-x64.tar.gz] | - |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - |

1. Includes the .NET Core and ASP.NET Core Runtimes
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.


## Visual Studio Compatibility

This update for .NET Core 2.1 includes multiple SDK builds. If you are a Visual Studio 2019, Visual Studio 2017 or Visual Studio for Mac user, there are MSBuild version requirements that are satisfied by specific, matching .NET Core SDK versions. See the table below to select the correct download.

| OS | Development Environment | .NET Core SDK |
| :-- | :-- | :--: |
| Windows | Visual Studio 2019 version 16.0 | [2.1.612](2.1.612-download.md) |
| Windows | Visual Studio 2017 | [2.1.515](#downloads) |
| MacOS | Visual Studio for Mac | [Visual Studio for Mac .NET Core Support](https://docs.microsoft.com/visualstudio/mac/net-core-support) |

Note: This is not a security release hence this update will not be immediately available through Visual Studio. However, this is expected to show up in Visual Studio's March servicing release.

## Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://blogs.msdn.microsoft.com/dotnet/2018/06/18/staying-up-to-date-with-net-container-images/).

The following repos have been updated

* [dotnet/core/runtime](https://hub.docker.com/_/microsoft-dotnet-core-runtime/)
* [dotnet/core/sdk](https://hub.docker.com/_/microsoft-dotnet-core-sdk/)
* [dotnet/core/samples](https://hub.docker.com/_/microsoft-dotnet-core-samples)
* [dotnet/aspnetcore](https://hub.docker.com/_/microsoft-dotnet-core-aspnet)

The images are expected to be available later today.

## Azure AppServices

* .NET Core 2.1.19 is being deployed to Azure App Services and the deployment is expected to complete later in June 2020.

## .NET Core Lifecycle News

Alpine 3.12 and Centos 8 have been added as [supported OS](../2.1-supported-os.md) with this update of .NET Core 2.1.

## Changes in 2.1.19

.NET Core 2.1.19 release carries a security fix.


### [CVE-2020-1108: .NET Core Denial of Service Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2020-1108)

To comprehensively address CVE-2020-1108, Microsoft has released updates for .NET Core 2.1 and .NET Core 3.1. Customers who use any of these versions of .NET Core should install the latest version of .NET Core. See the [Release Notes](https://github.com/dotnet/announcements/issues/157) for the latest version numbers and instructions for updating .NET Core.

Microsoft is aware of a denial of service vulnerability which exists when .NET Core improperly handles web requests. An attacker who successfully exploited this vulnerability could cause a denial of service against a .NET Core web application. The vulnerability can be exploited remotely, without authentication. 

A remote unauthenticated attacker could exploit this vulnerability by issuing specially crafted requests to the .NET Core application. The update addresses the vulnerability by correcting how the .NET Core web application handles web requests. 


## Packages updated in this release:

Package name | Version
:----------- | :------------------
microsoft.aspnetcore.all | 2.1.19.nupkg
microsoft.aspnetcore.app | 2.1.19.nupkg
microsoft.dotnet.web.client.itemtemplates | 2.1.19.nupkg
microsoft.dotnet.web.itemtemplates | 2.1.19.nupkg
microsoft.dotnet.web.projecttemplates.2.1 | 2.1.19.nupkg
microsoft.dotnet.web.spa.projecttemplates.2.1 | 2.1.19.nupkg
microsoft.netcore.app | 2.1.19.nupkg
microsoft.netcore.dotnetapphost | 2.1.19.nupkg
microsoft.netcore.dotnethost | 2.1.19.nupkg
microsoft.netcore.dotnethostpolicy | 2.1.19.nupkg
microsoft.netcore.dotnethostresolver | 2.1.19.nupkg
runtime.linux-arm.microsoft.netcore.app | 2.1.19.nupkg
runtime.linux-arm.microsoft.netcore.dotnetapphost | 2.1.19.nupkg
runtime.linux-arm.microsoft.netcore.dotnethost | 2.1.19.nupkg
runtime.linux-arm.microsoft.netcore.dotnethostpolicy | 2.1.19.nupkg
runtime.linux-arm.microsoft.netcore.dotnethostresolver | 2.1.19.nupkg
runtime.linux-arm64.microsoft.netcore.app | 2.1.19.nupkg
runtime.linux-arm64.microsoft.netcore.dotnetapphost | 2.1.19.nupkg
runtime.linux-arm64.microsoft.netcore.dotnethost | 2.1.19.nupkg
runtime.linux-arm64.microsoft.netcore.dotnethostpolicy | 2.1.19.nupkg
runtime.linux-arm64.microsoft.netcore.dotnethostresolver | 2.1.19.nupkg
runtime.linux-musl-x64.microsoft.netcore.app | 2.1.19.nupkg
runtime.linux-musl-x64.microsoft.netcore.dotnetapphost | 2.1.19.nupkg
runtime.linux-musl-x64.microsoft.netcore.dotnethost | 2.1.19.nupkg
runtime.linux-musl-x64.microsoft.netcore.dotnethostpolicy | 2.1.19.nupkg
runtime.linux-musl-x64.microsoft.netcore.dotnethostresolver | 2.1.19.nupkg
runtime.linux-x64.microsoft.netcore.app | 2.1.19.nupkg
runtime.linux-x64.microsoft.netcore.dotnetapphost | 2.1.19.nupkg
runtime.linux-x64.microsoft.netcore.dotnethost | 2.1.19.nupkg
runtime.linux-x64.microsoft.netcore.dotnethostpolicy | 2.1.19.nupkg
runtime.linux-x64.microsoft.netcore.dotnethostresolver | 2.1.19.nupkg
runtime.osx-x64.microsoft.netcore.app | 2.1.19.nupkg
runtime.osx-x64.microsoft.netcore.dotnetapphost | 2.1.19.nupkg
runtime.osx-x64.microsoft.netcore.dotnethost | 2.1.19.nupkg
runtime.osx-x64.microsoft.netcore.dotnethostpolicy | 2.1.19.nupkg
runtime.osx-x64.microsoft.netcore.dotnethostresolver | 2.1.19.nupkg
runtime.rhel.6-x64.microsoft.netcore.app | 2.1.19.nupkg
runtime.rhel.6-x64.microsoft.netcore.dotnetapphost | 2.1.19.nupkg
runtime.rhel.6-x64.microsoft.netcore.dotnethost | 2.1.19.nupkg
runtime.rhel.6-x64.microsoft.netcore.dotnethostpolicy | 2.1.19.nupkg
runtime.rhel.6-x64.microsoft.netcore.dotnethostresolver | 2.1.19.nupkg
runtime.win-arm.microsoft.netcore.app | 2.1.19.nupkg
runtime.win-arm.microsoft.netcore.dotnetapphost | 2.1.19.nupkg
runtime.win-arm.microsoft.netcore.dotnethost | 2.1.19.nupkg
runtime.win-arm.microsoft.netcore.dotnethostpolicy | 2.1.19.nupkg
runtime.win-arm.microsoft.netcore.dotnethostresolver | 2.1.19.nupkg
runtime.win-arm64.microsoft.netcore.app | 2.1.19.nupkg
runtime.win-arm64.microsoft.netcore.dotnetapphost | 2.1.19.nupkg
runtime.win-arm64.microsoft.netcore.dotnethost | 2.1.19.nupkg
runtime.win-arm64.microsoft.netcore.dotnethostpolicy | 2.1.19.nupkg
runtime.win-arm64.microsoft.netcore.dotnethostresolver | 2.1.19.nupkg
runtime.win-x64.microsoft.netcore.app | 2.1.19.nupkg
runtime.win-x64.microsoft.netcore.dotnetapphost | 2.1.19.nupkg
runtime.win-x64.microsoft.netcore.dotnethost | 2.1.19.nupkg
runtime.win-x64.microsoft.netcore.dotnethostpolicy | 2.1.19.nupkg
runtime.win-x64.microsoft.netcore.dotnethostresolver | 2.1.19.nupkg
runtime.win-x86.microsoft.netcore.app | 2.1.19.nupkg
runtime.win-x86.microsoft.netcore.dotnetapphost | 2.1.19.nupkg
runtime.win-x86.microsoft.netcore.dotnethost | 2.1.19.nupkg
runtime.win-x86.microsoft.netcore.dotnethostpolicy | 2.1.19.nupkg
runtime.win-x86.microsoft.netcore.dotnethostresolver | 2.1.19.nupkg
vs.redist.common.netcore.hostfxr.x64.2.1 | 2.1.19-servicing-28921-03.nupkg
vs.redist.common.netcore.hostfxr.x64.2.1 | 2.1.19-servicing-28922-02.nupkg
vs.redist.common.netcore.hostfxr.x64.2.1 | 2.1.19-servicing-28922-05.nupkg
vs.redist.common.netcore.hostfxr.x64.2.1 | 2.1.19-servicing-28924-01.nupkg
vs.redist.common.netcore.hostfxr.x64.2.1 | 2.1.19-servicing-28926-01.nupkg
vs.redist.common.netcore.hostfxr.x64.2.1 | 2.1.19-servicing-28928-01.nupkg
vs.redist.common.netcore.hostfxr.x86.2.1 | 2.1.19-servicing-28921-03.nupkg
vs.redist.common.netcore.hostfxr.x86.2.1 | 2.1.19-servicing-28922-02.nupkg
vs.redist.common.netcore.hostfxr.x86.2.1 | 2.1.19-servicing-28922-04.nupkg
vs.redist.common.netcore.hostfxr.x86.2.1 | 2.1.19-servicing-28922-05.nupkg
vs.redist.common.netcore.hostfxr.x86.2.1 | 2.1.19-servicing-28924-01.nupkg
vs.redist.common.netcore.hostfxr.x86.2.1 | 2.1.19-servicing-28926-01.nupkg
vs.redist.common.netcore.hostfxr.x86.2.1 | 2.1.19-servicing-28928-01.nupkg
vs.redist.common.netcore.sharedframework.x64.2.1 | 2.1.19-servicing-28921-03.nupkg
vs.redist.common.netcore.sharedframework.x64.2.1 | 2.1.19-servicing-28922-02.nupkg
vs.redist.common.netcore.sharedframework.x64.2.1 | 2.1.19-servicing-28922-05.nupkg
vs.redist.common.netcore.sharedframework.x64.2.1 | 2.1.19-servicing-28924-01.nupkg
vs.redist.common.netcore.sharedframework.x64.2.1 | 2.1.19-servicing-28926-01.nupkg
vs.redist.common.netcore.sharedframework.x64.2.1 | 2.1.19-servicing-28928-01.nupkg
vs.redist.common.netcore.sharedframework.x86.2.1 | 2.1.19-servicing-28921-03.nupkg
vs.redist.common.netcore.sharedframework.x86.2.1 | 2.1.19-servicing-28922-02.nupkg
vs.redist.common.netcore.sharedframework.x86.2.1 | 2.1.19-servicing-28922-04.nupkg
vs.redist.common.netcore.sharedframework.x86.2.1 | 2.1.19-servicing-28922-05.nupkg
vs.redist.common.netcore.sharedframework.x86.2.1 | 2.1.19-servicing-28924-01.nupkg
vs.redist.common.netcore.sharedframework.x86.2.1 | 2.1.19-servicing-28926-01.nupkg
vs.redist.common.netcore.sharedframework.x86.2.1 | 2.1.19-servicing-28928-01.nupkg
vs.redist.common.netcore.sharedhost.x64.2.1 | 2.1.19-servicing-28921-03.nupkg
vs.redist.common.netcore.sharedhost.x64.2.1 | 2.1.19-servicing-28922-02.nupkg
vs.redist.common.netcore.sharedhost.x64.2.1 | 2.1.19-servicing-28922-05.nupkg
vs.redist.common.netcore.sharedhost.x64.2.1 | 2.1.19-servicing-28924-01.nupkg
vs.redist.common.netcore.sharedhost.x64.2.1 | 2.1.19-servicing-28926-01.nupkg
vs.redist.common.netcore.sharedhost.x64.2.1 | 2.1.19-servicing-28928-01.nupkg
vs.redist.common.netcore.sharedhost.x86.2.1 | 2.1.19-servicing-28921-03.nupkg
vs.redist.common.netcore.sharedhost.x86.2.1 | 2.1.19-servicing-28922-02.nupkg
vs.redist.common.netcore.sharedhost.x86.2.1 | 2.1.19-servicing-28922-04.nupkg
vs.redist.common.netcore.sharedhost.x86.2.1 | 2.1.19-servicing-28922-05.nupkg
vs.redist.common.netcore.sharedhost.x86.2.1 | 2.1.19-servicing-28924-01.nupkg
vs.redist.common.netcore.sharedhost.x86.2.1 | 2.1.19-servicing-28926-01.nupkg
vs.redist.common.netcore.sharedhost.x86.2.1 | 2.1.19-servicing-28928-01.nupkg




[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/2.1/2.1.19/2.1.19.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.19-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.19-sha.txt

[linux-install]: https://docs.microsoft.com/dotnet/core/install/linux
[dotnet-blog]: https://devblogs.microsoft.com/dotnet/net-core-june-2020/




[//]: # ( Runtime 2.1.19)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cbe38aa4-087c-4daf-989d-f589054ca80b/871416c0056912e202d889c795c048c7/dotnet-runtime-2.1.19-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9ac2d7d3-c431-4859-af9b-87f1325a65ef/3928845f1187f848835d192afe27ec43/dotnet-runtime-2.1.19-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c26ab2e7-a54a-4231-b11a-59ce1475a894/f5f9153122571f6161d2e348051417ce/dotnet-runtime-2.1.19-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/64f26bd4-a0d0-47c3-87e6-2ba75d42b0a6/f9789f3f1f3ddddf385a1393e5b09989/dotnet-runtime-2.1.19-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/430a5c87-567d-4414-9ec0-6ace50e9750d/9092d51c5b75c2a76769c50bce349b51/dotnet-runtime-2.1.19-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f5b5af04-339c-4e01-993e-b2bb6b80ad80/46b1a332897568436618df89617ad9d0/dotnet-runtime-2.1.19-osx-x64.tar.gz
[dotnet-runtime-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5ddb5b56-921c-45d9-a355-1c542d553f09/7ccc1bf0c0779ae28b356f1299a39729/dotnet-runtime-2.1.19-rhel.6-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/f60b43e8-01ff-4f47-bdc0-3b5a8ddd3f0d/d3e8991c3e88b964e1719138e9edb8a8/dotnet-runtime-2.1.19-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/7efea5a3-1365-48e1-8946-6ca6851f3952/f7d545ae430b9d83e4ebc9247a17b096/dotnet-runtime-2.1.19-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/d1b9def4-0d12-446e-a0e4-88cb14accfa8/0f8e8c3a8100b6559cff0267549153ff/dotnet-runtime-2.1.19-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/d0fbbf54-b844-4022-93f0-2ffaa93354b2/14f2dcd822f352331eaa60186e15194a/dotnet-runtime-2.1.19-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/387741ae-3e13-4e00-98be-359ec73c41f5/da250a40fbee22c12985caff4dccb328/dotnet-runtime-2.1.19-win-x86.zip

[//]: # ( WindowsDesktop )

[//]: # ( ASP 2.1.19)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4e8cd01e-9b3d-4e69-837d-f8d558fb1a9f/e1c52cf207aee58ae4aff32d09ecfe05/aspnetcore-runtime-2.1.19-linux-arm.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e14036b9-60a8-4e1e-93c0-2649e65a9ece/f1e5d157c615420f4311d2d90b71a762/aspnetcore-runtime-2.1.19-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/abf8cad9-fe36-4bb6-9cdb-926a50bf63c6/5dc2f4e3e133ef073f12340d4fd6e943/aspnetcore-runtime-2.1.19-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/22ef858a-7c3b-4985-aa3b-609d118af67e/8eb85303e42bc099bc4b3b5abf890e76/aspnetcore-runtime-2.1.19-osx-x64.tar.gz
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/04953eff-44d5-45e6-ab12-95d1a9a1e88e/60fddf880eb5d4952d5a1358b566d8ab/aspnetcore-runtime-2.1.19-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/6bafbf91-d105-40ba-9f05-99b1bbd8b789/548b30b88e44fd4995ce0585ca9037fd/aspnetcore-runtime-2.1.19-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/032fa388-eea5-46d3-bbff-a27d6c5d6034/535c7f37640d98c56180b19152182c03/aspnetcore-runtime-2.1.19-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/40dfe80d-b50f-4c80-92e2-11af72075f3c/4a998070648613e7f842abb49fd27f87/aspnetcore-runtime-2.1.19-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/988d236a-30bf-4e96-8063-665d27c922c9/b793025960eaf182d8f32e723ad9b47a/dotnet-hosting-2.1.19-win.exe


[//]: # ( SDK 2.1.515 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0e29c1d2-8870-4faf-bae2-3b6bfc9235eb/462607fe7cd52587f3294368f0ce2296/dotnet-sdk-2.1.515-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c07f8224-d331-402c-9bb0-d2dbf77779f6/ddfebdecefbdfbb4e42d9618f7e05c05/dotnet-sdk-2.1.515-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/43483387-7937-49fa-8ae8-09da1b9008d3/0ff842912b90dc0b6362960ca0911ab9/dotnet-sdk-2.1.515-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/57e4a4f9-6da0-445d-a085-8f4406b5e79d/e640a084deff62b3ca3b7c43c8f53892/dotnet-sdk-2.1.515-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/7f180c25-195e-4919-89cf-4cdf9bc2c47a/e2c953588d71a9e2e706a380b87146ae/dotnet-sdk-2.1.515-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/921e00f2-367b-49cc-ae62-450e3854c743/a6d9316fdcfe45f8c0f0ce0b4bb2a02b/dotnet-sdk-2.1.515-osx-x64.tar.gz
[dotnet-sdk-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e9999ec1-46f0-4308-bb05-98ea7118c4a4/2be91074618d9bf7da9f44edd22d6779/dotnet-sdk-2.1.515-rhel.6-x64.tar.gz
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/d117c700-66e0-4793-91bb-f372a15b3165/250eecb26eede3e29f4f98faccb3094a/dotnet-sdk-2.1.515-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/7a39ca0e-2dfe-475d-98ae-00836307f0aa/203d1fbfa1d6f57d2fb6f5e73d056a2c/dotnet-sdk-2.1.515-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/1d45bd0c-5ed7-429e-a3f4-436180550da2/6c814cb573f4ccc8df999d4fb158837a/dotnet-sdk-2.1.515-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/40fee765-b69e-47f8-b824-4d358f7c1057/0fbcad2930eb0c64f9adabd363a1398e/dotnet-sdk-2.1.515-win-x86.zip

[//]: # ( Symbols )
