# .NET Core 2.1.24 Update - January 12, 2021

The .NET 2.1.24 and .NET SDK 2.1.520 releases are available for download. The latest 2.1 release is always listed at [.NET 2.1 Releases](../README.md).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [ARM][dotnet-runtime-win-arm.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| <br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup>
| Linux     | [See installation steps][linux-install]   | [x64][dotnet-sdk-linux-x64.tar.gz] \| [ARM][dotnet-sdk-linux-arm.tar.gz] \| [ARM64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [ARM][dotnet-runtime-linux-arm.tar.gz] \| [ARM64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [ARM][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz]<sup>1</sup> |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - |

</br>
1. Includes the .NET Core and ASP.NET Core Runtimes.
</br>2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.

</br>

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
2.1.520
```

Visit [.NET Documentation](https://docs.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Core Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together.

The following repos have been updated:

* [dotnet/sdk](https://hub.docker.com/_/microsoft-dotnet-sdk/): .NET Core SDK
* [dotnet/aspnet](https://hub.docker.com/_/microsoft-dotnet-aspnet/): ASP.NET Core Runtime
* [dotnet/runtime](https://hub.docker.com/_/microsoft-dotnet-runtime/): .NET Core Runtime
* [dotnet/runtime-deps](https://hub.docker.com/_/microsoft-dotnet-runtime-deps/): .NET Core Runtime Dependencies


## Visual Studio Compatibility

This update for .NET Core 2.1 includes multiple SDK builds. If you are a Visual Studio 2019, Visual Studio 2017 or Visual Studio for Mac user, there are MSBuild version requirements that are satisfied by specific, matching .NET Core SDK versions. See the following table to select the correct download.

| OS | Development Environment | .NET Core SDK |
| :-- | :-- | :--: |
| Windows | Visual Studio 2019 version 16.0 | [2.1.617](2.1.617-download.md) |
| Windows | Visual Studio 2017 | [2.1.520](#downloads) |
| macOS | Visual Studio for Mac | [Visual Studio for Mac .NET Core Support](https://docs.microsoft.com/visualstudio/mac/net-core-support) |

Note: This is not a security release hence this update won't be immediately available through Visual Studio. However, this is expected to show up in Visual Studio's January servicing release.

This update of .NET Core 2.1 is the last update for .NET Core 2.1.6xx SDK since [Visual Studio 16.0 is out of support](https://docs.microsoft.com/en-us/visualstudio/releases/2019/servicing) as of January 2021. We will continue to update versions 2.1.5xx and 2.1.8xx until [.NET Core 2.1 reaches end of life](https://github.com/dotnet/core/blob/main/releases.md).


## Notable Changes

.NET Core 2.1.24 release carries both security and non-security fixes.

* [Blog Roundup][dotnet-blog]
* [Known issues](../2.1-known-issues.md)

### Additional fixes in this release

* [CoreFX](https://github.com/dotnet/corefx/issues?utf8=%E2%9C%93&q=milestone%3A2.1.24+label%3Aservicing-approved)

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #5838](https://github.com/dotnet/core/issues/5838) for your questions and comments.

## Packages updated in this release:

Package name | Version
:----------- | :------------------
microsoft.aspnetcore.all | 2.1.24.nupkg
microsoft.aspnetcore.app | 2.1.24.nupkg
microsoft.aspnetcore.dataprotection.azurekeyvault | 2.1.24.nupkg
microsoft.aspnetcore.dataprotection.azurestorage | 2.1.24.nupkg
microsoft.dotnet.web.client.itemtemplates | 2.1.24.nupkg
microsoft.dotnet.web.itemtemplates | 2.1.24.nupkg
microsoft.dotnet.web.projecttemplates.2.1 | 2.1.24.nupkg
microsoft.dotnet.web.spa.projecttemplates.2.1 | 2.1.24.nupkg
microsoft.extensions.configuration.azurekeyvault | 2.1.24.nupkg
microsoft.netcore.app | 2.1.24.nupkg
microsoft.netcore.dotnetapphost | 2.1.24.nupkg
microsoft.netcore.dotnethost | 2.1.24.nupkg
microsoft.netcore.dotnethostpolicy | 2.1.24.nupkg
microsoft.netcore.dotnethostresolver | 2.1.24.nupkg
runtime.linux-arm.microsoft.netcore.app | 2.1.24.nupkg
runtime.linux-arm.microsoft.netcore.dotnetapphost | 2.1.24.nupkg
runtime.linux-arm.microsoft.netcore.dotnethost | 2.1.24.nupkg
runtime.linux-arm.microsoft.netcore.dotnethostpolicy | 2.1.24.nupkg
runtime.linux-arm.microsoft.netcore.dotnethostresolver | 2.1.24.nupkg
runtime.linux-arm64.microsoft.netcore.app | 2.1.24.nupkg
runtime.linux-arm64.microsoft.netcore.dotnetapphost | 2.1.24.nupkg
runtime.linux-arm64.microsoft.netcore.dotnethost | 2.1.24.nupkg
runtime.linux-arm64.microsoft.netcore.dotnethostpolicy | 2.1.24.nupkg
runtime.linux-arm64.microsoft.netcore.dotnethostresolver | 2.1.24.nupkg
runtime.linux-musl-x64.microsoft.netcore.app | 2.1.24.nupkg
runtime.linux-musl-x64.microsoft.netcore.dotnetapphost | 2.1.24.nupkg
runtime.linux-musl-x64.microsoft.netcore.dotnethost | 2.1.24.nupkg
runtime.linux-musl-x64.microsoft.netcore.dotnethostpolicy | 2.1.24.nupkg
runtime.linux-musl-x64.microsoft.netcore.dotnethostresolver | 2.1.24.nupkg
runtime.linux-x64.microsoft.netcore.app | 2.1.24.nupkg
runtime.linux-x64.microsoft.netcore.dotnetapphost | 2.1.24.nupkg
runtime.linux-x64.microsoft.netcore.dotnethost | 2.1.24.nupkg
runtime.linux-x64.microsoft.netcore.dotnethostpolicy | 2.1.24.nupkg
runtime.linux-x64.microsoft.netcore.dotnethostresolver | 2.1.24.nupkg
runtime.osx-x64.microsoft.netcore.app | 2.1.24.nupkg
runtime.osx-x64.microsoft.netcore.dotnetapphost | 2.1.24.nupkg
runtime.osx-x64.microsoft.netcore.dotnethost | 2.1.24.nupkg
runtime.osx-x64.microsoft.netcore.dotnethostpolicy | 2.1.24.nupkg
runtime.osx-x64.microsoft.netcore.dotnethostresolver | 2.1.24.nupkg
runtime.win-arm.microsoft.netcore.app | 2.1.24.nupkg
runtime.win-arm.microsoft.netcore.dotnetapphost | 2.1.24.nupkg
runtime.win-arm.microsoft.netcore.dotnethost | 2.1.24.nupkg
runtime.win-arm.microsoft.netcore.dotnethostpolicy | 2.1.24.nupkg
runtime.win-arm.microsoft.netcore.dotnethostresolver | 2.1.24.nupkg
runtime.win-arm64.microsoft.netcore.app | 2.1.24.nupkg
runtime.win-arm64.microsoft.netcore.dotnetapphost | 2.1.24.nupkg
runtime.win-arm64.microsoft.netcore.dotnethost | 2.1.24.nupkg
runtime.win-arm64.microsoft.netcore.dotnethostpolicy | 2.1.24.nupkg
runtime.win-arm64.microsoft.netcore.dotnethostresolver | 2.1.24.nupkg
runtime.win-x64.microsoft.netcore.app | 2.1.24.nupkg
runtime.win-x64.microsoft.netcore.dotnetapphost | 2.1.24.nupkg
runtime.win-x64.microsoft.netcore.dotnethost | 2.1.24.nupkg
runtime.win-x64.microsoft.netcore.dotnethostpolicy | 2.1.24.nupkg
runtime.win-x64.microsoft.netcore.dotnethostresolver | 2.1.24.nupkg
runtime.win-x86.microsoft.netcore.app | 2.1.24.nupkg
runtime.win-x86.microsoft.netcore.dotnetapphost | 2.1.24.nupkg
runtime.win-x86.microsoft.netcore.dotnethost | 2.1.24.nupkg
runtime.win-x86.microsoft.netcore.dotnethostpolicy | 2.1.24.nupkg
runtime.win-x86.microsoft.netcore.dotnethostresolver | 2.1.24.nupkg
vs.redist.common.netcore.hostfxr.x64.2.1 | 2.1.24-servicing-29518-02.nupkg
vs.redist.common.netcore.hostfxr.x86.2.1 | 2.1.24-servicing-29518-02.nupkg
vs.redist.common.netcore.sharedframework.x64.2.1 | 2.1.24-servicing-29518-02.nupkg
vs.redist.common.netcore.sharedframework.x86.2.1 | 2.1.24-servicing-29518-02.nupkg
vs.redist.common.netcore.sharedhost.x64.2.1 | 2.1.24-servicing-29518-02.nupkg
vs.redist.common.netcore.sharedhost.x86.2.1 | 2.1.24-servicing-29518-02.nupkg


[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/2.1/2.1.24/2.1.24.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.24-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.24-sha.txt

[linux-install]: https://docs.microsoft.com/dotnet/core/install/linux
[linux-setup]: https://docs.microsoft.com/dotnet/core/install/
[dotnet-blog]: https://devblogs.microsoft.com/dotnet/net-january-2021/


[//]: # ( Runtime 2.1.24)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e4b1196b-46a7-48c7-81d3-24ac8e385c74/ecf03a67221e8aba56dfb5702faad8a9/dotnet-runtime-2.1.24-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3039e7d2-6067-4b11-a7f6-43a3326f84e5/b7e309aa3566ff6e30935883550a382e/dotnet-runtime-2.1.24-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/269518d9-f768-4df7-9db5-83a222a9de1a/3abcc8d987795bae303879a4d50fbba9/dotnet-runtime-2.1.24-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e12e29fe-d4ca-4be6-9d24-69648c16e47e/1cf6bdba50135a72f64ef9dc34dfa784/dotnet-runtime-2.1.24-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/0a7ee9b5-d616-497b-8023-580dc3f2243e/1ae50f7853f4ba13832382443703f829/dotnet-runtime-2.1.24-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ae21eaaf-b1b5-45cd-b4d3-6a29bf050d2b/d6b31314b8ca1121f18eaa9b891cf32a/dotnet-runtime-2.1.24-osx-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/a79ff108-b4d4-4447-866e-9230bbddce8a/bd08d5bd41e37a452d317b39da107379/dotnet-runtime-2.1.24-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/d45e9c83-d873-4b27-991d-1989eb3a9c1e/ec407bf9ed35086f150e4c6f3f635e8c/dotnet-runtime-2.1.24-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/99750379-efda-483b-a7bf-16a7b137ba2c/6d5a6ec1bbe00168b5985acd808340db/dotnet-runtime-2.1.24-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/86f3ea65-9202-461f-9309-94c7bc1f5b28/233908f5f84f797b165dfe82518b526e/dotnet-runtime-2.1.24-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/7a37b19d-e9f3-4662-bea8-207d9c97137d/b4fa378fa374b25fb90593394d88dfeb/dotnet-runtime-2.1.24-win-x86.zip

[//]: # ( ASP 2.1.24)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/89b79b5c-5f07-4512-aa77-cebf1d98c35a/e968517ab3cbfc534c54879d1e40b30b/aspnetcore-runtime-2.1.24-linux-arm.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7615dd36-1115-4e1d-b11d-660db67caf96/8805cfd64c43e10f25aad180d4a7e9c0/aspnetcore-runtime-2.1.24-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e91b0359-e19a-4d8d-9034-135312eec3e6/65ffbc85a45cbbd355c033b52bf4234d/aspnetcore-runtime-2.1.24-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/af6af59d-d095-4d1f-94df-4ee926f421b6/c02dc4ebd5b61e019930f7b9611fa404/aspnetcore-runtime-2.1.24-osx-x64.tar.gz
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/15f1576e-121c-445b-a0a5-a3d4f22152c9/0787378e0935f4c974427b030ca5cdb3/aspnetcore-runtime-2.1.24-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/f0a00928-8d33-4da6-b5e0-be6ba7b912b4/9a3dc895d91658b6ace42bfcdbfe452a/aspnetcore-runtime-2.1.24-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/95268e55-d4a8-4174-a0fc-f08b7b513570/5294331da591c8fe886b864f4cb15bab/aspnetcore-runtime-2.1.24-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/36f5e029-6914-4dd8-88ab-dbf08249f3f4/79b402b37172df992c8fcc2ee29ceb4e/aspnetcore-runtime-2.1.24-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/f55c59eb-1488-4b29-bd3c-c07e0e1db3fc/5205b2f088e6af60bae5620b1a7ee112/dotnet-hosting-2.1.24-win.exe

[//]: # ( SDK 2.1.520 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bb546251-b359-4006-acf2-14ec60322859/e52db47b5bc09b868115a429e68e9430/dotnet-sdk-2.1.520-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bbaddce7-00e8-421e-b24c-6b1a7c0e2cc0/079f85f7a16390d529c5237fdc586c2e/dotnet-sdk-2.1.520-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c8379b03-67ba-4354-a1cd-944d742e2145/14a55302efc0068ce518db24dea96b37/dotnet-sdk-2.1.520-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/58f33c81-bb67-4702-bd96-fcd8774e4bf2/db36e55f8d9fd51c3e33b82dc2903a4b/dotnet-sdk-2.1.520-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/ef83ee74-16f9-4e39-97c9-07fdbe243adf/b9fac726eec971defc782400ccfd5e33/dotnet-sdk-2.1.520-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7adfaa3d-1aed-4163-9de6-0a0099a8b0a5/145f6a30718e8d38deae5002af19aa02/dotnet-sdk-2.1.520-osx-x64.tar.gz
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/f519b394-990e-4b86-a252-27a76c69248d/41c2c92d915885bbfe62c0bcce9c5c6d/dotnet-sdk-2.1.520-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/b8cc63ed-19b3-4bfe-89f8-9744a5861d17/fe3b081debb00fc91ef867e04987bde7/dotnet-sdk-2.1.520-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/b7f0ae7f-d5ca-4fb4-98b3-8fe995504ee5/e8977000f2c78a7ff7970d3853f3a077/dotnet-sdk-2.1.520-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/29916833-9512-4961-bde5-7c0bb42cd5fa/f501e394ed2a7850f2d78129fd883ee0/dotnet-sdk-2.1.520-win-x86.zip
