# .NET Core 2.1.9 Update - March 12, 2019

.NET Core 2.1.9 is available for [download](2.1.9-download.md) and usage in your environment. This release includes .NET Core 2.1.9, ASP.NET Core 2.1.9 and .NET Core SDK 2.1.505.

* [Blog Post][dotnet-blog]
* [Downloads](#downloads)
* [Changes in this release](#changes-in-219)
* [.NET Core Lifecycle News](#net-core-lifecycle-news)
* [Known Issues](../2.1-known-issues.md)

We've created an issue at [dotnet/core #2432](https://github.com/dotnet/core/issues/2432) for your questions and comments.

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] <br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup>
| Linux     | [See installations steps below][linux-install]   | [x64][dotnet-sdk-linux-x64.tar.gz] \| [ARM][dotnet-sdk-linux-arm.tar.gz] \| [ARM64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [ARM][dotnet-runtime-linux-arm.tar.gz] \| [ARM64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [ARM32][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz]<sup>1</sup> |
| RHEL6     | -                                                | [x64][dotnet-sdk-rhel.6-x64.tar.gz]                    | -                                                        | [x64][dotnet-runtime-rhel.6-x64.tar.gz] | - |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - |
| Symbols   | [CLI][cli-symbols.zip] \| [SDK][dotnet-sdk-symbols.zip]  | -                                        | [Runtime][coreclr-symbols.zip] \| [Shared Framework][corefx-symbols.zip] \| [Setup][core-setup-symbols.zip] | - | [ASP.NET Core][aspnet-symbols.zip] |

1. Includes the .NET Core and ASP.NET Core Runtimes
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.

### Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://blogs.msdn.microsoft.com/dotnet/2018/06/18/staying-up-to-date-with-net-container-images/).

The following repos have been updated

* [microsoft/dotnet](https://hub.docker.com/r/microsoft/dotnet)
* [microsoft/dotnet-samples](https://hub.docker.com/r/microsoft/dotnet-samples)

### Azure AppServices

* .NET Core 2.1.9 is being deployed to Azure App Services and the deployment is expected to complete in a couple of days.

## .NET Core Lifecycle News

There are no changes this month in OS version support status.

.NET Core 1.0 and 1.1, which entered "Maintenance" support status when 2.1 was declared LTS, will be end-of-life June 27, 2019. Updates for the 1.0 and 1.1 channels will no longer be offered after that date. See [.NET Core Support Policy](https://dotnet.microsoft.com/platform/support/policy/dotnet-core) to learn more about the .NET Core support lifecycle.

See [.NET Core Supported OS Lifecycle Policy](https://github.com/dotnet/core/blob/main/os-lifecycle-policy.md) to learn about Windows, macOS and Linux versions that are supported for each .NET Core release.

## Changes in 2.1.9
.NET Core 2.1.9 release carries both security and non-security fixes.

* [CVE-2019-0757: .NET Core NuGet Tampering Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2019-0757)

    A tampering vulnerability exists in NuGet software when executed in a Linux or Mac environment. An attacker who successfully exploited the vulnerability could run arbitrary code in the context of the current user. If the current user is logged on with administrative user rights, an attacker could take control of the affected system. An attacker could then install programs; view, change, or delete data; or create new accounts with full user rights. Users whose accounts are configured to have fewer user rights on the system could be less impacted than users who operate with administrative user rights. Exploitation of the vulnerability requires that an attacker can login as any other user on that machine. At that point, the attacker will be able to replace or add to files that were created by a NuGet restore operation in the current users account.

    The security update addresses the vulnerability by correcting how NuGet restore creates file permissions for all files extracted to the client machine.

    **Affected Package and Binary updates**

    Package name | Vulnerable versions | Secure versions
    ------------ | ------------------- | -------------------------
    Nuget.Packaging | 4.9.0 – 4.9.3 | 4.9.4

### Additional fixes in this release

* [CoreCLR](https://github.com/dotnet/coreclr/issues?utf8=%E2%9C%93&q=milestone%3A2.1.9+label%3Aservicing-approved)
* [CoreFX](https://github.com/dotnet/corefx/issues?utf8=%E2%9C%93&q=milestone%3A2.1.9+label%3Aservicing-approved)
* [ASP.NETCore](https://github.com/aspnet/AspNetCore/issues?utf8=%E2%9C%93&q=milestone%3A2.1.9+label%3Aservicing-approved)

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.AspNetCore.All | 2.1.9
Microsoft.AspNetCore.App | 2.1.9
Microsoft.NETCore.App | 2.1.9
Microsoft.NETCore.DotNetAppHost | 2.1.9
Microsoft.NETCore.DotNetHost | 2.1.9
Microsoft.NETCore.DotNetHostPolicy | 2.1.9
Microsoft.NETCore.DotNetHostResolver | 2.1.9
Microsoft.NETCore.Platforms | 2.1.3
runtime.linux-arm.Microsoft.NETCore.App | 2.1.9
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 2.1.9
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 2.1.9
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 2.1.9
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 2.1.9
runtime.linux-arm64.Microsoft.NETCore.App | 2.1.9
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 2.1.9
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 2.1.9
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 2.1.9
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 2.1.9
runtime.linux-musl-x64.Microsoft.NETCore.App | 2.1.9
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 2.1.9
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 2.1.9
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 2.1.9
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 2.1.9
runtime.linux-x64.Microsoft.NETCore.App | 2.1.9
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 2.1.9
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 2.1.9
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 2.1.9
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 2.1.9
runtime.osx-x64.Microsoft.NETCore.App | 2.1.9
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 2.1.9
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 2.1.9
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 2.1.9
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 2.1.9
runtime.rhel.6-x64.Microsoft.NETCore.App | 2.1.9
runtime.rhel.6-x64.Microsoft.NETCore.DotNetAppHost | 2.1.9
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHost | 2.1.9
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHostPolicy | 2.1.9
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHostResolver | 2.1.9
runtime.win-arm.Microsoft.NETCore.App | 2.1.9
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 2.1.9
runtime.win-arm.Microsoft.NETCore.DotNetHost | 2.1.9
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 2.1.9
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 2.1.9
runtime.win-arm64.Microsoft.NETCore.App | 2.1.9
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 2.1.9
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 2.1.9
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 2.1.9
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 2.1.9
runtime.win-x64.Microsoft.NETCore.App | 2.1.9
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 2.1.9
runtime.win-x64.Microsoft.NETCore.DotNetHost | 2.1.9
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 2.1.9
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 2.1.9
runtime.win-x86.Microsoft.NETCore.App | 2.1.9
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 2.1.9
runtime.win-x86.Microsoft.NETCore.DotNetHost | 2.1.9
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 2.1.9
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 2.1.9
System.Security.Cryptography.OpenSsl | 4.5.1

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/2.1/2.1.9/2.1.9.md

[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/585a519e-290a-4a97-b1d4-b9f6035386ca/ef6fb61a6665e035f4ac085aa4c35d8f/dotnet-runtime-2.1.9-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/640f0f10-7502-4edf-8fb1-84966cbf5d1c/88e3305fb2c6406c88b41423b7b8a030/dotnet-runtime-2.1.9-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/dc9f9d1c-e12e-4818-841c-915e70cc4b7b/414d3bad206d760d8f53e5dcb9d6a8dd/dotnet-runtime-2.1.9-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c97de534-1959-4eba-a7fe-bb86b3bb5bf0/fb39bc9e2ac40cb2268e6fe509cbcecd/dotnet-runtime-2.1.9-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/09800006-f18c-4309-857f-80cda7624e73/6344157ba2959799ffd00fdcbafde52f/dotnet-runtime-2.1.9-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bf82df84-2804-4167-bf56-2e6df384d9eb/6524415a78e97105fb08a2ec8c48ac23/dotnet-runtime-2.1.9-osx-x64.tar.gz
[dotnet-runtime-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3ce2571d-f718-423c-b732-1970b389924a/57e7f93e78bb0b09afedf8b511026d51/dotnet-runtime-2.1.9-rhel.6-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/96486292-a6a1-4efd-b3ea-f42a07ccfa84/d3548d86c1526fc6624206c153475c9c/dotnet-runtime-2.1.9-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/b9cefae4-7f05-4dea-9fb0-3328aaddb2ee/545e5c4e0eeff6366523209935376002/dotnet-runtime-2.1.9-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/dd326e41-9407-44e0-823d-e34121e9ae84/1d7668e882d0a050a8e3d0abae4fd6c8/dotnet-runtime-2.1.9-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/beb607a3-c6a1-465a-b19a-5c6628dee015/5df8829b74fc83464768f0d25b524c45/dotnet-runtime-2.1.9-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/55046aa9-d551-4053-944c-df8d69bf87e5/cc2f270aec7f0b8ecfe55a42c2878983/dotnet-runtime-2.1.9-win-x86.zip
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0c75c339-5301-4d4b-bd6b-d21ef6f3b9f0/eb8645704325a74b667fe67c392d9a48/aspnetcore-runtime-2.1.9-linux-arm.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8b3aa0b1-17b5-4111-9513-24e7d6027b65/dca7180dcb96cc1741b5d5ec3d7d13cd/aspnetcore-runtime-2.1.9-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c5075a91-1ae1-45f8-98ac-412b01697336/7c08df006985d6e631e5cf4de6811085/aspnetcore-runtime-2.1.9-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1372654f-9717-458a-8255-1b0d5bf94956/187fbaf0ab71566b57648813853da792/aspnetcore-runtime-2.1.9-osx-x64.tar.gz
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/ece6ec5c-4bdb-494b-994b-3ece386e404a/436e42bf7c68b8455953d2d3285c27ed/aspnetcore-runtime-2.1.9-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/7f26cd30-50b7-4865-a884-d11431179378/d2b52d021743d8724a97beaef31b2660/aspnetcore-runtime-2.1.9-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/7b1102b4-7c50-46ec-9c89-3c7e5aa10b46/12295b419d7b6a528b4b013acfb4ee12/aspnetcore-runtime-2.1.9-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/35f531bf-d121-4cdb-8aa5-b26846da1bb2/b396d568ff11f3ef442064a047645b80/aspnetcore-runtime-2.1.9-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/dc431217-1692-4db1-9e8b-3512c9788292/3070b595006fadcac1ce3b02aff5fadf/dotnet-hosting-2.1.9-win.exe
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a9964eeb-0091-44a4-9a47-fe01fd311bb2/c61cde7decba73c1978c8929a7161f54/dotnet-sdk-2.1.505-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3b475697-be21-4658-8834-11ada70f8c34/c4b9883bb7f3b7c5f0493e5996d3a447/dotnet-sdk-2.1.505-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/93becd35-f6ed-4849-b267-01346ae00195/b095b20b022b789646355c898d40fb38/dotnet-sdk-2.1.505-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/17fcc97d-d9b7-4bef-9ab5-46ba26cf9959/d044cf5547b58920ddbdc068ea64197d/dotnet-sdk-2.1.505-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/7908138c-c0cf-4e5a-b28a-66cf7a781808/a36fe63192ee49593890d84b23729292/dotnet-sdk-2.1.505-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fdf07007-e35d-4060-b2f6-c2ed50011d58/edabf22af2d1278d3b1673c266c95624/dotnet-sdk-2.1.505-osx-x64.tar.gz
[dotnet-sdk-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/801a262b-b2ea-468c-8fa2-3a19874bd17c/d63c16f1bb2402055fa9d4e86c9d5adc/dotnet-sdk-2.1.505-rhel.6-x64.tar.gz
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/4690d405-11c6-488e-b1ba-4f2e9b247b25/7c70d9003e02997b66d843ec54ba53d1/dotnet-sdk-2.1.505-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/3efb0407-7ea4-4fb2-9b95-b5e800ed4ecd/1f561858fbc8a4e38abb5f36055885b3/dotnet-sdk-2.1.505-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/ad308a66-16e5-4d72-aa0a-0174c4d3621e/617718b26b29f4e4df0096800c72b9b3/dotnet-sdk-2.1.505-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/893ed75e-63f8-4b9e-ba9a-bcc38f442bcb/2ab35d2c2ed9cc93a3c3fa2cdfc483ae/dotnet-sdk-2.1.505-win-x86.zip
[aspnet-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/255fda66-df42-4426-ba6e-d4f861af7c5c/688b6ff952dea68557368096ed6ff512/aspnet-2.1.9-symbols.zip
[cli-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/d0fdd452-5905-4b2a-a75c-bc3bed1064b8/dbf9eda4f8bbc68eb53f9c91dadf7042/cli-2.1.9-symbols.zip
[core-setup-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/d1d932c5-355d-4ce6-ba8c-3a019d6dcb04/3718bdbe0ef20017a807b321d7a594ea/core-setup-2.1.9-symbols.zip
[coreclr-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/537b9e61-b039-4268-b91d-1a5376933e1a/feeb7fbd92e3905637b4b6e89f2b5772/coreclr-2.1.9-symbols.zip
[corefx-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/77b1b665-a636-4452-bfcb-c9e533b96cfa/0817fd592a898906def3787deec302d9/corefx-2.1.9-symbols.zip
[dotnet-sdk-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/4c75b8b4-c2f0-4b2d-8646-7a9815f1efea/44945b5d239d3163a1d6fc202ff851ac/dotnet-sdk-2.1.9-symbols.zip

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.9-runtime-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.505-sdk-sha.txt

[linux-install]: https://docs.microsoft.com/dotnet/core/install/linux

[dotnet-blog]: https://devblogs.microsoft.com/dotnet/net-core-march-2019/
