# .NET Core 2.1 Preview 2 - April 10, 2018

.NET Core 2.1.0 Preview 2 is available for download and usage in your environment. Have a look at the [Known Issues](2.1.0-preview2-known-issues.md) document as there are a few things to be aware of before installing.

* [Downloads](https://dotnet.microsoft.com/download)

## Blog Round up

* [.NET Core](https://blogs.msdn.microsoft.com/dotnet/2018/04/11/announcing-net-core-2-1-preview-2/)
* [ASP .NET Core](https://blogs.msdn.microsoft.com/webdev/)
* [Entity Framework Core](https://blogs.msdn.microsoft.com/dotnet/2018/04/11/announcing-entity-framework-core-2-1-preview-2/)

The .NET Core SDK 2.1 Preview includes .NET Core 2.1 Runtime Preview so downloading the runtime packages separately is not needed when installing the SDK. After installing the .NET Core SDK 2.1 Preview, the following command will show that you're running version `2.1.300-preview2-008530` of the tools.

`dotnet --version`

Your feedback is important and appreciated. We've created an issue at [dotnet/core #1422](https://github.com/dotnet/core/issues/1422) for your questions and comments.

## Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Look for the 2.1 Preview 2 images.

## Azure AppServices

Details for running .NET Core 2.1 Preview 1 in Azure App Services can be seen in the [ASP.NET Core blog post](https://blogs.msdn.microsoft.com/webdev/2018/02/27/asp-net-core-2-1-0-preview1-using-asp-net-core-previews-on-azure-app-service/).

## Notable Changes in Preview 2

## NETStandard.Library 2.0.2 released

[Issue #442](https://github.com/dotnet/standard/issues/442) : Adding .NET Standard/.NET Framework facades assemblies is consuming 11% of build time - fixed in [#510](https://github.com/dotnet/standard/pull/510)

### Breaking API changes

Many APIs received updates from Preview 1 which are considered breaking changes. Below are a few notable changes and a [detailed API diff](https://github.com/dotnet/core/tree/main/release-notes/2.1/Preview/api-diff/preview2) is available to help determine if any will impact existing projects build on 2.1.0 Preview 1.

| Area | Description | Details | Github Issue |
| ---- | ----------- | ------- | ------------ |
| System.Memory | Changed System.Buffers.OwnedMemory to MemoryManager and added an IMemoryOwner | This is a breaking change to System.Memory lifetime management APIs, to reduce pit-of-failure use-after-free security issues. We have produced guidance clarifying Memory<T> lifetime semantics and how APIs which accept Memory<T> should behave (see the links to the gist). OwnedMemory<T> is split into two types: IMemoryOwner<T> and MemoryManager<T>. Each type has a single responsibility. This makes it easier and safer for developers to change the lifetime semantics of Memory<T> instances without requiring them to drop down to unsafe code. <br><br> See the following for more details on guidance and usage: <br><br> [Memory<T> API documentation and samples](https://gist.github.com/GrabYourPitchforks/8efb15abbd90bc5b128f64981766e834) <br> [Memory<T> usage guidelines](https://gist.github.com/GrabYourPitchforks/4c3e1935fd4d9fa2831dbfcab35dffc6) | |
| System.Memory | Moved MemoryExtensions.AsBytes and System.Buffers.Binary.BinaryPrimitives.{Try}ReadMachineEndian & {Try}WriteMachineEndian to System.Runtime.InteropServices.MemoryMarshal. Also moved TryGetString and TryGetArray | These APIs are unsafe as they allow skipping visible checks and can result in unexpected behaviors. Therefore, these APIs were moved to MemoryMarshal since the developer has to be careful when using them. TryGetString and TryGetArray were also moved since they violate the window of visibility of Memory<T>. | [corefx/27094](https://github.com/dotnet/corefx/issues/27094)<br>[corefx/27451](https://github.com/dotnet/corefx/issues/27451) |
| System.Memory | Rename MemoryExtensions.AsReadOnlyMemory & AsReadOnlySpan to AsMemory & AsSpan | | [corefx/26894](https://github.com/dotnet/corefx/issues/26894) |

### System.Security

| Area | Description | Details |
| ---- | ----------- | ------- |
| System.Security | Added CryptographicOperations class | CryptographicOperations.FixedTimeEquals takes a fixed amount of time to return for any two inputs of the same length, making it suitable for use in cryptographic verification to avoid contributing to timing side-channel information.  CryptographicOperations.ZeroMemory is a memory clearing routine which cannot be optimized away via a write-without-subsequent-read optimization. |
| System.Security | Added static RandomNumberGenerator.Fill | The static RandomNumberGenerator.Fill will fill a Span with random values using the system-preferred CSPRNG, and does not require the caller to manage the lifetime of an IDisposable resource. |
| System.Security | Added support for RFC 3161 cryptographic timestamps | New API to request, read, validate, and create TimestampToken values as defined by RFC 3161. |
| System.Security | Unix EnvelopedCms | The EnvelopedCms class is now available on Linux and macOS. |
| System.Security | Added ECDiffieHellman | Elliptic-Curve Diffie-Hellman (ECDH) is now available on .NET Core via the ECDiffieHellman class family with the same surface area as .NET Framework 4.7. |
| System.Security | Added RSA-OAEP-SHA2 and RSA-PSS to Unix platforms | Starting with this release the instance provided by RSA.Create() on .NET Core can always encrypt or decrypt with OAEP using a SHA-2 digest, as well as generate or validate signatures using RSA-PSS. |

### Global Tools

Global tools let you install a tool from a NuGet feed into your local path. This makes in available in a similar manner to npm -g.

**dotnet --list-sdks**

`dotnet --list-sdks` provides a list of .NET Core SDKs installed on the machine

Many .NET Core SDKs may be installed on a given machine. The new `--list-sdks` switch lists installed SDKs along with the base path where they are installed. This new switch is present in the .NET Core host, which has a single copy on the machine. Thus, this switch works once the preview is installed, regardless of global.json or if the preview is uninstalled.

**dotnet --list-runtimes**

`dotnet --list-runtimes` provides a list of .NET Core Runtimes installed on the machine

Many .NET Core Runtimes may be installed on a given machine. The new `--list-runtimes` switch lists installed runtimes along with the base path where they are installed. This new switch is present in the .NET Core host, which has a single copy on the machine. Thus, this switch works once the preview is installed, regardless of global.json or if the preview is uninstalled.
