# System.Buffers

``` diff
 namespace System.Buffers {
+    public static class BuffersExtensions {
+        public static void CopyTo<T>(this in ReadOnlySequence<T> source, Span<T> destination);
+        public static Nullable<SequencePosition> PositionOf<T>(this in ReadOnlySequence<T> source, T value) where T : IEquatable<T>;
+        public static T[] ToArray<T>(this in ReadOnlySequence<T> sequence);
+        public static void Write<T>(this IBufferWriter<T> writer, ReadOnlySpan<T> value);
+    }
+    public interface IBufferWriter<T> {
+        void Advance(int count);
+        Memory<T> GetMemory(int sizeHint = 0);
+        Span<T> GetSpan(int sizeHint = 0);
+    }
+    public interface IMemoryOwner<T> : IDisposable {
+        Memory<T> Memory { get; }
+    }
+    public interface IPinnable {
+        MemoryHandle Pin(int elementIndex);
+        void Unpin();
+    }
+    public struct MemoryHandle : IDisposable {
+        public unsafe MemoryHandle(void* pointer, GCHandle handle = default(GCHandle), IPinnable pinnable = null);
+        public unsafe void* Pointer { get; }
+        public void Dispose();
+    }
+    public abstract class MemoryManager<T> : IDisposable, IMemoryOwner<T>, IPinnable {
+        protected MemoryManager();
+        public virtual Memory<T> Memory { get; }
+        protected Memory<T> CreateMemory(int length);
+        protected Memory<T> CreateMemory(int start, int length);
+        protected abstract void Dispose(bool disposing);
+        public abstract Span<T> GetSpan();
+        public abstract MemoryHandle Pin(int elementIndex = 0);
+        void System.IDisposable.Dispose();
+        protected internal virtual bool TryGetArray(out ArraySegment<T> segment);
+        public abstract void Unpin();
+    }
+    public abstract class MemoryPool<T> : IDisposable {
+        protected MemoryPool();
+        public abstract int MaxBufferSize { get; }
+        public static MemoryPool<T> Shared { get; }
+        public void Dispose();
+        protected abstract void Dispose(bool disposing);
+        public abstract IMemoryOwner<T> Rent(int minBufferSize = -1);
+    }
+    public enum OperationStatus {
+        DestinationTooSmall = 1,
+        Done = 0,
+        InvalidData = 3,
+        NeedMoreData = 2,
+    }
+    public readonly struct ReadOnlySequence<T> {
+        public static readonly ReadOnlySequence<T> Empty;
+        public ReadOnlySequence(ReadOnlySequenceSegment<T> startSegment, int startIndex, ReadOnlySequenceSegment<T> endSegment, int endIndex);
+        public ReadOnlySequence(ReadOnlyMemory<T> memory);
+        public ReadOnlySequence(T[] array);
+        public ReadOnlySequence(T[] array, int start, int length);
+        public SequencePosition End { get; }
+        public ReadOnlyMemory<T> First { get; }
+        public bool IsEmpty { get; }
+        public bool IsSingleSegment { get; }
+        public long Length { get; }
+        public SequencePosition Start { get; }
+        public ReadOnlySequence<T>.Enumerator GetEnumerator();
+        public SequencePosition GetPosition(long offset);
+        public SequencePosition GetPosition(long offset, SequencePosition origin);
+        public ReadOnlySequence<T> Slice(int start, int length);
+        public ReadOnlySequence<T> Slice(int start, SequencePosition end);
+        public ReadOnlySequence<T> Slice(long start);
+        public ReadOnlySequence<T> Slice(long start, long length);
+        public ReadOnlySequence<T> Slice(long start, SequencePosition end);
+        public ReadOnlySequence<T> Slice(SequencePosition start);
+        public ReadOnlySequence<T> Slice(SequencePosition start, int length);
+        public ReadOnlySequence<T> Slice(SequencePosition start, long length);
+        public ReadOnlySequence<T> Slice(SequencePosition start, SequencePosition end);
+        public override string ToString();
+        public bool TryGet(ref SequencePosition position, out ReadOnlyMemory<T> memory, bool advance = true);
+        public struct Enumerator {
+            public Enumerator(in ReadOnlySequence<T> sequence);
+            public ReadOnlyMemory<T> Current { get; }
+            public bool MoveNext();
+        }
+    }
+    public abstract class ReadOnlySequenceSegment<T> {
+        protected ReadOnlySequenceSegment();
+        public ReadOnlyMemory<T> Memory { get; protected set; }
+        public ReadOnlySequenceSegment<T> Next { get; protected set; }
+        public long RunningIndex { get; protected set; }
+    }
+    public delegate void ReadOnlySpanAction<T, in TArg>(ReadOnlySpan<T> span, TArg arg);
+    public delegate void SpanAction<T, in TArg>(Span<T> span, TArg arg);
+    public readonly struct StandardFormat : IEquatable<StandardFormat> {
+        public const byte MaxPrecision = (byte)99;
+        public const byte NoPrecision = (byte)255;
+        public StandardFormat(char symbol, byte precision = (byte)255);
+        public bool HasPrecision { get; }
+        public bool IsDefault { get; }
+        public byte Precision { get; }
+        public char Symbol { get; }
+        public bool Equals(StandardFormat other);
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public static bool operator ==(StandardFormat left, StandardFormat right);
+        public static implicit operator StandardFormat (char symbol);
+        public static bool operator !=(StandardFormat left, StandardFormat right);
+        public static StandardFormat Parse(ReadOnlySpan<char> format);
+        public static StandardFormat Parse(string format);
+        public override string ToString();
+    }
 }
```

