# System

``` diff
 namespace System {
     public static class Activator {
+        public static ObjectHandle CreateInstance(string assemblyName, string typeName);
+        public static ObjectHandle CreateInstance(string assemblyName, string typeName, bool ignoreCase, BindingFlags bindingAttr, Binder binder, object[] args, CultureInfo culture, object[] activationAttributes);
+        public static ObjectHandle CreateInstance(string assemblyName, string typeName, object[] activationAttributes);
+        public static ObjectHandle CreateInstanceFrom(string assemblyFile, string typeName);
+        public static ObjectHandle CreateInstanceFrom(string assemblyFile, string typeName, bool ignoreCase, BindingFlags bindingAttr, Binder binder, object[] args, CultureInfo culture, object[] activationAttributes);
+        public static ObjectHandle CreateInstanceFrom(string assemblyFile, string typeName, object[] activationAttributes);
     }
-    public class AppDomain : MarshalByRefObject {
+    public sealed class AppDomain : MarshalByRefObject {
+        public PermissionSet PermissionSet { get; }
+        public AppDomainSetup SetupInformation { get; }
+        public ObjectHandle CreateInstance(string assemblyName, string typeName);
+        public ObjectHandle CreateInstance(string assemblyName, string typeName, bool ignoreCase, BindingFlags bindingAttr, Binder binder, object[] args, CultureInfo culture, object[] activationAttributes);
+        public ObjectHandle CreateInstance(string assemblyName, string typeName, object[] activationAttributes);
+        public object CreateInstanceAndUnwrap(string assemblyName, string typeName);
+        public object CreateInstanceAndUnwrap(string assemblyName, string typeName, bool ignoreCase, BindingFlags bindingAttr, Binder binder, object[] args, CultureInfo culture, object[] activationAttributes);
+        public object CreateInstanceAndUnwrap(string assemblyName, string typeName, object[] activationAttributes);
+        public ObjectHandle CreateInstanceFrom(string assemblyFile, string typeName);
+        public ObjectHandle CreateInstanceFrom(string assemblyFile, string typeName, bool ignoreCase, BindingFlags bindingAttr, Binder binder, object[] args, CultureInfo culture, object[] activationAttributes);
+        public ObjectHandle CreateInstanceFrom(string assemblyFile, string typeName, object[] activationAttributes);
+        public object CreateInstanceFromAndUnwrap(string assemblyFile, string typeName);
+        public object CreateInstanceFromAndUnwrap(string assemblyFile, string typeName, bool ignoreCase, BindingFlags bindingAttr, Binder binder, object[] args, CultureInfo culture, object[] activationAttributes);
+        public object CreateInstanceFromAndUnwrap(string assemblyFile, string typeName, object[] activationAttributes);
     }
+    public sealed class AppDomainSetup {
+        public string ApplicationBase { get; }
+        public string TargetFrameworkName { get; }
+    }
+    public ref struct ArgIterator {
+        public ArgIterator(RuntimeArgumentHandle arglist);
+        public unsafe ArgIterator(RuntimeArgumentHandle arglist, void* ptr);
+        public void End();
+        public override bool Equals(object o);
+        public override int GetHashCode();
+        public TypedReference GetNextArg();
+        public TypedReference GetNextArg(RuntimeTypeHandle rth);
+        public RuntimeTypeHandle GetNextArgType();
+        public int GetRemainingCount();
+    }
-    public struct Boolean : IComparable, IComparable<bool>, IConvertible, IEquatable<bool>
+    public readonly struct Boolean : IComparable, IComparable<bool>, IConvertible, IEquatable<bool>
-    public struct Byte : IComparable, IComparable<byte>, IConvertible, IEquatable<byte>, IFormattable
+    public readonly struct Byte : IComparable, IComparable<byte>, IConvertible, IEquatable<byte>, IFormattable
-    public struct Char : IComparable, IComparable<char>, IConvertible, IEquatable<char>
+    public readonly struct Char : IComparable, IComparable<char>, IConvertible, IEquatable<char>
-    public struct DateTimeOffset : IComparable, IComparable<DateTimeOffset>, IDeserializationCallback, IEquatable<DateTimeOffset>, IFormattable, ISerializable
+    public readonly struct DateTimeOffset : IComparable, IComparable<DateTimeOffset>, IDeserializationCallback, IEquatable<DateTimeOffset>, IFormattable, ISerializable
-    public struct Decimal : IComparable, IComparable<decimal>, IConvertible, IDeserializationCallback, IEquatable<decimal>, IFormattable
+    public readonly struct Decimal : IComparable, IComparable<decimal>, IConvertible, IDeserializationCallback, IEquatable<decimal>, IFormattable
-    public struct Double : IComparable, IComparable<double>, IConvertible, IEquatable<double>, IFormattable
+    public readonly struct Double : IComparable, IComparable<double>, IConvertible, IEquatable<double>, IFormattable
     public static class Environment {
+        public static long TickCount64 { get; }
     }
     public class Exception : ISerializable {
-        public int HResult { get; protected set; }
+        public int HResult { get; set; }
     }
     public abstract class FormattableString : IFormattable {
+        public static string CurrentCulture(FormattableString formattable);
     }
     public static class GC {
+        public static GCMemoryInfo GetGCMemoryInfo();
+        public static long GetTotalAllocatedBytes(bool precise = false);
     }
+    public readonly struct GCMemoryInfo {
+        public long FragmentedBytes { get; }
+        public long HeapSizeBytes { get; }
+        public long HighMemoryLoadThresholdBytes { get; }
+        public long MemoryLoadBytes { get; }
+        public long TotalAvailableMemoryBytes { get; }
+    }
+    public interface IAsyncDisposable {
+        ValueTask DisposeAsync();
+    }
+    public readonly struct Index : IEquatable<Index> {
+        public Index(int value, bool fromEnd = false);
+        public static Index End { get; }
+        public bool IsFromEnd { get; }
+        public static Index Start { get; }
+        public int Value { get; }
+        public bool Equals(Index other);
+        public override bool Equals(object value);
+        public static Index FromEnd(int value);
+        public static Index FromStart(int value);
+        public override int GetHashCode();
+        public int GetOffset(int length);
+        public static implicit operator Index (int value);
+        public override string ToString();
+    }
-    public struct Int16 : IComparable, IComparable<short>, IConvertible, IEquatable<short>, IFormattable
+    public readonly struct Int16 : IComparable, IComparable<short>, IConvertible, IEquatable<short>, IFormattable
-    public struct Int32 : IComparable, IComparable<int>, IConvertible, IEquatable<int>, IFormattable
+    public readonly struct Int32 : IComparable, IComparable<int>, IConvertible, IEquatable<int>, IFormattable
-    public struct Int64 : IComparable, IComparable<long>, IConvertible, IEquatable<long>, IFormattable
+    public readonly struct Int64 : IComparable, IComparable<long>, IConvertible, IEquatable<long>, IFormattable
-    public struct IntPtr : IEquatable<IntPtr>, ISerializable
+    public readonly struct IntPtr : IEquatable<IntPtr>, ISerializable
     public static class Math {
+        public static double BitDecrement(double x);
+        public static double BitIncrement(double x);
+        public static double CopySign(double x, double y);
+        public static double FusedMultiplyAdd(double x, double y, double z);
+        public static int ILogB(double x);
+        public static double Log2(double x);
+        public static double MaxMagnitude(double x, double y);
+        public static double MinMagnitude(double x, double y);
+        public static double ScaleB(double x, int n);
     }
     public static class MathF {
+        public static float BitDecrement(float x);
+        public static float BitIncrement(float x);
+        public static float CopySign(float x, float y);
+        public static float FusedMultiplyAdd(float x, float y, float z);
+        public static int ILogB(float x);
+        public static float Log2(float x);
+        public static float MaxMagnitude(float x, float y);
+        public static float MinMagnitude(float x, float y);
+        public static float ScaleB(float x, int n);
     }
-    public readonly struct Memory<T>
+    public readonly struct Memory<T> : IEquatable<Memory<T>>
     public static class MemoryExtensions {
+        public static ReadOnlyMemory<char> AsMemory(this string text, Index startIndex);
+        public static ReadOnlyMemory<char> AsMemory(this string text, Range range);
+        public static Memory<T> AsMemory<T>(this T[] array, Index startIndex);
+        public static Memory<T> AsMemory<T>(this T[] array, Range range);
+        public static Span<T> AsSpan<T>(this ArraySegment<T> segment, Index startIndex);
+        public static Span<T> AsSpan<T>(this ArraySegment<T> segment, Range range);
+        public static Span<T> AsSpan<T>(this T[] array, Index startIndex);
+        public static Span<T> AsSpan<T>(this T[] array, Range range);
+        public static bool Contains<T>(this ReadOnlySpan<T> span, T value) where T : IEquatable<T>;
+        public static bool Contains<T>(this Span<T> span, T value) where T : IEquatable<T>;
+        public static SpanRuneEnumerator EnumerateRunes(this ReadOnlySpan<char> span);
+        public static SpanRuneEnumerator EnumerateRunes(this Span<char> span);
+        public static int LastIndexOf(this ReadOnlySpan<char> span, ReadOnlySpan<char> value, StringComparison comparisonType);
+        public static Memory<char> Trim(this Memory<char> memory);
+        public static ReadOnlyMemory<char> Trim(this ReadOnlyMemory<char> memory);
+        public static Span<char> Trim(this Span<char> span);
+        public static Memory<T> Trim<T>(this Memory<T> memory, ReadOnlySpan<T> trimElements) where T : IEquatable<T>;
+        public static Memory<T> Trim<T>(this Memory<T> memory, T trimElement) where T : IEquatable<T>;
+        public static ReadOnlyMemory<T> Trim<T>(this ReadOnlyMemory<T> memory, ReadOnlySpan<T> trimElements) where T : IEquatable<T>;
+        public static ReadOnlyMemory<T> Trim<T>(this ReadOnlyMemory<T> memory, T trimElement) where T : IEquatable<T>;
+        public static ReadOnlySpan<T> Trim<T>(this ReadOnlySpan<T> span, ReadOnlySpan<T> trimElements) where T : IEquatable<T>;
+        public static ReadOnlySpan<T> Trim<T>(this ReadOnlySpan<T> span, T trimElement) where T : IEquatable<T>;
+        public static Span<T> Trim<T>(this Span<T> span, ReadOnlySpan<T> trimElements) where T : IEquatable<T>;
+        public static Span<T> Trim<T>(this Span<T> span, T trimElement) where T : IEquatable<T>;
+        public static Memory<char> TrimEnd(this Memory<char> memory);
+        public static ReadOnlyMemory<char> TrimEnd(this ReadOnlyMemory<char> memory);
+        public static Span<char> TrimEnd(this Span<char> span);
+        public static Memory<T> TrimEnd<T>(this Memory<T> memory, ReadOnlySpan<T> trimElements) where T : IEquatable<T>;
+        public static Memory<T> TrimEnd<T>(this Memory<T> memory, T trimElement) where T : IEquatable<T>;
+        public static ReadOnlyMemory<T> TrimEnd<T>(this ReadOnlyMemory<T> memory, ReadOnlySpan<T> trimElements) where T : IEquatable<T>;
+        public static ReadOnlyMemory<T> TrimEnd<T>(this ReadOnlyMemory<T> memory, T trimElement) where T : IEquatable<T>;
+        public static ReadOnlySpan<T> TrimEnd<T>(this ReadOnlySpan<T> span, ReadOnlySpan<T> trimElements) where T : IEquatable<T>;
+        public static ReadOnlySpan<T> TrimEnd<T>(this ReadOnlySpan<T> span, T trimElement) where T : IEquatable<T>;
+        public static Span<T> TrimEnd<T>(this Span<T> span, ReadOnlySpan<T> trimElements) where T : IEquatable<T>;
+        public static Span<T> TrimEnd<T>(this Span<T> span, T trimElement) where T : IEquatable<T>;
+        public static Memory<char> TrimStart(this Memory<char> memory);
+        public static ReadOnlyMemory<char> TrimStart(this ReadOnlyMemory<char> memory);
+        public static Span<char> TrimStart(this Span<char> span);
+        public static Memory<T> TrimStart<T>(this Memory<T> memory, ReadOnlySpan<T> trimElements) where T : IEquatable<T>;
+        public static Memory<T> TrimStart<T>(this Memory<T> memory, T trimElement) where T : IEquatable<T>;
+        public static ReadOnlyMemory<T> TrimStart<T>(this ReadOnlyMemory<T> memory, ReadOnlySpan<T> trimElements) where T : IEquatable<T>;
+        public static ReadOnlyMemory<T> TrimStart<T>(this ReadOnlyMemory<T> memory, T trimElement) where T : IEquatable<T>;
+        public static ReadOnlySpan<T> TrimStart<T>(this ReadOnlySpan<T> span, ReadOnlySpan<T> trimElements) where T : IEquatable<T>;
+        public static ReadOnlySpan<T> TrimStart<T>(this ReadOnlySpan<T> span, T trimElement) where T : IEquatable<T>;
+        public static Span<T> TrimStart<T>(this Span<T> span, ReadOnlySpan<T> trimElements) where T : IEquatable<T>;
+        public static Span<T> TrimStart<T>(this Span<T> span, T trimElement) where T : IEquatable<T>;
     }
     public enum MidpointRounding {
+        ToNegativeInfinity = 3,
+        ToPositiveInfinity = 4,
+        ToZero = 2,
     }
+    public readonly struct Range : IEquatable<Range> {
+        public Range(Index start, Index end);
+        public static Range All { get; }
+        public Index End { get; }
+        public Index Start { get; }
+        public static Range EndAt(Index end);
+        public override bool Equals(object value);
+        public bool Equals(Range other);
+        public override int GetHashCode();
+        public (int Offset, int Length) GetOffsetAndLength(int length);
+        public static Range StartAt(Index start);
+        public override string ToString();
+    }
-    public readonly struct ReadOnlyMemory<T>
+    public readonly struct ReadOnlyMemory<T> : IEquatable<ReadOnlyMemory<T>>
-    public struct SByte : IComparable, IComparable<sbyte>, IConvertible, IEquatable<sbyte>, IFormattable
+    public readonly struct SByte : IComparable, IComparable<sbyte>, IConvertible, IEquatable<sbyte>, IFormattable
-    public struct Single : IComparable, IComparable<float>, IConvertible, IEquatable<float>, IFormattable
+    public readonly struct Single : IComparable, IComparable<float>, IConvertible, IEquatable<float>, IFormattable
     public sealed class String : ICloneable, IComparable, IComparable<string>, IConvertible, IEnumerable, IEnumerable<char>, IEquatable<string> {
+        public static String Concat(ReadOnlySpan<char> str0, ReadOnlySpan<char> str1);
+        public static String Concat(ReadOnlySpan<char> str0, ReadOnlySpan<char> str1, ReadOnlySpan<char> str2);
+        public static String Concat(ReadOnlySpan<char> str0, ReadOnlySpan<char> str1, ReadOnlySpan<char> str2, ReadOnlySpan<char> str3);
+        public StringRuneEnumerator EnumerateRunes();
+        public static int GetHashCode(ReadOnlySpan<char> value);
+        public static int GetHashCode(ReadOnlySpan<char> value, StringComparison comparisonType);
+        public ref readonly char GetPinnableReference();
     }
     public abstract class StringComparer : IComparer, IComparer<string>, IEqualityComparer, IEqualityComparer<string> {
-        bool System.Collections.IEqualityComparer.Equals(object x, object y);

-        int System.Collections.IEqualityComparer.GetHashCode(object obj);

     }
-    public struct TimeSpan : IComparable, IComparable<TimeSpan>, IEquatable<TimeSpan>, IFormattable
+    public readonly struct TimeSpan : IComparable, IComparable<TimeSpan>, IEquatable<TimeSpan>, IFormattable
     public abstract class Type : MemberInfo, IReflect {
+        public static Type MakeGenericSignatureType(Type genericTypeDefinition, params Type[] typeArguments);
     }
-    public struct UInt16 : IComparable, IComparable<ushort>, IConvertible, IEquatable<ushort>, IFormattable
+    public readonly struct UInt16 : IComparable, IComparable<ushort>, IConvertible, IEquatable<ushort>, IFormattable
-    public struct UInt32 : IComparable, IComparable<uint>, IConvertible, IEquatable<uint>, IFormattable
+    public readonly struct UInt32 : IComparable, IComparable<uint>, IConvertible, IEquatable<uint>, IFormattable
-    public struct UInt64 : IComparable, IComparable<ulong>, IConvertible, IEquatable<ulong>, IFormattable
+    public readonly struct UInt64 : IComparable, IComparable<ulong>, IConvertible, IEquatable<ulong>, IFormattable
-    public struct UIntPtr : IEquatable<UIntPtr>, ISerializable
+    public readonly struct UIntPtr : IEquatable<UIntPtr>, ISerializable
 }
```

