# System.Diagnostics

``` diff
 namespace System.Diagnostics {
     public class Activity {
+        public ActivityTraceFlags ActivityTraceFlags { get; set; }
-        public static Activity Current { get; private set; }
+        public static Activity Current { get; set; }
+        public static ActivityIdFormat DefaultIdFormat { get; set; }
+        public static bool ForceDefaultIdFormat { get; set; }
+        public ActivityIdFormat IdFormat { get; private set; }
+        public ActivitySpanId ParentSpanId { get; }
+        public bool Recorded { get; }
+        public ActivitySpanId SpanId { get; }
+        public ActivityTraceId TraceId { get; }
+        public string TraceStateString { get; set; }
+        public Activity SetIdFormat(ActivityIdFormat format);
+        public Activity SetParentId(ActivityTraceId traceId, ActivitySpanId spanId, ActivityTraceFlags activityTraceFlags = ActivityTraceFlags.None);
     }
+    public enum ActivityIdFormat {
+        Hierarchical = 1,
+        Unknown = 0,
+        W3C = 2,
+    }
+    public readonly struct ActivitySpanId : IEquatable<ActivitySpanId> {
+        public void CopyTo(Span<byte> destination);
+        public static ActivitySpanId CreateFromBytes(ReadOnlySpan<byte> idData);
+        public static ActivitySpanId CreateFromString(ReadOnlySpan<char> idData);
+        public static ActivitySpanId CreateFromUtf8String(ReadOnlySpan<byte> idData);
+        public static ActivitySpanId CreateRandom();
+        public bool Equals(ActivitySpanId spanId);
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public static bool operator ==(ActivitySpanId spanId1, ActivitySpanId spandId2);
+        public static bool operator !=(ActivitySpanId spanId1, ActivitySpanId spandId2);
+        public string ToHexString();
+        public override string ToString();
+    }
+    public enum ActivityTraceFlags {
+        None = 0,
+        Recorded = 1,
+    }
+    public readonly struct ActivityTraceId : IEquatable<ActivityTraceId> {
+        public void CopyTo(Span<byte> destination);
+        public static ActivityTraceId CreateFromBytes(ReadOnlySpan<byte> idData);
+        public static ActivityTraceId CreateFromString(ReadOnlySpan<char> idData);
+        public static ActivityTraceId CreateFromUtf8String(ReadOnlySpan<byte> idData);
+        public static ActivityTraceId CreateRandom();
+        public bool Equals(ActivityTraceId traceId);
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public static bool operator ==(ActivityTraceId traceId1, ActivityTraceId traceId2);
+        public static bool operator !=(ActivityTraceId traceId1, ActivityTraceId traceId2);
+        public string ToHexString();
+        public override string ToString();
+    }
     public class DiagnosticListener : DiagnosticSource, IDisposable, IObservable<KeyValuePair<string, object>> {
+        public override void OnActivityExport(Activity activity, object payload);
+        public override void OnActivityImport(Activity activity, object payload);
+        public virtual IDisposable Subscribe(IObserver<KeyValuePair<string, object>> observer, Func<string, object, object, bool> isEnabled, Action<Activity, object> onActivityImport = null, Action<Activity, object> onActivityExport = null);
     }
     public abstract class DiagnosticSource {
+        public virtual void OnActivityExport(Activity activity, object payload);
+        public virtual void OnActivityImport(Activity activity, object payload);
     }
+    public sealed class EventLogTraceListener : TraceListener {
+        public EventLogTraceListener();
+        public EventLogTraceListener(EventLog eventLog);
+        public EventLogTraceListener(string source);
+        public EventLog EventLog { get; set; }
+        public override string Name { get; set; }
+        public override void Close();
+        protected override void Dispose(bool disposing);
+        public override void TraceData(TraceEventCache eventCache, string source, TraceEventType severity, int id, object data);
+        public override void TraceData(TraceEventCache eventCache, string source, TraceEventType severity, int id, params object[] data);
+        public override void TraceEvent(TraceEventCache eventCache, string source, TraceEventType severity, int id, string message);
+        public override void TraceEvent(TraceEventCache eventCache, string source, TraceEventType severity, int id, string format, params object[] args);
+        public override void Write(string message);
+        public override void WriteLine(string message);
+    }
 }
```

