# System.DirectoryServices

``` diff
 namespace System.DirectoryServices {
+    public sealed class DirectoryServicesPermission : ResourcePermissionBase {
+        public DirectoryServicesPermission();
+        public DirectoryServicesPermission(DirectoryServicesPermissionAccess permissionAccess, string path);
+        public DirectoryServicesPermission(DirectoryServicesPermissionEntry[] permissionAccessEntries);
+        public DirectoryServicesPermission(PermissionState state);
+        public DirectoryServicesPermissionEntryCollection PermissionEntries { get; }
+    }
+    public enum DirectoryServicesPermissionAccess {
+        Browse = 2,
+        None = 0,
+        Write = 6,
+    }
+    public class DirectoryServicesPermissionAttribute : CodeAccessSecurityAttribute {
+        public DirectoryServicesPermissionAttribute(SecurityAction action);
+        public string Path { get; set; }
+        public DirectoryServicesPermissionAccess PermissionAccess { get; set; }
+        public override IPermission CreatePermission();
+    }
+    public class DirectoryServicesPermissionEntry {
+        public DirectoryServicesPermissionEntry(DirectoryServicesPermissionAccess permissionAccess, string path);
+        public string Path { get; }
+        public DirectoryServicesPermissionAccess PermissionAccess { get; }
+    }
+    public class DirectoryServicesPermissionEntryCollection : CollectionBase {
+        public DirectoryServicesPermissionEntry this[int index] { get; set; }
+        public int Add(DirectoryServicesPermissionEntry value);
+        public void AddRange(DirectoryServicesPermissionEntryCollection value);
+        public void AddRange(DirectoryServicesPermissionEntry[] value);
+        public bool Contains(DirectoryServicesPermissionEntry value);
+        public void CopyTo(DirectoryServicesPermissionEntry[] array, int index);
+        public int IndexOf(DirectoryServicesPermissionEntry value);
+        public void Insert(int index, DirectoryServicesPermissionEntry value);
+        protected override void OnClear();
+        protected override void OnInsert(int index, object value);
+        protected override void OnRemove(int index, object value);
+        protected override void OnSet(int index, object oldValue, object newValue);
+        public void Remove(DirectoryServicesPermissionEntry value);
+    }
 }
```

