# System.Media

``` diff
+namespace System.Media {
+    public class SoundPlayer : Component, ISerializable {
+        public SoundPlayer();
+        public SoundPlayer(Stream stream);
+        protected SoundPlayer(SerializationInfo serializationInfo, StreamingContext context);
+        public SoundPlayer(string soundLocation);
+        public bool IsLoadCompleted { get; }
+        public int LoadTimeout { get; set; }
+        public string SoundLocation { get; set; }
+        public Stream Stream { get; set; }
+        public object Tag { get; set; }
+        public event AsyncCompletedEventHandler LoadCompleted;
+        public event EventHandler SoundLocationChanged;
+        public event EventHandler StreamChanged;
+        public void Load();
+        public void LoadAsync();
+        protected virtual void OnLoadCompleted(AsyncCompletedEventArgs e);
+        protected virtual void OnSoundLocationChanged(EventArgs e);
+        protected virtual void OnStreamChanged(EventArgs e);
+        public void Play();
+        public void PlayLooping();
+        public void PlaySync();
+        public void Stop();
+        void System.Runtime.Serialization.ISerializable.GetObjectData(SerializationInfo info, StreamingContext context);
+    }
+    public class SystemSound {
+        public void Play();
+    }
+    public static class SystemSounds {
+        public static SystemSound Asterisk { get; }
+        public static SystemSound Beep { get; }
+        public static SystemSound Exclamation { get; }
+        public static SystemSound Hand { get; }
+        public static SystemSound Question { get; }
+    }
+}
```

