# System.Reflection

``` diff
+namespace System.Reflection {
+    public abstract class MetadataAssemblyResolver {
+        protected MetadataAssemblyResolver();
+        public abstract Assembly Resolve(MetadataLoadContext context, AssemblyName assemblyName);
+    }
+    public sealed class MetadataLoadContext : IDisposable {
+        public MetadataLoadContext(MetadataAssemblyResolver resolver, string coreAssemblyName = null);
+        public Assembly CoreAssembly { get; }
+        public void Dispose();
+        public IEnumerable<Assembly> GetAssemblies();
+        public Assembly LoadFromAssemblyName(AssemblyName assemblyName);
+        public Assembly LoadFromAssemblyName(string assemblyName);
+        public Assembly LoadFromAssemblyPath(string assemblyPath);
+        public Assembly LoadFromByteArray(byte[] assembly);
+        public Assembly LoadFromStream(Stream assembly);
+    }
+    public class PathAssemblyResolver : MetadataAssemblyResolver {
+        public PathAssemblyResolver(IEnumerable<string> assemblyPaths);
+        public override Assembly Resolve(MetadataLoadContext context, AssemblyName assemblyName);
+    }
+}
```

