# System.Security.Cryptography.Pkcs

``` diff
 namespace System.Security.Cryptography.Pkcs {
     public sealed class AlgorithmIdentifier {
+        public byte[] Parameters { get; set; }
     }
     public sealed class CmsRecipient {
+        public CmsRecipient(SubjectIdentifierType recipientIdentifierType, X509Certificate2 certificate, RSAEncryptionPadding rsaEncryptionPadding);
+        public CmsRecipient(X509Certificate2 certificate, RSAEncryptionPadding rsaEncryptionPadding);
+        public RSAEncryptionPadding RSAEncryptionPadding { get; }
     }
     public sealed class CmsRecipientCollection : ICollection, IEnumerable {
+        public bool IsSynchronized { get; }
+        public object SyncRoot { get; }
-        bool System.Collections.ICollection.IsSynchronized { get; }

-        object System.Collections.ICollection.SyncRoot { get; }

     }
     public sealed class CmsSigner {
+        public CmsSigner(SubjectIdentifierType signerIdentifierType, X509Certificate2 certificate, AsymmetricAlgorithm privateKey);
+        public AsymmetricAlgorithm PrivateKey { get; set; }
     }
     public sealed class EnvelopedCms {
+        public void Decrypt(RecipientInfo recipientInfo, AsymmetricAlgorithm privateKey);
     }
+    public sealed class Pkcs12Builder {
+        public Pkcs12Builder();
+        public bool IsSealed { get; }
+        public void AddSafeContentsEncrypted(Pkcs12SafeContents safeContents, byte[] passwordBytes, PbeParameters pbeParameters);
+        public void AddSafeContentsEncrypted(Pkcs12SafeContents safeContents, ReadOnlySpan<byte> passwordBytes, PbeParameters pbeParameters);
+        public void AddSafeContentsEncrypted(Pkcs12SafeContents safeContents, ReadOnlySpan<char> password, PbeParameters pbeParameters);
+        public void AddSafeContentsEncrypted(Pkcs12SafeContents safeContents, string password, PbeParameters pbeParameters);
+        public void AddSafeContentsUnencrypted(Pkcs12SafeContents safeContents);
+        public byte[] Encode();
+        public void SealWithMac(ReadOnlySpan<char> password, HashAlgorithmName hashAlgorithm, int iterationCount);
+        public void SealWithMac(string password, HashAlgorithmName hashAlgorithm, int iterationCount);
+        public void SealWithoutIntegrity();
+        public bool TryEncode(Span<byte> destination, out int bytesWritten);
+    }
+    public sealed class Pkcs12CertBag : Pkcs12SafeBag {
+        public Pkcs12CertBag(Oid certificateType, ReadOnlyMemory<byte> encodedCertificate);
+        public ReadOnlyMemory<byte> EncodedCertificate { get; }
+        public bool IsX509Certificate { get; }
+        public X509Certificate2 GetCertificate();
+        public Oid GetCertificateType();
+    }
+    public enum Pkcs12ConfidentialityMode {
+        None = 1,
+        Password = 2,
+        PublicKey = 3,
+        Unknown = 0,
+    }
+    public sealed class Pkcs12Info {
+        public ReadOnlyCollection<Pkcs12SafeContents> AuthenticatedSafe { get; }
+        public Pkcs12IntegrityMode IntegrityMode { get; }
+        public static Pkcs12Info Decode(ReadOnlyMemory<byte> encodedBytes, out int bytesConsumed, bool skipCopy = false);
+        public bool VerifyMac(ReadOnlySpan<char> password);
+        public bool VerifyMac(string password);
+    }
+    public enum Pkcs12IntegrityMode {
+        None = 1,
+        Password = 2,
+        PublicKey = 3,
+        Unknown = 0,
+    }
+    public sealed class Pkcs12KeyBag : Pkcs12SafeBag {
+        public Pkcs12KeyBag(ReadOnlyMemory<byte> pkcs8PrivateKey, bool skipCopy = false);
+        public ReadOnlyMemory<byte> Pkcs8PrivateKey { get; }
+    }
+    public abstract class Pkcs12SafeBag {
+        protected Pkcs12SafeBag(string bagIdValue, ReadOnlyMemory<byte> encodedBagValue, bool skipCopy = false);
+        public CryptographicAttributeObjectCollection Attributes { get; }
+        public ReadOnlyMemory<byte> EncodedBagValue { get; }
+        public byte[] Encode();
+        public Oid GetBagId();
+        public bool TryEncode(Span<byte> destination, out int bytesWritten);
+    }
+    public sealed class Pkcs12SafeContents {
+        public Pkcs12SafeContents();
+        public Pkcs12ConfidentialityMode ConfidentialityMode { get; }
+        public bool IsReadOnly { get; }
+        public Pkcs12CertBag AddCertificate(X509Certificate2 certificate);
+        public Pkcs12KeyBag AddKeyUnencrypted(AsymmetricAlgorithm key);
+        public Pkcs12SafeContentsBag AddNestedContents(Pkcs12SafeContents safeContents);
+        public void AddSafeBag(Pkcs12SafeBag safeBag);
+        public Pkcs12SecretBag AddSecret(Oid secretType, ReadOnlyMemory<byte> secretValue);
+        public Pkcs12ShroudedKeyBag AddShroudedKey(AsymmetricAlgorithm key, byte[] passwordBytes, PbeParameters pbeParameters);
+        public Pkcs12ShroudedKeyBag AddShroudedKey(AsymmetricAlgorithm key, ReadOnlySpan<byte> passwordBytes, PbeParameters pbeParameters);
+        public Pkcs12ShroudedKeyBag AddShroudedKey(AsymmetricAlgorithm key, ReadOnlySpan<char> password, PbeParameters pbeParameters);
+        public Pkcs12ShroudedKeyBag AddShroudedKey(AsymmetricAlgorithm key, string password, PbeParameters pbeParameters);
+        public void Decrypt(byte[] passwordBytes);
+        public void Decrypt(ReadOnlySpan<byte> passwordBytes);
+        public void Decrypt(ReadOnlySpan<char> password);
+        public void Decrypt(string password);
+        public IEnumerable<Pkcs12SafeBag> GetBags();
+    }
+    public sealed class Pkcs12SafeContentsBag : Pkcs12SafeBag {
+        public Pkcs12SafeContents SafeContents { get; }
+    }
+    public sealed class Pkcs12SecretBag : Pkcs12SafeBag {
+        public ReadOnlyMemory<byte> SecretValue { get; }
+        public Oid GetSecretType();
+    }
+    public sealed class Pkcs12ShroudedKeyBag : Pkcs12SafeBag {
+        public Pkcs12ShroudedKeyBag(ReadOnlyMemory<byte> encryptedPkcs8PrivateKey, bool skipCopy = false);
+        public ReadOnlyMemory<byte> EncryptedPkcs8PrivateKey { get; }
+    }
+    public sealed class Pkcs8PrivateKeyInfo {
+        public Pkcs8PrivateKeyInfo(Oid algorithmId, ReadOnlyMemory<byte>? algorithmParameters, ReadOnlyMemory<byte> privateKey, bool skipCopies = false);
+        public Oid AlgorithmId { get; }
+        public ReadOnlyMemory<byte>? AlgorithmParameters { get; }
+        public CryptographicAttributeObjectCollection Attributes { get; }
+        public ReadOnlyMemory<byte> PrivateKeyBytes { get; }
+        public static Pkcs8PrivateKeyInfo Create(AsymmetricAlgorithm privateKey);
+        public static Pkcs8PrivateKeyInfo Decode(ReadOnlyMemory<byte> source, out int bytesRead, bool skipCopy = false);
+        public static Pkcs8PrivateKeyInfo DecryptAndDecode(ReadOnlySpan<byte> passwordBytes, ReadOnlyMemory<byte> source, out int bytesRead);
+        public static Pkcs8PrivateKeyInfo DecryptAndDecode(ReadOnlySpan<char> password, ReadOnlyMemory<byte> source, out int bytesRead);
+        public byte[] Encode();
+        public byte[] Encrypt(ReadOnlySpan<byte> passwordBytes, PbeParameters pbeParameters);
+        public byte[] Encrypt(ReadOnlySpan<char> password, PbeParameters pbeParameters);
+        public bool TryEncode(Span<byte> destination, out int bytesWritten);
+        public bool TryEncrypt(ReadOnlySpan<byte> passwordBytes, PbeParameters pbeParameters, Span<byte> destination, out int bytesWritten);
+        public bool TryEncrypt(ReadOnlySpan<char> password, PbeParameters pbeParameters, Span<byte> destination, out int bytesWritten);
+    }
+    public sealed class Pkcs9LocalKeyId : Pkcs9AttributeObject {
+        public Pkcs9LocalKeyId();
+        public Pkcs9LocalKeyId(byte[] keyId);
+        public Pkcs9LocalKeyId(ReadOnlySpan<byte> keyId);
+        public ReadOnlyMemory<byte> KeyId { get; }
+    }
     public sealed class RecipientInfoCollection : ICollection, IEnumerable {
+        public bool IsSynchronized { get; }
+        public object SyncRoot { get; }
-        bool System.Collections.ICollection.IsSynchronized { get; }

-        object System.Collections.ICollection.SyncRoot { get; }

     }
     public sealed class SignedCms {
+        public void AddCertificate(X509Certificate2 certificate);
+        public void RemoveCertificate(X509Certificate2 certificate);
     }
     public sealed class SignerInfo {
+        public void AddUnsignedAttribute(AsnEncodedData asnEncodedData);
+        public void RemoveUnsignedAttribute(AsnEncodedData asnEncodedData);
     }
     public sealed class SubjectIdentifier {
+        public bool MatchesCertificate(X509Certificate2 certificate);
     }
 }
```

