# Microsoft.AspNetCore.Authentication

``` diff
 {
     namespace Microsoft.AspNetCore.Authentication {
+        public class AccessDeniedContext : HandleRequestContext<RemoteAuthenticationOptions> {
+            public AccessDeniedContext(HttpContext context, AuthenticationScheme scheme, RemoteAuthenticationOptions options);
+            public PathString AccessDeniedPath { get; set; }
+            public AuthenticationProperties Properties { get; set; }
+            public string ReturnUrl { get; set; }
+            public string ReturnUrlParameter { get; set; }
+        }
         public class HandleRequestResult : AuthenticateResult {
+            public static new HandleRequestResult NoResult();
         }
+        public static class JsonDocumentAuthExtensions {
+            public static string GetString(this JsonElement element, string key);
+        }
         public class RemoteAuthenticationEvents {
+            public Func<AccessDeniedContext, Task> OnAccessDenied { get; set; }
+            public virtual Task AccessDenied(AccessDeniedContext context);
         }
         public abstract class RemoteAuthenticationHandler<TOptions> : AuthenticationHandler<TOptions>, IAuthenticationHandler, IAuthenticationRequestHandler where TOptions : RemoteAuthenticationOptions, new() {
+            protected virtual Task<HandleRequestResult> HandleAccessDeniedErrorAsync(AuthenticationProperties properties);
         }
         public class RemoteAuthenticationOptions : AuthenticationSchemeOptions {
+            public PathString AccessDeniedPath { get; set; }
+            public string ReturnUrlParameter { get; set; }
         }
+        public class RequestPathBaseCookieBuilder : CookieBuilder {
+            public RequestPathBaseCookieBuilder();
+            protected virtual string AdditionalPath { get; }
+            public override CookieOptions Build(HttpContext context, DateTimeOffset expiresFrom);
+        }
     }
-    namespace Microsoft.AspNetCore.Authentication.Internal {
 {
-        public class RequestPathBaseCookieBuilder : CookieBuilder {
 {
-            public RequestPathBaseCookieBuilder();

-            protected virtual string AdditionalPath { get; }

-            public override CookieOptions Build(HttpContext context, DateTimeOffset expiresFrom);

-        }
-    }
     namespace Microsoft.Extensions.DependencyInjection {
         public static class AuthenticationServiceCollectionExtensions {
-            public static IServiceCollection AddRemoteScheme<TOptions, THandler>(this IServiceCollection services, string authenticationScheme, string displayName, Action<TOptions> configureOptions) where TOptions : RemoteAuthenticationOptions, new() where THandler : RemoteAuthenticationHandler<TOptions>;

-            public static IServiceCollection AddScheme<TOptions, THandler>(this IServiceCollection services, string authenticationScheme, Action<TOptions> configureOptions) where TOptions : AuthenticationSchemeOptions, new() where THandler : AuthenticationHandler<TOptions>;

-            public static IServiceCollection AddScheme<TOptions, THandler>(this IServiceCollection services, string authenticationScheme, string displayName, Action<AuthenticationSchemeBuilder> configureScheme, Action<TOptions> configureOptions) where TOptions : AuthenticationSchemeOptions, new() where THandler : AuthenticationHandler<TOptions>;

-            public static IServiceCollection AddScheme<TOptions, THandler>(this IServiceCollection services, string authenticationScheme, string displayName, Action<TOptions> configureOptions) where TOptions : AuthenticationSchemeOptions, new() where THandler : AuthenticationHandler<TOptions>;

         }
     }
 }
```

