# Microsoft.AspNetCore.Authorization.Policy

``` diff
 {
+    namespace Microsoft.AspNetCore.Authorization {
+        public class AuthorizationMiddleware {
+            public AuthorizationMiddleware(RequestDelegate next, IAuthorizationPolicyProvider policyProvider);
+            public Task Invoke(HttpContext context);
+        }
+    }
+    namespace Microsoft.AspNetCore.Builder {
+        public static class AuthorizationAppBuilderExtensions {
+            public static IApplicationBuilder UseAuthorization(this IApplicationBuilder app);
+        }
+        public static class AuthorizationEndpointConventionBuilderExtensions {
+            public static TBuilder RequireAuthorization<TBuilder>(this TBuilder builder) where TBuilder : IEndpointConventionBuilder;
+            public static TBuilder RequireAuthorization<TBuilder>(this TBuilder builder, params IAuthorizeData[] authorizeData) where TBuilder : IEndpointConventionBuilder;
+            public static TBuilder RequireAuthorization<TBuilder>(this TBuilder builder, params string[] policyNames) where TBuilder : IEndpointConventionBuilder;
+        }
+    }
     namespace Microsoft.Extensions.DependencyInjection {
         public static class PolicyServiceCollectionExtensions {
+            public static IServiceCollection AddAuthorization(this IServiceCollection services);
+            public static IServiceCollection AddAuthorization(this IServiceCollection services, Action<AuthorizationOptions> configure);
         }
     }
 }
```

