# Microsoft.AspNetCore.Authorization

``` diff
 {
     namespace Microsoft.AspNetCore.Authorization {
         public class AuthorizationOptions {
+            public AuthorizationPolicy FallbackPolicy { get; set; }
         }
         public class AuthorizationPolicyBuilder {
-            public AuthorizationPolicyBuilder RequireClaim(string claimType, IEnumerable<string> requiredValues);
+            public AuthorizationPolicyBuilder RequireClaim(string claimType, IEnumerable<string> allowedValues);
-            public AuthorizationPolicyBuilder RequireClaim(string claimType, params string[] requiredValues);
+            public AuthorizationPolicyBuilder RequireClaim(string claimType, params string[] allowedValues);
         }
         public class AuthorizeAttribute : Attribute, IAuthorizeData {
-            public string ActiveAuthenticationSchemes { get; set; }

         }
         public class DefaultAuthorizationPolicyProvider : IAuthorizationPolicyProvider {
+            public Task<AuthorizationPolicy> GetFallbackPolicyAsync();
         }
         public interface IAuthorizationPolicyProvider {
+            Task<AuthorizationPolicy> GetFallbackPolicyAsync();
         }
     }
     namespace Microsoft.Extensions.DependencyInjection {
         public static class AuthorizationServiceCollectionExtensions {
-            public static IServiceCollection AddAuthorization(this IServiceCollection services);

-            public static IServiceCollection AddAuthorization(this IServiceCollection services, Action<AuthorizationOptions> configure);

+            public static IServiceCollection AddAuthorizationCore(this IServiceCollection services);
+            public static IServiceCollection AddAuthorizationCore(this IServiceCollection services, Action<AuthorizationOptions> configure);
         }
     }
 }
```

