# Microsoft.AspNetCore.Components.Authorization

``` diff
 {
+    namespace Microsoft.AspNetCore.Components.Authorization {
+        public class AuthenticationState {
+            public AuthenticationState(ClaimsPrincipal user);
+            public ClaimsPrincipal User { get; }
+        }
+        public delegate void AuthenticationStateChangedHandler(Task<AuthenticationState> task);
+        public abstract class AuthenticationStateProvider {
+            protected AuthenticationStateProvider();
+            public event AuthenticationStateChangedHandler AuthenticationStateChanged;
+            public abstract Task<AuthenticationState> GetAuthenticationStateAsync();
+            protected void NotifyAuthenticationStateChanged(Task<AuthenticationState> task);
+        }
+        public sealed class AuthorizeRouteView : RouteView {
+            public AuthorizeRouteView();
+            public RenderFragment Authorizing { get; set; }
+            public RenderFragment<AuthenticationState> NotAuthorized { get; set; }
+            protected override void Render(RenderTreeBuilder builder);
+        }
+        public class AuthorizeView : AuthorizeViewCore {
+            public AuthorizeView();
+            public string Policy { get; set; }
+            public string Roles { get; set; }
+            protected override IAuthorizeData[] GetAuthorizeData();
+        }
+        public abstract class AuthorizeViewCore : ComponentBase {
+            protected AuthorizeViewCore();
+            public RenderFragment<AuthenticationState> Authorized { get; set; }
+            public RenderFragment Authorizing { get; set; }
+            public RenderFragment<AuthenticationState> ChildContent { get; set; }
+            public RenderFragment<AuthenticationState> NotAuthorized { get; set; }
+            public object Resource { get; set; }
+            protected override void BuildRenderTree(RenderTreeBuilder builder);
+            protected abstract IAuthorizeData[] GetAuthorizeData();
+            protected override Task OnParametersSetAsync();
+        }
+        public class CascadingAuthenticationState : ComponentBase, IDisposable {
+            public CascadingAuthenticationState();
+            public RenderFragment ChildContent { get; set; }
+            protected override void BuildRenderTree(RenderTreeBuilder __builder);
+            protected override void OnInitialized();
+            void System.IDisposable.Dispose();
+        }
+        public interface IHostEnvironmentAuthenticationStateProvider {
+            void SetAuthenticationState(Task<AuthenticationState> authenticationStateTask);
+        }
+    }
+}
```

