# Microsoft.AspNetCore.Components.Forms

``` diff
 {
+    namespace Microsoft.AspNetCore.Components.Forms {
+        public class DataAnnotationsValidator : ComponentBase {
+            public DataAnnotationsValidator();
+            protected override void OnInitialized();
+        }
+        public sealed class EditContext {
+            public EditContext(object model);
+            public object Model { get; }
+            public event EventHandler<FieldChangedEventArgs> OnFieldChanged;
+            public event EventHandler<ValidationRequestedEventArgs> OnValidationRequested;
+            public event EventHandler<ValidationStateChangedEventArgs> OnValidationStateChanged;
+            public FieldIdentifier Field(string fieldName);
+            public IEnumerable<string> GetValidationMessages();
+            public IEnumerable<string> GetValidationMessages(FieldIdentifier fieldIdentifier);
+            public IEnumerable<string> GetValidationMessages(Expression<Func<object>> accessor);
+            public bool IsModified();
+            public bool IsModified(in FieldIdentifier fieldIdentifier);
+            public bool IsModified(Expression<Func<object>> accessor);
+            public void MarkAsUnmodified();
+            public void MarkAsUnmodified(in FieldIdentifier fieldIdentifier);
+            public void NotifyFieldChanged(in FieldIdentifier fieldIdentifier);
+            public void NotifyValidationStateChanged();
+            public bool Validate();
+        }
+        public static class EditContextDataAnnotationsExtensions {
+            public static EditContext AddDataAnnotationsValidation(this EditContext editContext);
+        }
+        public sealed class FieldChangedEventArgs : EventArgs {
+            public FieldChangedEventArgs(in FieldIdentifier fieldIdentifier);
+            public FieldIdentifier FieldIdentifier { get; }
+        }
+        public readonly struct FieldIdentifier : IEquatable<FieldIdentifier> {
+            public FieldIdentifier(object model, string fieldName);
+            public string FieldName { get; }
+            public object Model { get; }
+            public static FieldIdentifier Create<TField>(Expression<Func<TField>> accessor);
+            public bool Equals(FieldIdentifier otherIdentifier);
+            public override bool Equals(object obj);
+            public override int GetHashCode();
+        }
+        public sealed class ValidationMessageStore {
+            public ValidationMessageStore(EditContext editContext);
+            public IEnumerable<string> this[FieldIdentifier fieldIdentifier] { get; }
+            public IEnumerable<string> this[Expression<Func<object>> accessor] { get; }
+            public void Add(in FieldIdentifier fieldIdentifier, IEnumerable<string> messages);
+            public void Add(in FieldIdentifier fieldIdentifier, string message);
+            public void Add(Expression<Func<object>> accessor, IEnumerable<string> messages);
+            public void Add(Expression<Func<object>> accessor, string message);
+            public void Clear();
+            public void Clear(in FieldIdentifier fieldIdentifier);
+            public void Clear(Expression<Func<object>> accessor);
+        }
+        public sealed class ValidationRequestedEventArgs : EventArgs {
+            public static readonly new ValidationRequestedEventArgs Empty;
+            public ValidationRequestedEventArgs();
+        }
+        public sealed class ValidationStateChangedEventArgs : EventArgs {
+            public static readonly new ValidationStateChangedEventArgs Empty;
+            public ValidationStateChangedEventArgs();
+        }
+    }
+}
```

