# Microsoft.AspNetCore.Components.Web

``` diff
 {
+    namespace Microsoft.AspNetCore.Components {
+        public sealed class BindInputElementAttribute : Attribute {
+            public BindInputElementAttribute(string type, string suffix, string valueAttribute, string changeAttribute, bool isInvariantCulture, string format);
+            public string ChangeAttribute { get; }
+            public string Format { get; }
+            public bool IsInvariantCulture { get; }
+            public string Suffix { get; }
+            public string Type { get; }
+            public string ValueAttribute { get; }
+        }
+    }
+    namespace Microsoft.AspNetCore.Components.Forms {
+        public static class EditContextFieldClassExtensions {
+            public static string FieldCssClass(this EditContext editContext, in FieldIdentifier fieldIdentifier);
+            public static string FieldCssClass<TField>(this EditContext editContext, Expression<Func<TField>> accessor);
+        }
+        public class EditForm : ComponentBase {
+            public EditForm();
+            public IReadOnlyDictionary<string, object> AdditionalAttributes { get; set; }
+            public RenderFragment<EditContext> ChildContent { get; set; }
+            public EditContext EditContext { get; set; }
+            public object Model { get; set; }
+            public EventCallback<EditContext> OnInvalidSubmit { get; set; }
+            public EventCallback<EditContext> OnSubmit { get; set; }
+            public EventCallback<EditContext> OnValidSubmit { get; set; }
+            protected override void BuildRenderTree(RenderTreeBuilder builder);
+            protected override void OnParametersSet();
+        }
+        public abstract class InputBase<TValue> : ComponentBase {
+            protected InputBase();
+            public IReadOnlyDictionary<string, object> AdditionalAttributes { get; set; }
+            protected string CssClass { get; }
+            protected TValue CurrentValue { get; set; }
+            protected string CurrentValueAsString { get; set; }
+            protected EditContext EditContext { get; set; }
+            protected FieldIdentifier FieldIdentifier { get; set; }
+            public TValue Value { get; set; }
+            public EventCallback<TValue> ValueChanged { get; set; }
+            public Expression<Func<TValue>> ValueExpression { get; set; }
+            protected virtual string FormatValueAsString(TValue value);
+            public override Task SetParametersAsync(ParameterView parameters);
+            protected abstract bool TryParseValueFromString(string value, out TValue result, out string validationErrorMessage);
+        }
+        public class InputCheckbox : InputBase<bool> {
+            public InputCheckbox();
+            protected override void BuildRenderTree(RenderTreeBuilder builder);
+            protected override bool TryParseValueFromString(string value, out bool result, out string validationErrorMessage);
+        }
+        public class InputDate<TValue> : InputBase<TValue> {
+            public InputDate();
+            public string ParsingErrorMessage { get; set; }
+            protected override void BuildRenderTree(RenderTreeBuilder builder);
+            protected override string FormatValueAsString(TValue value);
+            protected override bool TryParseValueFromString(string value, out TValue result, out string validationErrorMessage);
+        }
+        public class InputNumber<TValue> : InputBase<TValue> {
+            public InputNumber();
+            public string ParsingErrorMessage { get; set; }
+            protected override void BuildRenderTree(RenderTreeBuilder builder);
+            protected override string FormatValueAsString(TValue value);
+            protected override bool TryParseValueFromString(string value, out TValue result, out string validationErrorMessage);
+        }
+        public class InputSelect<TValue> : InputBase<TValue> {
+            public InputSelect();
+            public RenderFragment ChildContent { get; set; }
+            protected override void BuildRenderTree(RenderTreeBuilder builder);
+            protected override bool TryParseValueFromString(string value, out TValue result, out string validationErrorMessage);
+        }
+        public class InputText : InputBase<string> {
+            public InputText();
+            protected override void BuildRenderTree(RenderTreeBuilder builder);
+            protected override bool TryParseValueFromString(string value, out string result, out string validationErrorMessage);
+        }
+        public class InputTextArea : InputBase<string> {
+            public InputTextArea();
+            protected override void BuildRenderTree(RenderTreeBuilder builder);
+            protected override bool TryParseValueFromString(string value, out string result, out string validationErrorMessage);
+        }
+        public class ValidationMessage<TValue> : ComponentBase, IDisposable {
+            public ValidationMessage();
+            public IReadOnlyDictionary<string, object> AdditionalAttributes { get; set; }
+            public Expression<Func<TValue>> For { get; set; }
+            protected override void BuildRenderTree(RenderTreeBuilder builder);
+            protected virtual void Dispose(bool disposing);
+            protected override void OnParametersSet();
+            void System.IDisposable.Dispose();
+        }
+        public class ValidationSummary : ComponentBase, IDisposable {
+            public ValidationSummary();
+            public IReadOnlyDictionary<string, object> AdditionalAttributes { get; set; }
+            protected override void BuildRenderTree(RenderTreeBuilder builder);
+            protected virtual void Dispose(bool disposing);
+            protected override void OnParametersSet();
+            void System.IDisposable.Dispose();
+        }
+    }
+    namespace Microsoft.AspNetCore.Components.RenderTree {
+        public sealed class WebEventDescriptor {
+            public WebEventDescriptor();
+            public int BrowserRendererId { get; set; }
+            public string EventArgsType { get; set; }
+            public EventFieldInfo EventFieldInfo { get; set; }
+            public ulong EventHandlerId { get; set; }
+        }
+    }
+    namespace Microsoft.AspNetCore.Components.Routing {
+        public class NavLink : ComponentBase, IDisposable {
+            public NavLink();
+            public string ActiveClass { get; set; }
+            public IReadOnlyDictionary<string, object> AdditionalAttributes { get; set; }
+            public RenderFragment ChildContent { get; set; }
+            protected string CssClass { get; set; }
+            public NavLinkMatch Match { get; set; }
+            protected override void BuildRenderTree(RenderTreeBuilder builder);
+            public void Dispose();
+            protected override void OnInitialized();
+            protected override void OnParametersSet();
+        }
+        public enum NavLinkMatch {
+            All = 1,
+            Prefix = 0,
+        }
+    }
+    namespace Microsoft.AspNetCore.Components.Web {
+        public static class BindAttributes
+        public class ClipboardEventArgs : EventArgs {
+            public ClipboardEventArgs();
+            public string Type { get; set; }
+        }
+        public class DataTransfer {
+            public DataTransfer();
+            public string DropEffect { get; set; }
+            public string EffectAllowed { get; set; }
+            public string[] Files { get; set; }
+            public DataTransferItem[] Items { get; set; }
+            public string[] Types { get; set; }
+        }
+        public class DataTransferItem {
+            public DataTransferItem();
+            public string Kind { get; set; }
+            public string Type { get; set; }
+        }
+        public class DragEventArgs : MouseEventArgs {
+            public DragEventArgs();
+            public DataTransfer DataTransfer { get; set; }
+        }
+        public class ErrorEventArgs : EventArgs {
+            public ErrorEventArgs();
+            public int Colno { get; set; }
+            public string Filename { get; set; }
+            public int Lineno { get; set; }
+            public string Message { get; set; }
+            public string Type { get; set; }
+        }
+        public static class EventHandlers
+        public class FocusEventArgs : EventArgs {
+            public FocusEventArgs();
+            public string Type { get; set; }
+        }
+        public class KeyboardEventArgs : EventArgs {
+            public KeyboardEventArgs();
+            public bool AltKey { get; set; }
+            public string Code { get; set; }
+            public bool CtrlKey { get; set; }
+            public string Key { get; set; }
+            public float Location { get; set; }
+            public bool MetaKey { get; set; }
+            public bool Repeat { get; set; }
+            public bool ShiftKey { get; set; }
+            public string Type { get; set; }
+        }
+        public class MouseEventArgs : EventArgs {
+            public MouseEventArgs();
+            public bool AltKey { get; set; }
+            public long Button { get; set; }
+            public long Buttons { get; set; }
+            public double ClientX { get; set; }
+            public double ClientY { get; set; }
+            public bool CtrlKey { get; set; }
+            public long Detail { get; set; }
+            public bool MetaKey { get; set; }
+            public double ScreenX { get; set; }
+            public double ScreenY { get; set; }
+            public bool ShiftKey { get; set; }
+            public string Type { get; set; }
+        }
+        public class PointerEventArgs : MouseEventArgs {
+            public PointerEventArgs();
+            public float Height { get; set; }
+            public bool IsPrimary { get; set; }
+            public long PointerId { get; set; }
+            public string PointerType { get; set; }
+            public float Pressure { get; set; }
+            public float TiltX { get; set; }
+            public float TiltY { get; set; }
+            public float Width { get; set; }
+        }
+        public class ProgressEventArgs : EventArgs {
+            public ProgressEventArgs();
+            public bool LengthComputable { get; set; }
+            public long Loaded { get; set; }
+            public long Total { get; set; }
+            public string Type { get; set; }
+        }
+        public class TouchEventArgs : EventArgs {
+            public TouchEventArgs();
+            public bool AltKey { get; set; }
+            public TouchPoint[] ChangedTouches { get; set; }
+            public bool CtrlKey { get; set; }
+            public long Detail { get; set; }
+            public bool MetaKey { get; set; }
+            public bool ShiftKey { get; set; }
+            public TouchPoint[] TargetTouches { get; set; }
+            public TouchPoint[] Touches { get; set; }
+            public string Type { get; set; }
+        }
+        public class TouchPoint {
+            public TouchPoint();
+            public double ClientX { get; set; }
+            public double ClientY { get; set; }
+            public long Identifier { get; set; }
+            public double PageX { get; set; }
+            public double PageY { get; set; }
+            public double ScreenX { get; set; }
+            public double ScreenY { get; set; }
+        }
+        public static class WebEventCallbackFactoryEventArgsExtensions {
+            public static EventCallback<ClipboardEventArgs> Create(this EventCallbackFactory factory, object receiver, Action<ClipboardEventArgs> callback);
+            public static EventCallback<DragEventArgs> Create(this EventCallbackFactory factory, object receiver, Action<DragEventArgs> callback);
+            public static EventCallback<ErrorEventArgs> Create(this EventCallbackFactory factory, object receiver, Action<ErrorEventArgs> callback);
+            public static EventCallback<FocusEventArgs> Create(this EventCallbackFactory factory, object receiver, Action<FocusEventArgs> callback);
+            public static EventCallback<KeyboardEventArgs> Create(this EventCallbackFactory factory, object receiver, Action<KeyboardEventArgs> callback);
+            public static EventCallback<MouseEventArgs> Create(this EventCallbackFactory factory, object receiver, Action<MouseEventArgs> callback);
+            public static EventCallback<PointerEventArgs> Create(this EventCallbackFactory factory, object receiver, Action<PointerEventArgs> callback);
+            public static EventCallback<ProgressEventArgs> Create(this EventCallbackFactory factory, object receiver, Action<ProgressEventArgs> callback);
+            public static EventCallback<TouchEventArgs> Create(this EventCallbackFactory factory, object receiver, Action<TouchEventArgs> callback);
+            public static EventCallback<WheelEventArgs> Create(this EventCallbackFactory factory, object receiver, Action<WheelEventArgs> callback);
+            public static EventCallback<ClipboardEventArgs> Create(this EventCallbackFactory factory, object receiver, Func<ClipboardEventArgs, Task> callback);
+            public static EventCallback<DragEventArgs> Create(this EventCallbackFactory factory, object receiver, Func<DragEventArgs, Task> callback);
+            public static EventCallback<ErrorEventArgs> Create(this EventCallbackFactory factory, object receiver, Func<ErrorEventArgs, Task> callback);
+            public static EventCallback<FocusEventArgs> Create(this EventCallbackFactory factory, object receiver, Func<FocusEventArgs, Task> callback);
+            public static EventCallback<KeyboardEventArgs> Create(this EventCallbackFactory factory, object receiver, Func<KeyboardEventArgs, Task> callback);
+            public static EventCallback<MouseEventArgs> Create(this EventCallbackFactory factory, object receiver, Func<MouseEventArgs, Task> callback);
+            public static EventCallback<PointerEventArgs> Create(this EventCallbackFactory factory, object receiver, Func<PointerEventArgs, Task> callback);
+            public static EventCallback<ProgressEventArgs> Create(this EventCallbackFactory factory, object receiver, Func<ProgressEventArgs, Task> callback);
+            public static EventCallback<TouchEventArgs> Create(this EventCallbackFactory factory, object receiver, Func<TouchEventArgs, Task> callback);
+            public static EventCallback<WheelEventArgs> Create(this EventCallbackFactory factory, object receiver, Func<WheelEventArgs, Task> callback);
+        }
+        public class WheelEventArgs : MouseEventArgs {
+            public WheelEventArgs();
+            public long DeltaMode { get; set; }
+            public double DeltaX { get; set; }
+            public double DeltaY { get; set; }
+            public double DeltaZ { get; set; }
+        }
+    }
+}
```

