# Microsoft.AspNetCore.HeaderPropagation

``` diff
 {
+    namespace Microsoft.AspNetCore.Builder {
+        public static class HeaderPropagationApplicationBuilderExtensions {
+            public static IApplicationBuilder UseHeaderPropagation(this IApplicationBuilder app);
+        }
+    }
+    namespace Microsoft.AspNetCore.HeaderPropagation {
+        public readonly struct HeaderPropagationContext {
+            public HeaderPropagationContext(HttpContext httpContext, string headerName, StringValues headerValue);
+            public string HeaderName { get; }
+            public StringValues HeaderValue { get; }
+            public HttpContext HttpContext { get; }
+        }
+        public class HeaderPropagationEntry {
+            public HeaderPropagationEntry(string inboundHeaderName, string capturedHeaderName, Func<HeaderPropagationContext, StringValues> valueFilter);
+            public string CapturedHeaderName { get; }
+            public string InboundHeaderName { get; }
+            public Func<HeaderPropagationContext, StringValues> ValueFilter { get; }
+        }
+        public sealed class HeaderPropagationEntryCollection : Collection<HeaderPropagationEntry> {
+            public HeaderPropagationEntryCollection();
+            public void Add(string headerName);
+            public void Add(string headerName, Func<HeaderPropagationContext, StringValues> valueFilter);
+            public void Add(string inboundHeaderName, string outboundHeaderName);
+            public void Add(string inboundHeaderName, string outboundHeaderName, Func<HeaderPropagationContext, StringValues> valueFilter);
+        }
+        public class HeaderPropagationMessageHandler : DelegatingHandler {
+            public HeaderPropagationMessageHandler(HeaderPropagationMessageHandlerOptions options, HeaderPropagationValues values);
+            protected override Task<HttpResponseMessage> SendAsync(HttpRequestMessage request, CancellationToken cancellationToken);
+        }
+        public class HeaderPropagationMessageHandlerEntry {
+            public HeaderPropagationMessageHandlerEntry(string capturedHeaderName, string outboundHeaderName);
+            public string CapturedHeaderName { get; }
+            public string OutboundHeaderName { get; }
+        }
+        public sealed class HeaderPropagationMessageHandlerEntryCollection : Collection<HeaderPropagationMessageHandlerEntry> {
+            public HeaderPropagationMessageHandlerEntryCollection();
+            public void Add(string headerName);
+            public void Add(string capturedHeaderName, string outboundHeaderName);
+        }
+        public class HeaderPropagationMessageHandlerOptions {
+            public HeaderPropagationMessageHandlerOptions();
+            public HeaderPropagationMessageHandlerEntryCollection Headers { get; set; }
+        }
+        public class HeaderPropagationMiddleware {
+            public HeaderPropagationMiddleware(RequestDelegate next, IOptions<HeaderPropagationOptions> options, HeaderPropagationValues values);
+            public Task Invoke(HttpContext context);
+        }
+        public class HeaderPropagationOptions {
+            public HeaderPropagationOptions();
+            public HeaderPropagationEntryCollection Headers { get; set; }
+        }
+        public class HeaderPropagationValues {
+            public HeaderPropagationValues();
+            public IDictionary<string, StringValues> Headers { get; set; }
+        }
+    }
+    namespace Microsoft.Extensions.DependencyInjection {
+        public static class HeaderPropagationHttpClientBuilderExtensions {
+            public static IHttpClientBuilder AddHeaderPropagation(this IHttpClientBuilder builder);
+            public static IHttpClientBuilder AddHeaderPropagation(this IHttpClientBuilder builder, Action<HeaderPropagationMessageHandlerOptions> configure);
+        }
+        public static class HeaderPropagationServiceCollectionExtensions {
+            public static IServiceCollection AddHeaderPropagation(this IServiceCollection services);
+            public static IServiceCollection AddHeaderPropagation(this IServiceCollection services, Action<HeaderPropagationOptions> configureOptions);
+        }
+    }
+}
```

