# Microsoft.AspNetCore.Routing

``` diff
 {
     namespace Microsoft.AspNetCore.Builder {
+        public static class EndpointRouteBuilderExtensions {
+            public static IEndpointConventionBuilder Map(this IEndpointRouteBuilder endpoints, RoutePattern pattern, RequestDelegate requestDelegate);
+            public static IEndpointConventionBuilder Map(this IEndpointRouteBuilder endpoints, string pattern, RequestDelegate requestDelegate);
+            public static IEndpointConventionBuilder MapDelete(this IEndpointRouteBuilder endpoints, string pattern, RequestDelegate requestDelegate);
+            public static IEndpointConventionBuilder MapGet(this IEndpointRouteBuilder endpoints, string pattern, RequestDelegate requestDelegate);
+            public static IEndpointConventionBuilder MapMethods(this IEndpointRouteBuilder endpoints, string pattern, IEnumerable<string> httpMethods, RequestDelegate requestDelegate);
+            public static IEndpointConventionBuilder MapPost(this IEndpointRouteBuilder endpoints, string pattern, RequestDelegate requestDelegate);
+            public static IEndpointConventionBuilder MapPut(this IEndpointRouteBuilder endpoints, string pattern, RequestDelegate requestDelegate);
+        }
+        public static class EndpointRoutingApplicationBuilderExtensions {
+            public static IApplicationBuilder UseEndpoints(this IApplicationBuilder builder, Action<IEndpointRouteBuilder> configure);
+            public static IApplicationBuilder UseRouting(this IApplicationBuilder builder);
+        }
+        public static class FallbackEndpointRouteBuilderExtensions {
+            public static readonly string DefaultPattern;
+            public static IEndpointConventionBuilder MapFallback(this IEndpointRouteBuilder endpoints, RequestDelegate requestDelegate);
+            public static IEndpointConventionBuilder MapFallback(this IEndpointRouteBuilder endpoints, string pattern, RequestDelegate requestDelegate);
+        }
+        public static class RoutingEndpointConventionBuilderExtensions {
+            public static TBuilder RequireHost<TBuilder>(this TBuilder builder, params string[] hosts) where TBuilder : IEndpointConventionBuilder;
+            public static TBuilder WithDisplayName<TBuilder>(this TBuilder builder, Func<EndpointBuilder, string> func) where TBuilder : IEndpointConventionBuilder;
+            public static TBuilder WithDisplayName<TBuilder>(this TBuilder builder, string displayName) where TBuilder : IEndpointConventionBuilder;
+            public static TBuilder WithMetadata<TBuilder>(this TBuilder builder, params object[] items) where TBuilder : IEndpointConventionBuilder;
+        }
     }
-    namespace Microsoft.AspNetCore.Internal {
 {
-        public static class EndpointRoutingApplicationBuilderExtensions {
 {
-            public static IApplicationBuilder UseEndpoint(this IApplicationBuilder builder);

-            public static IApplicationBuilder UseEndpointRouting(this IApplicationBuilder builder);

-        }
-    }
     namespace Microsoft.AspNetCore.Routing {
         public sealed class CompositeEndpointDataSource : EndpointDataSource {
+            public CompositeEndpointDataSource(IEnumerable<EndpointDataSource> endpointDataSources);
+            public IEnumerable<EndpointDataSource> DataSources { get; }
         }
         public class DefaultInlineConstraintResolver : IInlineConstraintResolver {
-            public DefaultInlineConstraintResolver(IOptions<RouteOptions> routeOptions);

         }
-        public sealed class EndpointSelectorContext : IEndpointFeature, IRouteValuesFeature, IRoutingFeature {
 {
-            public EndpointSelectorContext();

-            public Endpoint Endpoint { get; set; }

-            RouteData Microsoft.AspNetCore.Routing.IRoutingFeature.RouteData { get; set; }

-            public RouteValueDictionary RouteValues { get; set; }

-        }
+        public sealed class HostAttribute : Attribute, IHostMetadata {
+            public HostAttribute(string host);
+            public HostAttribute(params string[] hosts);
+            public IReadOnlyList<string> Hosts { get; }
+        }
+        public interface IDynamicEndpointMetadata {
+            bool IsDynamic { get; }
+        }
+        public interface IEndpointRouteBuilder {
+            ICollection<EndpointDataSource> DataSources { get; }
+            IServiceProvider ServiceProvider { get; }
+            IApplicationBuilder CreateApplicationBuilder();
+        }
+        public interface IHostMetadata {
+            IReadOnlyList<string> Hosts { get; }
+        }
+        public interface IRouteNameMetadata {
+            string RouteName { get; }
+        }
-        public interface IRouteValuesAddressMetadata {
 {
-            IReadOnlyDictionary<string, object> RequiredValues { get; }

-            string RouteName { get; }

-        }
+        public abstract class LinkParser {
+            protected LinkParser();
+            public abstract RouteValueDictionary ParsePathByAddress<TAddress>(TAddress address, PathString path);
+        }
+        public static class LinkParserEndpointNameAddressExtensions {
+            public static RouteValueDictionary ParsePathByEndpointName(this LinkParser parser, string endpointName, PathString path);
+        }
         public abstract class MatcherPolicy {
+            protected static bool ContainsDynamicEndpoints(IReadOnlyList<Endpoint> endpoints);
         }
+        public sealed class RouteEndpointBuilder : EndpointBuilder {
+            public RouteEndpointBuilder(RequestDelegate requestDelegate, RoutePattern routePattern, int order);
+            public int Order { get; set; }
+            public RoutePattern RoutePattern { get; set; }
+            public override Endpoint Build();
+        }
+        public sealed class RouteNameMetadata : IRouteNameMetadata {
+            public RouteNameMetadata(string routeName);
+            public string RouteName { get; }
+        }
         public class RouteOptions {
+            public bool SuppressCheckForUnhandledSecurityMetadata { get; set; }
         }
         public class RouteValueEqualityComparer : IEqualityComparer<object> {
+            public static readonly RouteValueEqualityComparer Default;
         }
-        public sealed class RouteValuesAddressMetadata : IRouteValuesAddressMetadata {
 {
-            public RouteValuesAddressMetadata(IReadOnlyDictionary<string, object> requiredValues);

-            public RouteValuesAddressMetadata(string routeName);

-            public RouteValuesAddressMetadata(string routeName, IReadOnlyDictionary<string, object> requiredValues);

-            public IReadOnlyDictionary<string, object> RequiredValues { get; }

-            public string RouteName { get; }

-        }
     }
     namespace Microsoft.AspNetCore.Routing.Constraints {
+        public class FileNameRouteConstraint : IParameterPolicy, IRouteConstraint {
+            public FileNameRouteConstraint();
+            public bool Match(HttpContext httpContext, IRouter route, string routeKey, RouteValueDictionary values, RouteDirection routeDirection);
+        }
+        public class NonFileNameRouteConstraint : IParameterPolicy, IRouteConstraint {
+            public NonFileNameRouteConstraint();
+            public bool Match(HttpContext httpContext, IRouter route, string routeKey, RouteValueDictionary values, RouteDirection routeDirection);
+        }
     }
     namespace Microsoft.AspNetCore.Routing.Internal {
-        public struct BufferValue {
 {
-            public BufferValue(string value, bool requiresEncoding);

-            public bool RequiresEncoding { get; }

-            public string Value { get; }

-        }
-        public class LinkGenerationDecisionTree {
 {
-            public LinkGenerationDecisionTree(IReadOnlyList<OutboundMatch> entries);

-            public IList<OutboundMatchResult> GetMatches(RouteValueDictionary values, RouteValueDictionary ambientValues);

-        }
-        public struct OutboundMatchResult {
 {
-            public OutboundMatchResult(OutboundMatch match, bool isFallbackMatch);

-            public bool IsFallbackMatch { get; }

-            public OutboundMatch Match { get; }

-        }
-        public struct PathTokenizer : IEnumerable, IEnumerable<StringSegment>, IReadOnlyCollection<StringSegment>, IReadOnlyList<StringSegment> {
 {
-            public PathTokenizer(PathString path);

-            public int Count { get; }

-            public StringSegment this[int index] { get; }

-            public PathTokenizer.Enumerator GetEnumerator();

-            IEnumerator<StringSegment> System.Collections.Generic.IEnumerable<Microsoft.Extensions.Primitives.StringSegment>.GetEnumerator();

-            IEnumerator System.Collections.IEnumerable.GetEnumerator();

-            public struct Enumerator : IDisposable, IEnumerator, IEnumerator<StringSegment> {
 {
-                public Enumerator(PathTokenizer tokenizer);

-                public StringSegment Current { get; }

-                object System.Collections.IEnumerator.Current { get; }

-                public void Dispose();

-                public bool MoveNext();

-                public void Reset();

-            }
-        }
-        public enum SegmentState {
 {
-            Beginning = 0,

-            Inside = 1,

-        }
-        public class UriBuilderContextPooledObjectPolicy : IPooledObjectPolicy<UriBuildingContext> {
 {
-            public UriBuilderContextPooledObjectPolicy();

-            public UriBuildingContext Create();

-            public bool Return(UriBuildingContext obj);

-        }
-        public class UriBuildingContext {
 {
-            public UriBuildingContext(UrlEncoder urlEncoder);

-            public bool AppendTrailingSlash { get; set; }

-            public SegmentState BufferState { get; private set; }

-            public bool LowercaseQueryStrings { get; set; }

-            public bool LowercaseUrls { get; set; }

-            public TextWriter PathWriter { get; }

-            public TextWriter QueryWriter { get; }

-            public SegmentState UriState { get; private set; }

-            public bool Accept(string value);

-            public bool Accept(string value, bool encodeSlashes);

-            public bool Buffer(string value);

-            public void Clear();

-            public void EndSegment();

-            public void Remove(string literal);

-            public PathString ToPathString();

-            public QueryString ToQueryString();

-            public override string ToString();

-        }
     }
     namespace Microsoft.AspNetCore.Routing.Matching {
         public sealed class CandidateSet {
+            public void ExpandEndpoint(int index, IReadOnlyList<Endpoint> endpoints, IComparer<Endpoint> comparer);
+            public void ReplaceEndpoint(int index, Endpoint endpoint, RouteValueDictionary values);
         }
+        public sealed class EndpointMetadataComparer : IComparer<Endpoint> {
+            int System.Collections.Generic.IComparer<Microsoft.AspNetCore.Http.Endpoint>.Compare(Endpoint x, Endpoint y);
+        }
         public abstract class EndpointSelector {
-            public abstract Task SelectAsync(HttpContext httpContext, EndpointSelectorContext context, CandidateSet candidates);

+            public abstract Task SelectAsync(HttpContext httpContext, CandidateSet candidates);
         }
+        public sealed class HostMatcherPolicy : MatcherPolicy, IEndpointComparerPolicy, IEndpointSelectorPolicy, INodeBuilderPolicy {
+            public HostMatcherPolicy();
+            public IComparer<Endpoint> Comparer { get; }
+            public override int Order { get; }
+            public Task ApplyAsync(HttpContext httpContext, CandidateSet candidates);
+            public PolicyJumpTable BuildJumpTable(int exitDestination, IReadOnlyList<PolicyJumpTableEdge> edges);
+            public IReadOnlyList<PolicyNodeEdge> GetEdges(IReadOnlyList<Endpoint> endpoints);
+            bool Microsoft.AspNetCore.Routing.Matching.IEndpointSelectorPolicy.AppliesToEndpoints(IReadOnlyList<Endpoint> endpoints);
+            bool Microsoft.AspNetCore.Routing.Matching.INodeBuilderPolicy.AppliesToEndpoints(IReadOnlyList<Endpoint> endpoints);
+        }
-        public sealed class HttpMethodMatcherPolicy : MatcherPolicy, IEndpointComparerPolicy, INodeBuilderPolicy {
+        public sealed class HttpMethodMatcherPolicy : MatcherPolicy, IEndpointComparerPolicy, IEndpointSelectorPolicy, INodeBuilderPolicy {
-            public bool AppliesToEndpoints(IReadOnlyList<Endpoint> endpoints);

+            public Task ApplyAsync(HttpContext httpContext, CandidateSet candidates);
+            bool Microsoft.AspNetCore.Routing.Matching.IEndpointSelectorPolicy.AppliesToEndpoints(IReadOnlyList<Endpoint> endpoints);
+            bool Microsoft.AspNetCore.Routing.Matching.INodeBuilderPolicy.AppliesToEndpoints(IReadOnlyList<Endpoint> endpoints);
         }
         public interface IEndpointSelectorPolicy {
-            Task ApplyAsync(HttpContext httpContext, EndpointSelectorContext context, CandidateSet candidates);

+            Task ApplyAsync(HttpContext httpContext, CandidateSet candidates);
         }
     }
     namespace Microsoft.AspNetCore.Routing.Patterns {
         public sealed class RoutePattern {
+            public static readonly object RequiredValueAny;
+            public IReadOnlyDictionary<string, object> RequiredValues { get; }
         }
         public static class RoutePatternFactory {
+            public static RoutePattern Parse(string pattern, object defaults, object parameterPolicies, object requiredValues);
         }
+        public abstract class RoutePatternTransformer {
+            protected RoutePatternTransformer();
+            public abstract RoutePattern SubstituteRequiredValues(RoutePattern original, object requiredValues);
+        }
     }
     namespace Microsoft.AspNetCore.Routing.Template {
         public class TemplateBinder {
-            public TemplateBinder(UrlEncoder urlEncoder, ObjectPool<UriBuildingContext> pool, RoutePattern pattern, RouteValueDictionary defaults, IEnumerable<string> requiredKeys, IEnumerable<ValueTuple<string, IParameterPolicy>> parameterPolicies);

-            public TemplateBinder(UrlEncoder urlEncoder, ObjectPool<UriBuildingContext> pool, RouteTemplate template, RouteValueDictionary defaults);

         }
+        public abstract class TemplateBinderFactory {
+            protected TemplateBinderFactory();
+            public abstract TemplateBinder Create(RoutePattern pattern);
+            public abstract TemplateBinder Create(RouteTemplate template, RouteValueDictionary defaults);
+        }
     }
     namespace Microsoft.AspNetCore.Routing.Tree {
         public class TreeRouteBuilder {
-            public TreeRouteBuilder(ILoggerFactory loggerFactory, ObjectPool<UriBuildingContext> objectPool, IInlineConstraintResolver constraintResolver);

-            public TreeRouteBuilder(ILoggerFactory loggerFactory, UrlEncoder urlEncoder, ObjectPool<UriBuildingContext> objectPool, IInlineConstraintResolver constraintResolver);

         }
         public class TreeRouter : IRouter {
-            public TreeRouter(UrlMatchingTree[] trees, IEnumerable<OutboundRouteEntry> linkGenerationEntries, UrlEncoder urlEncoder, ObjectPool<UriBuildingContext> objectPool, ILogger routeLogger, ILogger constraintLogger, int version);

         }
     }
 }
```

