# Microsoft.AspNetCore.SignalR.Client.Core

``` diff
 {
-    namespace Microsoft.AspNetCore.Internal {
 {
-        public static class AwaitableThreadPool {
 {
-            public static AwaitableThreadPool.Awaitable Yield();

-            public readonly struct Awaitable : ICriticalNotifyCompletion, INotifyCompletion {
 {
-                public bool IsCompleted { get; }

-                public AwaitableThreadPool.Awaitable GetAwaiter();

-                public void GetResult();

-                public void OnCompleted(Action continuation);

-                public void UnsafeOnCompleted(Action continuation);

-            }
-        }
-    }
     namespace Microsoft.AspNetCore.SignalR.Client {
         public class HubConnection {
+            public HubConnection(IConnectionFactory connectionFactory, IHubProtocol protocol, EndPoint endPoint, IServiceProvider serviceProvider, ILoggerFactory loggerFactory);
+            public HubConnection(IConnectionFactory connectionFactory, IHubProtocol protocol, EndPoint endPoint, IServiceProvider serviceProvider, ILoggerFactory loggerFactory, IRetryPolicy reconnectPolicy);
-            public HubConnection(IConnectionFactory connectionFactory, IHubProtocol protocol, ILoggerFactory loggerFactory);

-            public HubConnection(IConnectionFactory connectionFactory, IHubProtocol protocol, IServiceProvider serviceProvider, ILoggerFactory loggerFactory);

+            public string ConnectionId { get; }
+            public event Func<string, Task> Reconnected;
+            public event Func<Exception, Task> Reconnecting;
-            public void ResetSendPing();

-            public void ResetTimeout();

+            public IAsyncEnumerable<TResult> StreamAsyncCore<TResult>(string methodName, object[] args, CancellationToken cancellationToken = default(CancellationToken));
         }
         public static class HubConnectionBuilderExtensions {
+            public static IHubConnectionBuilder WithAutomaticReconnect(this IHubConnectionBuilder hubConnectionBuilder);
+            public static IHubConnectionBuilder WithAutomaticReconnect(this IHubConnectionBuilder hubConnectionBuilder, IRetryPolicy retryPolicy);
+            public static IHubConnectionBuilder WithAutomaticReconnect(this IHubConnectionBuilder hubConnectionBuilder, TimeSpan[] reconnectDelays);
         }
         public static class HubConnectionExtensions {
+            public static IDisposable On(this HubConnection hubConnection, string methodName, Func<Task> handler);
+            public static IDisposable On<T1, T2, T3, T4, T5, T6, T7, T8>(this HubConnection hubConnection, string methodName, Func<T1, T2, T3, T4, T5, T6, T7, T8, Task> handler);
+            public static IDisposable On<T1, T2, T3, T4, T5, T6, T7>(this HubConnection hubConnection, string methodName, Func<T1, T2, T3, T4, T5, T6, T7, Task> handler);
+            public static IDisposable On<T1, T2, T3, T4, T5, T6>(this HubConnection hubConnection, string methodName, Func<T1, T2, T3, T4, T5, T6, Task> handler);
+            public static IDisposable On<T1, T2, T3, T4, T5>(this HubConnection hubConnection, string methodName, Func<T1, T2, T3, T4, T5, Task> handler);
+            public static IDisposable On<T1, T2, T3, T4>(this HubConnection hubConnection, string methodName, Func<T1, T2, T3, T4, Task> handler);
+            public static IDisposable On<T1, T2, T3>(this HubConnection hubConnection, string methodName, Func<T1, T2, T3, Task> handler);
+            public static IDisposable On<T1, T2>(this HubConnection hubConnection, string methodName, Func<T1, T2, Task> handler);
+            public static IDisposable On<T1>(this HubConnection hubConnection, string methodName, Func<T1, Task> handler);
+            public static IAsyncEnumerable<TResult> StreamAsync<TResult>(this HubConnection hubConnection, string methodName, object arg1, object arg2, object arg3, object arg4, object arg5, object arg6, object arg7, object arg8, object arg9, object arg10, CancellationToken cancellationToken = default(CancellationToken));
+            public static IAsyncEnumerable<TResult> StreamAsync<TResult>(this HubConnection hubConnection, string methodName, object arg1, object arg2, object arg3, object arg4, object arg5, object arg6, object arg7, object arg8, object arg9, CancellationToken cancellationToken = default(CancellationToken));
+            public static IAsyncEnumerable<TResult> StreamAsync<TResult>(this HubConnection hubConnection, string methodName, object arg1, object arg2, object arg3, object arg4, object arg5, object arg6, object arg7, object arg8, CancellationToken cancellationToken = default(CancellationToken));
+            public static IAsyncEnumerable<TResult> StreamAsync<TResult>(this HubConnection hubConnection, string methodName, object arg1, object arg2, object arg3, object arg4, object arg5, object arg6, object arg7, CancellationToken cancellationToken = default(CancellationToken));
+            public static IAsyncEnumerable<TResult> StreamAsync<TResult>(this HubConnection hubConnection, string methodName, object arg1, object arg2, object arg3, object arg4, object arg5, object arg6, CancellationToken cancellationToken = default(CancellationToken));
+            public static IAsyncEnumerable<TResult> StreamAsync<TResult>(this HubConnection hubConnection, string methodName, object arg1, object arg2, object arg3, object arg4, object arg5, CancellationToken cancellationToken = default(CancellationToken));
+            public static IAsyncEnumerable<TResult> StreamAsync<TResult>(this HubConnection hubConnection, string methodName, object arg1, object arg2, object arg3, object arg4, CancellationToken cancellationToken = default(CancellationToken));
+            public static IAsyncEnumerable<TResult> StreamAsync<TResult>(this HubConnection hubConnection, string methodName, object arg1, object arg2, object arg3, CancellationToken cancellationToken = default(CancellationToken));
+            public static IAsyncEnumerable<TResult> StreamAsync<TResult>(this HubConnection hubConnection, string methodName, object arg1, object arg2, CancellationToken cancellationToken = default(CancellationToken));
+            public static IAsyncEnumerable<TResult> StreamAsync<TResult>(this HubConnection hubConnection, string methodName, object arg1, CancellationToken cancellationToken = default(CancellationToken));
+            public static IAsyncEnumerable<TResult> StreamAsync<TResult>(this HubConnection hubConnection, string methodName, CancellationToken cancellationToken = default(CancellationToken));
         }
         public enum HubConnectionState {
+            Connecting = 2,
+            Reconnecting = 3,
         }
-        public interface IConnectionFactory {
 {
-            Task<ConnectionContext> ConnectAsync(TransferFormat transferFormat, CancellationToken cancellationToken = default(CancellationToken));

-            Task DisposeAsync(ConnectionContext connection);

-        }
+        public interface IRetryPolicy {
+            TimeSpan? NextRetryDelay(RetryContext retryContext);
+        }
+        public sealed class RetryContext {
+            public RetryContext();
+            public TimeSpan ElapsedTime { get; set; }
+            public long PreviousRetryCount { get; set; }
+            public Exception RetryReason { get; set; }
+        }
     }
 }
```

