# Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson

``` diff
 {
+    namespace Microsoft.AspNetCore.SignalR {
+        public class NewtonsoftJsonHubProtocolOptions {
+            public NewtonsoftJsonHubProtocolOptions();
+            public JsonSerializerSettings PayloadSerializerSettings { get; set; }
+        }
+    }
+    namespace Microsoft.AspNetCore.SignalR.Protocol {
+        public class NewtonsoftJsonHubProtocol : IHubProtocol {
+            public NewtonsoftJsonHubProtocol();
+            public NewtonsoftJsonHubProtocol(IOptions<NewtonsoftJsonHubProtocolOptions> options);
+            public string Name { get; }
+            public JsonSerializer PayloadSerializer { get; }
+            public TransferFormat TransferFormat { get; }
+            public int Version { get; }
+            public ReadOnlyMemory<byte> GetMessageBytes(HubMessage message);
+            public bool IsVersionSupported(int version);
+            public bool TryParseMessage(ref ReadOnlySequence<byte> input, IInvocationBinder binder, out HubMessage message);
+            public void WriteMessage(HubMessage message, IBufferWriter<byte> output);
+        }
+    }
+    namespace Microsoft.Extensions.DependencyInjection {
+        public static class NewtonsoftJsonProtocolDependencyInjectionExtensions {
+            public static TBuilder AddNewtonsoftJsonProtocol<TBuilder>(this TBuilder builder) where TBuilder : ISignalRBuilder;
+            public static TBuilder AddNewtonsoftJsonProtocol<TBuilder>(this TBuilder builder, Action<NewtonsoftJsonHubProtocolOptions> configure) where TBuilder : ISignalRBuilder;
+        }
+    }
+}
```

