# Microsoft.AspNetCore.TestHost

``` diff
 {
     namespace Microsoft.AspNetCore.TestHost {
         public class ClientHandler : HttpMessageHandler {
-            public ClientHandler(PathString pathBase, IHttpApplication<HostingApplication.Context> application);

         }
+        public static class HostBuilderTestServerExtensions {
+            public static HttpClient GetTestClient(this IHost host);
+            public static TestServer GetTestServer(this IHost host);
+        }
+        public class HttpResetTestException : Exception {
+            public HttpResetTestException(int errorCode);
+            public int ErrorCode { get; }
+        }
         public class RequestBuilder {
+            public TestServer TestServer { get; }
         }
         public class TestServer : IDisposable, IServer {
+            public TestServer(IServiceProvider services);
+            public TestServer(IServiceProvider services, IFeatureCollection featureCollection);
+            public bool AllowSynchronousIO { get; set; }
+            public bool PreserveExecutionContext { get; set; }
+            public IServiceProvider Services { get; }
         }
         public static class WebHostBuilderExtensions {
+            public static HttpClient GetTestClient(this IWebHost host);
+            public static TestServer GetTestServer(this IWebHost host);
+            public static IWebHostBuilder UseTestServer(this IWebHostBuilder builder);
         }
     }
 }
```

