# Microsoft.Extensions.Configuration.NewtonsoftJson

``` diff
 {
+    namespace Microsoft.Extensions.Configuration {
+        public static class NewtonsoftJsonConfigurationExtensions {
+            public static IConfigurationBuilder AddNewtonsoftJsonFile(this IConfigurationBuilder builder, IFileProvider provider, string path, bool optional, bool reloadOnChange);
+            public static IConfigurationBuilder AddNewtonsoftJsonFile(this IConfigurationBuilder builder, Action<NewtonsoftJsonConfigurationSource> configureSource);
+            public static IConfigurationBuilder AddNewtonsoftJsonFile(this IConfigurationBuilder builder, string path);
+            public static IConfigurationBuilder AddNewtonsoftJsonFile(this IConfigurationBuilder builder, string path, bool optional);
+            public static IConfigurationBuilder AddNewtonsoftJsonFile(this IConfigurationBuilder builder, string path, bool optional, bool reloadOnChange);
+            public static IConfigurationBuilder AddNewtonsoftJsonStream(this IConfigurationBuilder builder, Stream stream);
+        }
+    }
+    namespace Microsoft.Extensions.Configuration.NewtonsoftJson {
+        public class NewtonsoftJsonConfigurationProvider : FileConfigurationProvider {
+            public NewtonsoftJsonConfigurationProvider(NewtonsoftJsonConfigurationSource source);
+            public override void Load(Stream stream);
+        }
+        public class NewtonsoftJsonConfigurationSource : FileConfigurationSource {
+            public NewtonsoftJsonConfigurationSource();
+            public override IConfigurationProvider Build(IConfigurationBuilder builder);
+        }
+        public class NewtonsoftJsonStreamConfigurationProvider : StreamConfigurationProvider {
+            public NewtonsoftJsonStreamConfigurationProvider(NewtonsoftJsonStreamConfigurationSource source);
+            public override void Load(Stream stream);
+        }
+        public class NewtonsoftJsonStreamConfigurationSource : StreamConfigurationSource {
+            public NewtonsoftJsonStreamConfigurationSource();
+            public override IConfigurationProvider Build(IConfigurationBuilder builder);
+        }
+    }
+}
```

