# Microsoft.Extensions.Identity.Core

``` diff
 {
     namespace Microsoft.AspNetCore.Identity {
+        public class DefaultUserConfirmation<TUser> : IUserConfirmation<TUser> where TUser : class {
+            public DefaultUserConfirmation();
+            public virtual Task<bool> IsConfirmedAsync(UserManager<TUser> manager, TUser user);
+        }
         public interface ILookupNormalizer {
-            string Normalize(string key);

+            string NormalizeEmail(string email);
+            string NormalizeName(string name);
         }
+        public interface IUserConfirmation<TUser> where TUser : class {
+            Task<bool> IsConfirmedAsync(UserManager<TUser> manager, TUser user);
+        }
         public class SignInOptions {
+            public bool RequireConfirmedAccount { get; set; }
         }
-        public class UpperInvariantLookupNormalizer : ILookupNormalizer {
+        public sealed class UpperInvariantLookupNormalizer : ILookupNormalizer {
-            public virtual string Normalize(string key);

+            public string NormalizeEmail(string email);
+            public string NormalizeName(string name);
         }
         public class UserManager<TUser> : IDisposable where TUser : class {
+            public virtual string NormalizeEmail(string email);
-            public virtual string NormalizeKey(string key);

+            public virtual string NormalizeName(string name);
         }
     }
 }
```

