# System.Text.Json

``` diff
 namespace System.Text.Json {
     public readonly struct JsonElement {
+        public byte[] GetBytesFromBase64();
+        public bool TryGetBytesFromBase64(out byte[] value);
+        public void WriteAsProperty(string propertyName, Utf8JsonWriter writer);
     }
+    public readonly struct JsonEncodedText : IEquatable<JsonEncodedText> {
+        public ReadOnlySpan<byte> EncodedUtf8Bytes { get; }
+        public static JsonEncodedText Encode(ReadOnlySpan<byte> utf8Value);
+        public static JsonEncodedText Encode(ReadOnlySpan<char> value);
+        public static JsonEncodedText Encode(string value);
+        public override bool Equals(object obj);
+        public bool Equals(JsonEncodedText other);
+        public override int GetHashCode();
+        public override string ToString();
+    }
+    public class JsonException : Exception {
+        protected JsonException(SerializationInfo info, StreamingContext context);
+        public JsonException(string message, string path, Nullable<long> lineNumber, Nullable<long> bytePositionInLine);
+        public JsonException(string message, string path, Nullable<long> lineNumber, Nullable<long> bytePositionInLine, Exception innerException);
+        public Nullable<long> BytePositionInLine { get; }
+        public Nullable<long> LineNumber { get; }
+        public string Path { get; }
+        public override void GetObjectData(SerializationInfo info, StreamingContext context);
+    }
-    public sealed class JsonReaderException : Exception {
 {
-        public JsonReaderException(string message, long lineNumber, long bytePositionInLine);

-        public long BytePositionInLine { get; }

-        public long LineNumber { get; }

-        public override void GetObjectData(SerializationInfo info, StreamingContext context);

-    }
     public ref struct Utf8JsonReader {
+        public bool IsFinalBlock { get; }
+        public long TokenStartIndex { get; }
+        public byte[] GetBytesFromBase64();
+        public string GetComment();
+        public void Skip();
+        public bool TryGetBytesFromBase64(out byte[] value);
+        public bool TrySkip();
     }
     public sealed class Utf8JsonWriter : IAsyncDisposable, IDisposable {
+        public void WriteBase64String(ReadOnlySpan<byte> utf8PropertyName, ReadOnlySpan<byte> bytes);
+        public void WriteBase64String(ReadOnlySpan<char> propertyName, ReadOnlySpan<byte> bytes);
+        public void WriteBase64String(string propertyName, ReadOnlySpan<byte> bytes);
+        public void WriteBase64String(JsonEncodedText propertyName, ReadOnlySpan<byte> bytes);
+        public void WriteBase64StringValue(ReadOnlySpan<byte> bytes);
+        public void WriteBoolean(JsonEncodedText propertyName, bool value);
+        public void WriteNull(JsonEncodedText propertyName);
+        public void WriteNumber(JsonEncodedText propertyName, decimal value);
+        public void WriteNumber(JsonEncodedText propertyName, double value);
+        public void WriteNumber(JsonEncodedText propertyName, int value);
+        public void WriteNumber(JsonEncodedText propertyName, long value);
+        public void WriteNumber(JsonEncodedText propertyName, float value);
+        public void WriteNumber(JsonEncodedText propertyName, uint value);
+        public void WriteNumber(JsonEncodedText propertyName, ulong value);
+        public void WriteStartArray(JsonEncodedText propertyName);
+        public void WriteStartObject(JsonEncodedText propertyName);
+        public void WriteString(ReadOnlySpan<byte> utf8PropertyName, JsonEncodedText value);
+        public void WriteString(ReadOnlySpan<char> propertyName, JsonEncodedText value);
+        public void WriteString(string propertyName, JsonEncodedText value);
+        public void WriteString(JsonEncodedText propertyName, DateTime value);
+        public void WriteString(JsonEncodedText propertyName, DateTimeOffset value);
+        public void WriteString(JsonEncodedText propertyName, Guid value);
+        public void WriteString(JsonEncodedText propertyName, ReadOnlySpan<byte> utf8Value);
+        public void WriteString(JsonEncodedText propertyName, ReadOnlySpan<char> value);
+        public void WriteString(JsonEncodedText propertyName, string value);
+        public void WriteString(JsonEncodedText propertyName, JsonEncodedText value);
+        public void WriteStringValue(JsonEncodedText value);
     }
 }
```

