# System.IO.Pipelines

``` diff
 namespace System.IO.Pipelines {
     public class PipeOptions {
-        public PipeOptions(MemoryPool<byte> pool = null, PipeScheduler readerScheduler = null, PipeScheduler writerScheduler = null, long pauseWriterThreshold = (long)65536, long resumeWriterThreshold = (long)32768, int minimumSegmentSize = 4096, bool useSynchronizationContext = true);
+        public PipeOptions(MemoryPool<byte> pool = null, PipeScheduler readerScheduler = null, PipeScheduler writerScheduler = null, long pauseWriterThreshold = (long)-1, long resumeWriterThreshold = (long)-1, int minimumSegmentSize = -1, bool useSynchronizationContext = true);
     }
     public abstract class PipeReader {
+        public virtual ValueTask CompleteAsync(Exception exception = null);
-        public abstract void OnWriterCompleted(Action<Exception, object> callback, object state);
+        public virtual void OnWriterCompleted(Action<Exception, object> callback, object state);
     }
     public abstract class PipeWriter : IBufferWriter<byte> {
+        public virtual ValueTask CompleteAsync(Exception exception = null);
-        public abstract void OnReaderCompleted(Action<Exception, object> callback, object state);
+        public virtual void OnReaderCompleted(Action<Exception, object> callback, object state);
     }
     public class StreamPipeReaderOptions {
-        public StreamPipeReaderOptions(MemoryPool<byte> pool = null, int bufferSize = 4096, int minimumReadSize = 1024, bool leaveOpen = false);
+        public StreamPipeReaderOptions(MemoryPool<byte> pool = null, int bufferSize = -1, int minimumReadSize = -1, bool leaveOpen = false);
     }
     public class StreamPipeWriterOptions {
-        public StreamPipeWriterOptions(MemoryPool<byte> pool = null, int minimumBufferSize = 4096, bool leaveOpen = false);
+        public StreamPipeWriterOptions(MemoryPool<byte> pool = null, int minimumBufferSize = -1, bool leaveOpen = false);
     }
 }
```

